# 尿液檢體 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Specimen: 尿液檢體

### 尿液樣本

**檢體狀態**：Available ([SpecimenStatus](http://hl7.org/fhir/specimen-status)#available)

**檢體類型**：Urine ([SpecimenType](http://snomed.info/sct)#122575003)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**病人採檢前禁食狀況**：Patient was fasting prior to the procedure. ([v2 Relevant Clincial Information](http://terminology.hl7.org/CodeSystem/v2-0916)#F)

**檢查者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

> **檢體資料****採集檢體的時間**：2023-11-06T09:00:00
**執行檢體採集的技術**：尿液採集(Urine examination)([SNOMED CT](http://snomed.info/sct)#167217005)
**解剖採集部位**：尿道(Urethra part)([SNOMED CT](http://snomed.info/sct)#119222001)
**採集檢體的數量**：50 mL

> **檢體處理資料****處理步驟**：尿液檢驗試紙分析
**檢體處理的日期和時間**：2023-11-06T09:30:00
**檢體容器資料****容器類別**：Urine specimen container([SNOMED CT](http://snomed.info/sct)#706054001)
**容器說明**：尿液檢體容器
**容器的大小**：60 mL
**容器內的檢體量**：50 mL

**備註**：此尿液樣本來自患者的尿液分析



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "spe-ur-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
    ]
  },
  "status" : "available",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "122575003",
        "display" : "Urine specimen"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-example",
    "display" : "陳加玲"
  },
  "receivedTime" : "2023-11-06T09:00:00.000Z",
  "collection" : {
    "collector" : {
      "reference" : "Practitioner/pra-dr-example",
      "display" : "王依昇"
    },
    "collectedDateTime" : "2023-11-06T08:30:08.000Z",
    "quantity" : {
      "value" : 50,
      "unit" : "mL"
    },
    "method" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "167217005",
          "display" : "Urine examination"
        }
      ],
      "text" : "尿液採集"
    },
    "bodySite" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "119222001",
          "display" : "Urethra part"
        }
      ],
      "text" : "尿道"
    },
    "fastingStatusCodeableConcept" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0916",
          "code" : "F",
          "display" : "Patient was fasting prior to the procedure."
        }
      ]
    }
  },
  "processing" : [
    {
      "description" : "尿液檢驗試紙分析",
      "timeDateTime" : "2023-11-06T09:30:00Z"
    }
  ],
  "container" : [
    {
      "description" : "尿液檢體容器",
      "type" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "706054001",
            "display" : "Urine specimen container"
          }
        ]
      },
      "capacity" : {
        "value" : 60,
        "unit" : "mL"
      },
      "specimenQuantity" : {
        "value" : 50,
        "unit" : "mL"
      }
    }
  ],
  "note" : [
    {
      "text" : "此尿液樣本來自患者的尿液分析"
    }
  ]
}

```
