# 組織檢體 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Specimen: 組織檢體

### 組織樣本

**檢體狀態**：Available ([SpecimenStatus](http://hl7.org/fhir/specimen-status)#available)

**檢體類型**：Skin lesion sample ([SpecimenType](http://snomed.info/sct)#309068002)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**病人採檢前禁食狀況**：Fasting not asked of the patient at time of procedure. ([v2 Relevant Clincial Information](http://terminology.hl7.org/CodeSystem/v2-0916)#FNA)

**檢查者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

> **檢體資料****採集檢體的時間**：2023-11-07T08:30:08
**執行檢體採集的技術**：Procedure on tissue specimen([SNOMED CT](http://snomed.info/sct)#430820001)
**解剖採集部位**：肺部(Lung part)([SNOMED CT](http://snomed.info/sct)#119199005)
**採集檢體的數量**：2 g

> **檢體處理資料****處理步驟**：顯微鏡檢查(Examination of organ under microscope)([SNOMED CT](http://snomed.info/sct)#309733006)
**檢體處理的日期和時間**：2023-11-07T09:30:00
**檢體容器資料****容器類型**：Fecal specimen container([SNOMED CT](http://snomed.info/sct)#706047007)
**容器說明**：組織儲存容器
**容器的大小**：20 mL
**容器內的檢體量**：10 g

**備註**：此組織樣本來自患者的肺部手術組織



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "spe-ance-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
    ]
  },
  "status" : "available",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "309068002",
        "display" : "Skin lesion sample"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-example",
    "display" : "陳加玲"
  },
  "receivedTime" : "2023-11-07T09:00:00.000Z",
  "collection" : {
    "collector" : {
      "reference" : "Practitioner/pra-dr-example",
      "display" : "王依昇"
    },
    "collectedDateTime" : "2023-11-07T08:30:08.000Z",
    "quantity" : {
      "value" : 2,
      "unit" : "g"
    },
    "method" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "430820001",
          "display" : "Procedure on tissue specimen"
        }
      ],
      "text" : "組織樣本採集"
    },
    "bodySite" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "119199005",
          "display" : "Lung part"
        }
      ],
      "text" : "肺部"
    },
    "fastingStatusCodeableConcept" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0916",
          "code" : "FNA",
          "display" : "Fasting not asked of the patient at time of procedure."
        }
      ]
    }
  },
  "processing" : [
    {
      "description" : "顯微鏡檢查",
      "procedure" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "309733006",
            "display" : "Examination of organ under microscope"
          }
        ],
        "text" : "Examination of organ under microscope"
      },
      "timeDateTime" : "2023-11-07T09:30:00.000Z"
    }
  ],
  "container" : [
    {
      "description" : "組織儲存容器",
      "type" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "706047007",
            "display" : "Fecal specimen container"
          }
        ]
      },
      "capacity" : {
        "value" : 20,
        "unit" : "mL"
      },
      "specimenQuantity" : {
        "value" : 10,
        "unit" : "g"
      }
    }
  ],
  "note" : [
    {
      "text" : "此組織樣本來自患者的肺部手術組織"
    }
  ]
}

```
