# 服務請求 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example ServiceRequest: 服務請求

Profile: [TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)

**status**: Active

**intent**: Order

**category**: Surgical procedure (procedure)

**code**: Excision of lesion of patella (procedure)

**subject**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)

**occurrence**: 2021-11-20

**authoredOn**: 2021-11-12 10:59:38-0800

**requester**: [Practitioner 王依昇(official)](Practitioner-pra-dr-example.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "sr-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "387713003",
          "display" : "Surgical procedure (procedure)"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "104001",
        "display" : "Excision of lesion of patella (procedure)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "occurrenceDateTime" : "2021-11-20",
  "authoredOn" : "2021-11-12T10:59:38-08:00",
  "requester" : {
    "reference" : "Practitioner/pra-dr-example"
  }
}

```
