# 子宮超音波 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Procedure: 子宮超音波

### 處置或手術基本資料

**處置或手術狀態**：completed

**處置或手術的識別碼**：子宮超音波 ([臺灣2021年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2021-tw.md)#BU46ZZZ)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**執行時間**：2022-08-12

**診斷者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**身體部位**：Gravid uterus ([SNOMED CT](https://browser.ihtsdotools.org/)#9258009)

### 執行處置或手術的人員

| | | |
| :--- | :--- | :--- |
| - | **角色** | **所屬機構** |
| * | [Practitioner/pra-dr-example](Practitioner-pra-dr-example.md)"王依昇" | [Organization/org-hosp-example](Organization-org-hosp-example.md)"衛生福利部臺北醫院" |



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "pro-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore"
    ]
  },
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2021-tw",
        "code" : "BU46ZZZ"
      }
    ],
    "text" : "子宮超音波"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "performedDateTime" : "2022-08-12",
  "asserter" : {
    "reference" : "Practitioner/pra-dr-example"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/pra-dr-example"
      },
      "onBehalfOf" : {
        "reference" : "Organization/org-hosp-example"
      }
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "9258009"
        }
      ]
    }
  ]
}

```
