# 闌尾切除 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Procedure: 闌尾切除

### 處置或手術基本資料

**處置或手術狀態**：completed

**處置或手術的識別碼**：闌尾切除術(Appendectomy) ([SNOMED CT](http://snomed.info/sct)#80146002)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**執行時間**：2023-11-10T14:00:00

**處置或手術的結果識別碼**：闌尾成功切除(Appendix absent) ([SNOMED CT](http://snomed.info/sct)#300309008)

**追蹤說明識別碼**： Bone immobilization ([SNOMED CT](http://snomed.info/sct)#274474001)



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "pro-appendectomy-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore"
    ]
  },
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "80146002",
        "display" : "Appendectomy"
      }
    ],
    "text" : "闌尾切除術"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "performedDateTime" : "2023-11-10T14:00:00Z",
  "outcome" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "300309008",
        "display" : "Appendix absent"
      }
    ],
    "text" : "闌尾成功切除"
  },
  "followUp" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "274474001",
          "display" : "Bone immobilization"
        }
      ]
    }
  ]
}

```
