# 醫事放射師 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example PractitionerRole: 醫事放射師

### 醫學放射技師角色基本資料

**識別碼型別**：Medical License number （[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#MD）
**員工編號（official）**： KP00018 （https://www.tph.mohw.gov.tw）

**紀錄狀態（active）**：使用中

**授權可執業時間範圍**：2022-07-31 ～ 2024-07-31

**健康照護服務提供者**：[Practitioner/pra-radio-example](Practitioner-pra-radio-example.md) "王曉明"

**地點**：[Location/loc-hrad-example](Location-loc-hrad-example.md) "衛生福利部臺北醫院X光室"

**角色**： 醫學放射技師（Medical radiographer) （[SNOMED CT](http://snomed.info/sct)#159016003）

**角色專業**：放射線科(Radiology - specialty (qualifier value)) （[SNOMED CT](http://snomed.info/sct)#394914008）

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0993277827（[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡時間**：週一 ～ 週五 ， 08:00-16:00
**聯絡注意事項**：若遇到緊急狀況可能會影響工作日。

**此期間無提供服務**：2023-08-01 ～ 2023-08-15
**無法提供原因**： 家中有事請假。



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "praro-radio-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MD"
          }
        ]
      },
      "system" : "https://www.tph.mohw.gov.tw",
      "value" : "KP00018"
    }
  ],
  "active" : true,
  "period" : {
    "start" : "2022-07-31",
    "end" : "2024-07-31"
  },
  "practitioner" : {
    "reference" : "Practitioner/pra-radio-example",
    "display" : "王曉明"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "159016003",
          "display" : "Medical radiographer"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "394914008",
          "display" : "Radiology - specialty (qualifier value)"
        }
      ]
    }
  ],
  "location" : [
    {
      "reference" : "Location/loc-hrad-example",
      "display" : "衛生福利部臺北醫院X光室"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0993277827",
      "use" : "mobile"
    }
  ],
  "availableTime" : [
    {
      "daysOfWeek" : ["mon", "tue", "wed", "thu", "fri"],
      "allDay" : false,
      "availableStartTime" : "08:00:00",
      "availableEndTime" : "16:00:00"
    }
  ],
  "notAvailable" : [
    {
      "description" : "家中有事請假",
      "during" : {
        "start" : "2023-08-01",
        "end" : "2023-08-15"
      }
    }
  ],
  "availabilityExceptions" : "若遇到緊急狀況可能會影響工作日"
}

```
