# 醫師 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Practitioner: 醫師

### 醫師基本資料

> **識別碼型別**：National Person Identifier（[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#NNxxx）
**身分證字號（official）**：D123456789 （http://www.moi.gov.tw）

> **識別碼型別**：Medical License number（[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#MD）
**員工編號（official）**：KP00017 （https://www.tph.mohw.gov.tw）

**健康照護服務提供者的紀錄（active）**：使用中

**姓名（official）**：王依昇 Wang, Yi Sheng

**性別**：男性

**出生日期**：1980-11-11

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0993277826（[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡電話使用效期**：2022-07-31至2024-07-31

**聯絡地址**：(330)桃園市桃園區五福五街31號
**郵遞區號（postalCode）[extension:[tw-postal-code](StructureDefinition-tw-postal-code.md)]**：[330](CodeSystem-postal-code3-tw.md)
**縣/市（district）**：桃園市
**鄉/鎮/市/區（city）**：桃園區
**路/街（line）**：五福五街
**號（number）[extension:[tw-number](StructureDefinition-tw-number.md)]**：31號
**國家（country）**：臺灣

**資格證書的型別**：西醫師 （[SNOMED CT](http://snomed.info/sct)#394802001）
**資格證書的開始日期**：2005-05-25

**照護服務提供人員影像**： [doctor.png](https://1.bp.blogspot.com/-6dSaKA-5r0c/UZSs9HLyutI/AAAAAAAATBc/lxpq2MB3_mc/s400/doctor.png)
![](https://1.bp.blogspot.com/-6dSaKA-5r0c/UZSs9HLyutI/AAAAAAAATBc/lxpq2MB3_mc/s400/doctor.png)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "pra-dr-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NNxxx"
          }
        ]
      },
      "system" : "http://www.moi.gov.tw",
      "value" : "D123456789"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MD"
          }
        ]
      },
      "system" : "https://www.tph.mohw.gov.tw",
      "value" : "KP00017"
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "text" : "王依昇",
      "family" : "Wang",
      "given" : ["Yi Sheng"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0993277826",
      "use" : "mobile",
      "period" : {
        "start" : "2022-07-31",
        "end" : "2024-07-31"
      }
    }
  ],
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
          "valueString" : "31號"
        }
      ],
      "text" : "桃園市桃園區五福五街31號",
      "line" : ["五福五街"],
      "city" : "桃園區",
      "district" : "桃園市",
      "_postalCode" : {
        "extension" : [
          {
            "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                  "code" : "330"
                }
              ]
            }
          }
        ]
      },
      "country" : "TW"
    }
  ],
  "gender" : "male",
  "birthDate" : "1980-11-11",
  "photo" : [
    {
      "contentType" : "image/png",
      "data" : "TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlzIHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2YgdGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGludWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRoZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=",
      "url" : "doctor.png"
    }
  ],
  "qualification" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "394802001",
            "display" : "General medicine"
          }
        ]
      },
      "period" : {
        "start" : "2005-05-25"
      }
    }
  ]
}

```
