# 病人基本資料-身分證字號及病歷號 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Patient: 病人基本資料-身分證字號及病歷號

### 病人基本資料-身分證字號及病歷號

> **識別碼型別**：National Person Identifier（[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#NNxxx**[extension:[Identifier Suffix](StructureDefinition-identifier-suffix.md)]：**TWN）
**身分證字號（official）**：A123456789 （http://www.moi.gov.tw）

> **識別碼型別**：Medical record number（[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#MR）
**病歷號（official）**：8862168 （https://www.tph.mohw.gov.tw）

**病人的紀錄（active）**：使用中

**姓名（official）**：陳加玲 Chan, Chia Lin

**性別**：女性

**出生日期**：1990-01-01

**年齡[extension:[person-age](StructureDefinition-person-age.md)]**：32

**國籍[extension:[patient-nationality](http://hl7.org/fhir/StructureDefinition/patient-nationality)]**：（[ISO3166Part1](https://terminology.hl7.org/CodeSystem-ISO3166Part1.html)#TW）

**聯絡方式**：Phone （[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0911327999 （[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡電話使用效期**：2022-07-31至2024-07-31

**聯絡地址**：(103)臺北市大同區大有里19鄰承德路三段52巷6弄210號2樓B室
**郵遞區號（postalCode） [extension:[tw-postal-code](StructureDefinition-tw-postal-code.md)]**： [103](CodeSystem-postal-code3-tw.md)
**縣/市（district）**：臺北市
**鄉/鎮/市/區（city）**：大同區
**村(里)（village） [extension:[tw-village](StructureDefinition-tw-village.md)]**：大有里
**鄰（neighborhood） [extension:[tw-neighborhood](StructureDefinition-tw-neighborhood.md)]**：19鄰
**路/街（line）**：承德路
**段(section) [extension:[tw-section](StructureDefinition-tw-section.md)]**：三段
**巷/衖（lane） [extension:[tw-lane](StructureDefinition-tw-lane.md)]**：52巷
**弄（alley） [extension:[tw-alley](StructureDefinition-tw-alley.md)]**：6弄
**號（number） [extension:[tw-number](StructureDefinition-tw-number.md)]**：210號
**樓（floor） [extension:[tw-floor](StructureDefinition-tw-floor.md)]**：2樓
**室（room） [extension:[tw-room](StructureDefinition-tw-room.md)]**：B室
**國家（country）**：臺灣


**婚姻狀態**：unmarried （[臺灣婚姻狀態值集](http://terminology.hl7.org/CodeSystem/v3-MaritalStatus)#U）

**聯絡人（official）**：李立偉 Li, Li Wei
**關係**：father （[PatientRelationshipType](http://terminology.hl7.org/CodeSystem/v3-RoleCode)#FTH）
**聯絡方式**：Phone （[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0917159753 （[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡電話使用效期**：2022-07-31至2024-07-31

**向病人說明健康狀態時所使用的語言**：中文

**紀錄的保管機構**： [Organization/org-hosp-example](Organization-org-hosp-example.md) "衛生福利部臺北醫院"

**病人影像**： [patient.png](https://2.bp.blogspot.com/-v3yEwItkXKQ/VaMN_1Nx6TI/AAAAAAAAvhM/zDXN_eZw_UE/s800/youngwoman_42.png)
![](https://2.bp.blogspot.com/-v3yEwItkXKQ/VaMN_1Nx6TI/AAAAAAAAvhM/zDXN_eZw_UE/s800/youngwoman_42.png)



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "pat-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
    ]
  },
  "extension" : [
    {
      "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/person-age",
      "valueAge" : {
        "value" : 32,
        "system" : "http://unitsofmeasure.org",
        "code" : "a"
      }
    },
    {
      "extension" : [
        {
          "url" : "code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "TW"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-nationality"
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NNxxx",
            "_code" : {
              "extension" : [
                {
                  "extension" : [
                    {
                      "url" : "suffix",
                      "valueString" : "TWN"
                    },
                    {
                      "url" : "valueSet",
                      "valueCanonical" : "http://hl7.org/fhir/ValueSet/iso3166-1-3"
                    }
                  ],
                  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/identifier-suffix"
                }
              ]
            }
          }
        ]
      },
      "system" : "http://www.moi.gov.tw",
      "value" : "A123456789"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR"
          }
        ]
      },
      "system" : "https://www.tph.mohw.gov.tw",
      "value" : "8862168"
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "text" : "陳加玲",
      "family" : "Chen",
      "given" : ["Chia Lin"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0911327999",
      "use" : "mobile",
      "period" : {
        "start" : "2022-07-31",
        "end" : "2024-07-31"
      }
    }
  ],
  "gender" : "female",
  "birthDate" : "1990-01-01",
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-section",
          "valueString" : "三段"
        },
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
          "valueString" : "210號"
        },
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-village",
          "valueString" : "大有里"
        },
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-neighborhood",
          "valueString" : "19鄰"
        },
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-lane",
          "valueString" : "52巷"
        },
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-alley",
          "valueString" : "6弄"
        },
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-floor",
          "valueString" : "2樓"
        },
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-room",
          "valueString" : "B室"
        }
      ],
      "text" : "臺北市大同區大有里19鄰承德路三段52巷6弄210號2樓B室",
      "line" : ["承德路"],
      "city" : "大同區",
      "district" : "臺北市",
      "_postalCode" : {
        "extension" : [
          {
            "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                  "code" : "103"
                }
              ]
            }
          }
        ]
      },
      "country" : "TW"
    }
  ],
  "maritalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
        "code" : "U"
      }
    ]
  },
  "photo" : [
    {
      "contentType" : "image/jpeg",
      "url" : "patient.png"
    }
  ],
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "FTH"
            }
          ]
        }
      ],
      "name" : {
        "use" : "official",
        "text" : "李立偉",
        "family" : "Li",
        "given" : ["Li Wei"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "0917159753",
          "use" : "mobile",
          "period" : {
            "start" : "2022-07-31",
            "end" : "2024-07-31"
          }
        }
      ]
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "zh-TW"
          }
        ]
      }
    }
  ],
  "managingOrganization" : {
    "reference" : "Organization/org-hosp-example"
  }
}

```
