# 機構基本資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Organization: 機構基本資料

### 機構基本資料

**機構名稱**：國立臺灣大學醫學院附設醫院

**機構識別碼**：0132010014 (https://twcore.mohw.gov.tw/tsfhir/CodeSystem/organization-identifier-tw)

**識別碼型別**：Provider number（[IdentifierType](http://terminology.hl7.org/CodeSystem/v2-0203)#PRN）

**機構的紀錄（active）**：使用中

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡信箱（work）**：03-369-9721

**機構地址（work）**：(330)桃園市桃園區中山路1492號
**郵遞區號（postalCode）**：330 **縣/市（district）**：桃園市
**鄉/鎮/市/區（city）**：桃園區
**路/街（line）**：中山路
**號（number）**[extension: [tw-number](StructureDefinition-tw-number.md)]：1492號
**國家（country）**：臺灣



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "org-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PRN"
          }
        ]
      },
      "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw",
      "value" : "0132010014"
    }
  ],
  "active" : true,
  "name" : "衛生福利部桃園醫院",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "03-369-9721",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
          "valueString" : "1492號"
        }
      ],
      "use" : "work",
      "text" : "330桃園市桃園區中山路1492號",
      "line" : ["中山路"],
      "city" : "桃園區",
      "district" : "桃園市",
      "postalCode" : "330",
      "country" : "TW"
    }
  ]
}

```
