# 公司行號基本資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Organization: 公司行號基本資料

### 公司行號基本資料

**機構名稱**：莉梓股份有限公司

**識別碼型別**：Unified Business number（[臺灣識別碼類型值集](CodeSystem-v2-0203.md)#UBN）
**公司或企業統一編號（official）**：06100268 (https://gcis.nat.gov.tw)

**機構種類**：Non-Healthcare Business or Corporation （[OrganizationType](http://hl7.org/fhir/R4/codesystem-organization-type.html)#bus）

**聯絡方式**：Email（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#email）
**聯絡信箱**：litzu@qmail.com



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "org-co-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-co-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/v2-0203",
            "code" : "UBN"
          }
        ]
      },
      "system" : "https://gcis.nat.gov.tw",
      "value" : "06100268"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "bus"
        }
      ]
    }
  ],
  "name" : "莉梓股份有限公司",
  "telecom" : [
    {
      "system" : "email",
      "value" : "litzu@qmail.com"
    }
  ]
}

```
