# 生命體徵資料-臺灣核心-呼吸速率 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Observation: 生命體徵資料-臺灣核心-呼吸速率

Profile: [TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md)

**status**: Final

**category**: Vital Signs

**code**: respiratory_rate

**subject**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)

**encounter**: [Encounter: identifier = http://healthcare.example.org/identifiers/enocunter#E22081702; status = finished; class = pre-admission (ActCode#PRENC); type = Annual diabetes mellitus screening; serviceType = Nephrology (qualifier value); period = 2022-08-01 17:00:14+0800 --> 2022-08-01 18:00:14+0800; reasonCode = FH: Diabetes mellitus](Encounter-enc-example.md)

**effective**: 1999-07-02

**value**: 26 breaths per minute(Details: UCUM code/min = '/min')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-respiratory-rate-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-respiratory-rate-twcore"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "9279-1",
        "display" : "Respiratory rate"
      }
    ],
    "text" : "respiratory_rate"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "encounter" : {
    "reference" : "Encounter/enc-example"
  },
  "effectiveDateTime" : "1999-07-02",
  "valueQuantity" : {
    "value" : 26,
    "unit" : "breaths per minute",
    "system" : "http://unitsofmeasure.org",
    "code" : "/min"
  }
}

```
