# 妊娠狀態 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Observation: 妊娠狀態

Profile: [TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md)

**status**: Final

**category**: Social History

**code**: Pregnancy Status

**subject**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)

**effective**: 2022-09-23 22:39:43+0000

**performer**: [Organization 衛生福利部臺北醫院](Organization-org-hosp-example.md)

**value**: Pregnant



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-pregnancy-status-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pregnancy-status-twcore"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "82810-3",
        "display" : "Pregnancy status"
      }
    ],
    "text" : "Pregnancy Status"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2022-09-23T22:39:43Z",
  "performer" : [
    {
      "reference" : "Organization/org-hosp-example"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "77386006",
        "display" : "Pregnancy"
      }
    ],
    "text" : "Pregnant"
  }
}

```
