# 妊娠計畫 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Observation: 妊娠計畫

Profile: [TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md)

**status**: Final

**category**: Social History

**code**: Pregnancy Intent

**subject**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)

**effective**: 2022-09-23 22:39:43+0000

**performer**: [Organization 衛生福利部臺北醫院](Organization-org-hosp-example.md)

**value**: Yes, I want to become pregnant



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-pregnancy-intent-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pregnancy-intent-twcore"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "86645-9",
        "display" : "Pregnancy intention in the next year - Reported"
      }
    ],
    "text" : "Pregnancy Intent"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2022-09-23T22:39:43Z",
  "performer" : [
    {
      "reference" : "Organization/org-hosp-example"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26438-4",
        "display" : "Yes, I want to become pregnant"
      }
    ]
  }
}

```
