# 實驗室檢驗檢查-使用臺灣醫療服務給付項目-檢驗值集代碼 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Observation: 實驗室檢驗檢查-使用臺灣醫療服務給付項目-檢驗值集代碼

### 檢驗檢查資料

**狀態**：最終版(final)

**分類**：Laboratory ([Observation Category Codes](http://hl7.org/fhir/R4/codesystem-observation-category.html)#laboratory)

**檢驗項目**：血中尿素氮 ([臺灣醫療服務給付項目](CodeSystem-medical-service-payment-tw.md)#09002C)

**病人**： [Patient/pat-example](Patient-pat-example.md) "陳加玲"

**執行日期**：2022-07-31

**負責機構**： [Organization/org-hosp-example](Organization-org-hosp-example.md) "衛生福利部臺北醫院"

**檢驗值**：16.6 mg/dL



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-lab-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw",
        "code" : "09002C"
      }
    ],
    "text" : "血中尿素氮"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2022-07-31",
  "performer" : [
    {
      "reference" : "Organization/org-hosp-example"
    }
  ],
  "valueQuantity" : {
    "value" : 16.6,
    "unit" : "mg/dL"
  }
}

```
