# 生命體徵資料-血壓 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Observation: 生命體徵資料-血壓

### 檢驗檢查資料

**狀態**：final

**分類**：Vital Signs ([Observation Category Codes](http://hl7.org/fhir/R4/codesystem-observation-category.html)#vital-signs)

**檢驗項目**：Blood pressure panel with all children optional ([LOINC](http://loinc.org)#85354-9 "Blood pressure panel with all children optional")

**病人**： [Patient/pat-example](Patient-pat-example.md) "陳加玲"

**檢查者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**執行日期**：2022-07-31

**檢驗結果**

> **檢驗項目**：Systolic blood pressure([LOINC](http://loinc.org)#8480-6)**檢驗值**：110 mmHg

> **檢驗項目**：Diastolic blood pressure([LOINC](http://loinc.org)#8462-4)**檢驗值**：56 mmHg



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-bloodPressure-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-bloodPressure-twcore"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "85354-9",
        "display" : "Blood pressure panel with all children optional"
      }
    ],
    "text" : "Blood pressure panel with all children optional"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2022-07-31",
  "performer" : [
    {
      "reference" : "Practitioner/pra-dr-example"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8480-6",
            "display" : "Systolic blood pressure"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 110,
        "unit" : "mmHg",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8462-4",
            "display" : "Diastolic blood pressure"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 56,
        "unit" : "mmHg",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    }
  ]
}

```
