# 平均血壓 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Observation: 平均血壓

Profile: [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md)

**status**: Final

**category**: Vital Signs

**code**: 平均血壓

**subject**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)

**effective**: 2024-01-01

**performer**: [Practitioner 陳莉(official)](Practitioner-pra-nurse-example.md)

> **component****code**:Systolic blood pressure mean**value**: 120 mm[Hg](Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**:Diastolic blood pressure mean**value**: 80 mm[Hg](Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**:Number of occurrences**value**: 3



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-averageBloodPressure-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-averageBloodPressure-twcore"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "96607-7",
        "display" : "Blood pressure panel mean systolic and mean diastolic"
      }
    ],
    "text" : "平均血壓"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2024-01-01",
  "performer" : [
    {
      "reference" : "Practitioner/pra-nurse-example"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "96608-5"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 120,
        "unit" : "mm[Hg]",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "96609-3"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 80,
        "unit" : "mm[Hg]",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "246432004"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 3
      }
    }
  ]
}

```
