# 第一型糖尿病的用藥聲明資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example MedicationStatement: 第一型糖尿病的用藥聲明資料

### 第一型糖尿病的用藥聲明資料

**用藥聲明的狀態**：Active ([Medication Status Codes](http://hl7.org/fhir/R4/codesystem-medication-statement-status.html)#active)

**用藥聲明的分類**： Outpatient ([MedicationDispense Category Codes](http://hl7.org/fhir/R4/codesystem-medication-statement-category.html)#outpatient)

**藥品**：爽胰達注射劑100單位+50微克(ASPIRIN TABLETS 500MG S.Y.) ([臺灣食藥署藥品許可證](CodeSystem-medication-fda-tw.md)#衛部菌疫輸字第001080號)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**用藥的日期與時間**：2023-11-05T08:00:00

**提出聲明日期與時間**：2023-11-05T10:00:00

**聲明原因**：第一型糖尿病(Type 1 diabetes mellitus) ([SNOMED CT](http://snomed.info/sct)#46635009)

> **藥品使用方式：****使用時間**：每日使用1次
**方式**：皮下注射(SC use)([SNOMED CT](http://snomed.info/sct)#34206005)
**備註**：每日注射一次，於餐前一小時內注射，建議固定在同一餐的餐前注射。



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "med-sta-injection-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore"
    ]
  },
  "status" : "active",
  "category" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medication-statement-category",
        "code" : "outpatient",
        "display" : "outpatient"
      }
    ],
    "text" : "門診"
  },
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw",
        "code" : "衛部菌疫輸字第001080號",
        "display" : "爽胰達注射劑100單位+50微克"
      }
    ],
    "text" : "爽胰達注射劑100單位+50微克"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2023-11-05T08:00:00+08:00",
  "dateAsserted" : "2023-11-05T10:00:00+08:00",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "46635009",
          "display" : "Type 1 diabetes mellitus"
        }
      ],
      "text" : "第一型糖尿病"
    }
  ],
  "note" : [
    {
      "text" : "每日注射一次，於餐前一小時內注射，建議固定在同一餐的餐前注射"
    }
  ],
  "dosage" : [
    {
      "text" : "每日注射一次，於餐前一小時內注射",
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "34206005",
            "display" : "SC use"
          }
        ],
        "text" : "皮下注射"
      }
    }
  ]
}

```
