# 慢性結膜炎的用藥聲明資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example MedicationStatement: 慢性結膜炎的用藥聲明資料

### 慢性結膜炎的用藥聲明資料

**用藥聲明的狀態**：Active ([Medication Status Codes](http://hl7.org/fhir/R4/codesystem-medication-statement-status.html)#active)

**用藥聲明的分類**： Outpatient ([MedicationDispense Category Codes](http://hl7.org/fhir/R4/codesystem-medication-statement-category.html)#outpatient)

**藥品**：鹽酸四環素眼藥膏([臺灣食藥署藥品許可證](CodeSystem-medication-fda-tw.md)#內衛藥製字第006008號)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**用藥的日期與時間**：2023-11-05T08:00:00

**提出聲明日期與時間**：2023-11-05T10:00:00

**聲明原因**：慢性結膜炎(Simple chronic conjunctivitis) ([SNOMED CT](http://snomed.info/sct)#8211008)

> **藥品使用方式：****使用時間**：每日使用2次
**方式**：外用(Topical route)([SNOMED CT](http://snomed.info/sct)#6064005)
**備註**：每天早晚塗抹發炎處。



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "med-sta-inflamed-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore"
    ]
  },
  "status" : "active",
  "category" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medication-statement-category",
        "code" : "outpatient",
        "display" : "outpatient"
      }
    ],
    "text" : "門診"
  },
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw",
        "code" : "內衛藥製字第006008號",
        "display" : "鹽酸四環素眼藥膏"
      }
    ],
    "text" : "鹽酸四環素眼藥膏"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2023-11-05T08:00:00+08:00",
  "dateAsserted" : "2023-11-05T10:00:00+08:00",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "8211008",
          "display" : "Simple chronic conjunctivitis"
        }
      ],
      "text" : "慢性結膜炎"
    }
  ],
  "note" : [
    {
      "text" : "每天早晚塗抹發炎處"
    }
  ],
  "dosage" : [
    {
      "text" : "每天早晚塗抹發炎處",
      "timing" : {
        "repeat" : {
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "6064005",
            "display" : "Topical route"
          }
        ],
        "text" : "外用"
      }
    }
  ]
}

```
