# 胰臟炎的用藥聲明資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example MedicationStatement: 胰臟炎的用藥聲明資料

### 胰臟炎的用藥聲明資料

**用藥聲明的狀態**：Active ([Medication Status Codes](http://hl7.org/fhir/R4/codesystem-medication-statement-status.html)#active)

**用藥聲明的分類**： Outpatient ([MedicationDispense Category Codes](http://hl7.org/fhir/R4/codesystem-medication-statement-category.html)#outpatient)

**藥品**：阿司匹林(ASPIRIN TABLETS 500MG S.Y.) ([臺灣健保用藥品項](CodeSystem-medication-nhi-tw.md)#A003092100)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**用藥的日期與時間**：2023-11-05T08:00:00

**提出聲明日期與時間**：2023-11-05T10:00:00

**聲明原因**：胰臟炎(Apoplectic pancreatitis) ([SNOMED CT](http://snomed.info/sct)#303002)

> **藥品使用方式：****時間間隔**：2 per 1 days
**方式**：口服(Oral route)([SNOMED CT](http://snomed.info/sct)#26643006)
**備註**：每日早晚各一次，每次一片。



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "med-sta-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore"
    ]
  },
  "status" : "active",
  "category" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medication-statement-category",
        "code" : "outpatient",
        "display" : "outpatient"
      }
    ],
    "text" : "門診"
  },
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-nhi-tw",
        "code" : "A003092100",
        "display" : "ASPIRIN TABLETS 500MG"
      }
    ],
    "text" : "阿司匹林"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2023-11-05T08:00:00+08:00",
  "dateAsserted" : "2023-11-05T10:00:00+08:00",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "303002",
          "display" : "Apoplectic pancreatitis"
        }
      ],
      "text" : "胰臟炎"
    }
  ],
  "note" : [
    {
      "text" : "每日早晚各一次"
    }
  ],
  "dosage" : [
    {
      "text" : "每次一片",
      "timing" : {
        "repeat" : {
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006",
            "display" : "Oral route"
          }
        ],
        "text" : "口服"
      }
    }
  ]
}

```
