# 藥品請求資料(medicationReference) - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example MedicationRequest: 藥品請求資料(medicationReference)

### 藥品請求的詳細資料

**藥品請求的識別碼**：7077 （http://www.moi.gov.tw）

**藥品請求的狀態**：Active ([MedicationRequest Status Reason Codes](http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason)#clarif)

**藥品請求的意圖**：Order ([medicationRequest Intent](http://hl7.org/fhir/CodeSystem/medicationrequest-intent)#order)

**藥品請求的類別**：Discharge ([MedicationRequest Category Codes](http://terminology.hl7.org/CodeSystem/medicationrequest-category)#discharge)

**藥品**：[Medication/med-example](Medication-med-example.md)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**就醫事件**：[Encounter/enc-example](Encounter-enc-example.md)

**最初請求時間**：2022-08-01 06:00:14-0500

**提出藥品請求請求者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**開立處方的原因**：[Observation/obs-lab-example](Observation-obs-lab-example.md)

**處方可用以配藥的有效期限**：2022-08-01 06:00:14-0500 --> 2022-08-08 06:00:14-0500



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "med-req-ref-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore"
    ]
  },
  "identifier" : [
    {
      "system" : "http://www.moi.gov.tw",
      "value" : "7077"
    }
  ],
  "status" : "active",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason",
        "code" : "clarif"
      }
    ]
  },
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
          "code" : "discharge"
        }
      ]
    }
  ],
  "medicationReference" : {
    "reference" : "Medication/med-example"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "encounter" : {
    "reference" : "Encounter/enc-example"
  },
  "authoredOn" : "2022-08-01T18:00:14+08:00",
  "requester" : {
    "reference" : "Practitioner/pra-dr-example"
  },
  "reasonReference" : [
    {
      "reference" : "Observation/obs-lab-example"
    }
  ],
  "dosageInstruction" : [
    {
      "text" : "三餐飯後，口服",
      "timing" : {
        "code" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-frequency-nhi-tw",
              "code" : "PC"
            }
          ],
          "text" : "三餐飯後"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-path-tw",
            "code" : "PO"
          }
        ]
      },
      "doseAndRate" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/dose-rate-type",
                "code" : "ordered"
              }
            ]
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "validityPeriod" : {
      "start" : "2022-08-01T18:00:14+08:00",
      "end" : "2022-08-08T18:00:14+08:00"
    }
  }
}

```
