# 第二藥局地點資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Location: 第二藥局地點資料

### 第二藥局位置

**地點狀態**: Active ([LocationStatus](http://hl7.org/fhir/R4/codesystem-location-status.html)#active)

**地點類別**: Kind ([LocationMode](http://hl7.org/fhir/location-mode)#kind)

**地點類型**: Pharmacy ([RoleCode](https://terminology.hl7.org/CodeSystem-v3-RoleCode.html)#PHARM)

**地點資訊**: 提供各式人氣營養保健、樂齡輔具、醫美保養、母嬰用品等。

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）

**聯絡電話（work）**：02-2276-7777

**地點開放時間**：週一 ～ 週五



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "loc-pharm-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
    ]
  },
  "status" : "active",
  "name" : "第二藥局",
  "description" : "提供各式人氣營養保健、樂齡輔具、醫美保養、母嬰用品等",
  "mode" : "kind",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "PHARM",
          "display" : "Pharmacy"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "02-2276-7777",
      "use" : "work"
    }
  ],
  "hoursOfOperation" : [
    {
      "daysOfWeek" : ["mon", "tue", "wed", "thu", "fri"],
      "allDay" : false
    }
  ]
}

```
