# 衛生福利部臺北醫院耳鼻喉科地點資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Location: 衛生福利部臺北醫院耳鼻喉科地點資料

### 衛生福利部臺北醫院耳鼻喉科

**地點狀態**: Active ([LocationStatus](http://hl7.org/fhir/R4/codesystem-location-status.html)#active)

**地點類別**: Kind ([LocationMode](http://hl7.org/fhir/R4/valueset-location-mode.html)#kind)

**地點類型**: Otorhinolaryngology clinic ([RoleCode](https://terminology.hl7.org/CodeSystem-v3-RoleCode.html)#ENT)

**地點資訊**: 診治各種耳、鼻、咽、喉等上呼吸道疾病及頭頸部腫瘤 , 包括 : 感冒、咳嗽、頭痛、喉嚨痛、聲音沙啞、吞嚥困難、呼吸不順、鼻塞、鼻竇炎、鼻過敏、鼻息肉、扁桃腺肥大、耳鳴、耳痛、中耳炎、顏面神經麻痺、顎顳關節痛、口乾舌燥、打鼾、語言障礙、食道異物取出、頭頸部腫瘤、舌及口咽腫瘤手術。

**負責維護地點的機構**: [Organization/org-hosp-example](Organization-org-hosp-example.md) "衛生福利部臺北醫院"

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）

**聯絡電話（work）**：02-2276-5566

**聯絡地址（work）**：242新北市新莊區思源路127號

**地點開放時間**：週一 ～ 週五 ， 全天



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "loc-ent-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
    ]
  },
  "status" : "active",
  "name" : "衛生福利部臺北醫院耳鼻喉科",
  "description" : "診治各種耳、鼻、咽、喉等上呼吸道疾病及頭頸部腫瘤 , 包括 : 感冒、咳嗽、頭痛、喉嚨痛、聲音沙啞、吞嚥困難、呼吸不順、鼻塞、鼻竇炎、鼻過敏、鼻息肉、扁桃腺肥大、耳鳴、耳痛、中耳炎、顏面神經麻痺、顎顳關節痛、口乾舌燥、打鼾、語言障礙、食道異物取出、頭頸部腫瘤、舌及口咽腫瘤手術",
  "mode" : "kind",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "ENT",
          "display" : "Otorhinolaryngology clinic"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "02-2276-5566",
      "use" : "work"
    }
  ],
  "address" : {
    "use" : "work",
    "type" : "both",
    "text" : "242新北市新莊區思源路127號",
    "line" : ["思源路127號"],
    "city" : "新莊區",
    "district" : "新北市",
    "postalCode" : "242"
  },
  "position" : {
    "longitude" : 25.043085494729105,
    "latitude" : 121.45941895179722
  },
  "managingOrganization" : {
    "reference" : "Organization/org-hosp-example"
  },
  "hoursOfOperation" : [
    {
      "daysOfWeek" : ["mon", "tue", "wed", "thu", "fri"],
      "allDay" : true
    }
  ]
}

```
