# TW Core ImplementationGuide Resource - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## TW Core ImplementationGuide Resource

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ImplementationGuide/tw.gov.mohw.twcore | *Version*:1.0.0 |
| *NPM package name*: tw.gov.mohw.twcore | *Computable Name*:TWCore |

* [XML](ImplementationGuide-tw.gov.mohw.twcore.xml)
* [JSON](ImplementationGuide-tw.gov.mohw.twcore.json)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (tw.gov.mohw.twcore.r4)](package.r4.tgz) and [R4B (tw.gov.mohw.twcore.r4b)](package.r4b.tgz) are available. 

#### IG Dependencies

This IG Contains the following dependencies on other IGs.





#### Global Profiles

*There are no Global profiles defined*

#### Copyrights

This publication includes IP covered under the following statements.

* ISO Maintains the copyright on the country codes, and controls it's use carefully. For futher details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.0.0/CodeSystem-ISO3166Part1.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 4 more,[Bundle/bun-example](Bundle-bun-example.md),[Bundle/bun-message-request-example](Bundle-bun-message-request-example.md),[Patient/pat-child-example](Patient-pat-child-example.md)and[Patient/pat-example](Patient-pat-example.md)


* Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission. For information and exceptions regarding use of CDC material please see [https://www.cdc.gov/other/agencymaterials.html](https://www.cdc.gov/other/agencymaterials.html)

* [Vaccine Administered Code Set (CVX)](http://terminology.hl7.org/5.0.0/CodeSystem-CVX.html): [Immunization/imm-example](Immunization-imm-example.md) and [TWCoreImmunization](StructureDefinition-Immunization-twcore.md)


* Produced by HL7 under the terms of HL7® Governance and Operations Manual relating to Intellectual Property (Section 16), specifically its copyright, trademark and patent provisions. This document is licensed under Creative Commons "No Rights Reserved" (CC0).

* [Absent and Unknown Data - IPS](http://hl7.org/fhir/uv/ips/STU1.1/CodeSystem-absent-unknown-uv-ips.html): [TWCoreCondition](StructureDefinition-Condition-twcore.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/5.0.0/CodeSystem-v3-ucum.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 22 more,[Observation/obs-averageBloodPressure-example](Observation-obs-averageBloodPressure-example.md),[Observation/obs-bloodPressure-example](Observation-obs-bloodPressure-example.md),[Observation/obs-bmi-example](Observation-obs-bmi-example.md),[Observation/obs-clinical-result-example](Observation-obs-clinical-result-example.md),[Observation/obs-head-circumference-example](Observation-obs-head-circumference-example.md),[Observation/obs-heart-rate-example](Observation-obs-heart-rate-example.md),[Observation/obs-height-example](Observation-obs-height-example.md),[Observation/obs-ofc-percentile-example](Observation-obs-ofc-percentile-example.md),[Observation/obs-pediatric-bmi-age-example](Observation-obs-pediatric-bmi-age-example.md),[Observation/obs-pediatric-weight-height-example](Observation-obs-pediatric-weight-height-example.md),[Observation/obs-pulse-oximetry-example](Observation-obs-pulse-oximetry-example.md),[Observation/obs-respiratory-rate-example](Observation-obs-respiratory-rate-example.md),[Observation/obs-smoking-status-example](Observation-obs-smoking-status-example.md),[Observation/obs-temperature-example](Observation-obs-temperature-example.md),[Observation/obs-vital](Observation-obs-vital.md),[Observation/obs-weight-example](Observation-obs-weight-example.md),[Specimen/spe-blood-example](Specimen-spe-blood-example.md),[TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TWCoreObservationSmokingStatus](StructureDefinition-Observation-smoking-status-twcore.md)and[TWCoreObservationVitalSigns](StructureDefinition-Observation-vitalSigns-twcore.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright Â© 2011 by the National Electrical Manufacturers Association.

* DICOM Controlled Terminology Definitions: [AcquisitionModality](ValueSet-AcquisitionModality.md), [ImagingStudy/img-ct-example](ImagingStudy-img-ct-example.md)...Show 5 more,[ImagingStudy/img-example](ImagingStudy-img-example.md),[ImagingStudy/img-mr-example](ImagingStudy-img-mr-example.md),[ImagingStudy/img-pet-example](ImagingStudy-img-pet-example.md),[ImagingStudy/img-sm-example](ImagingStudy-img-sm-example.md)and[TWCoreImagingStudy](StructureDefinition-ImagingStudy-twcore.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/5.0.0/CodeSystem-v3-loinc.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 65 more,[Bundle/bun-message-request-example](Bundle-bun-message-request-example.md),[Bundle/bun-message-response-example](Bundle-bun-message-response-example.md),[Composition/com-example](Composition-com-example.md),[Composition/com-surgery-example](Composition-com-surgery-example.md),[Condition/con-example](Condition-con-example.md),[DocumentReference/doc-outpatient-example](DocumentReference-doc-outpatient-example.md),[DocumentReference/doc-wound-example](DocumentReference-doc-wound-example.md),[LOINCDocumentClass](ValueSet-loinc-document-classcodes.md),[LOINCDocumentSection](ValueSet-loinc-doc-section-code.md),[LOINCDocumentType](ValueSet-loinc-type-doc-code.md),[LOINCObservationCode](ValueSet-loinc-observation-code.md),[LOINCPregnancyIntentCode](ValueSet-loinc-pregnancy-intent-code.md),[LOINCSurveyCode](ValueSet-loinc-survey-codes.md),[MessageHeader/mes-request-example](MessageHeader-mes-request-example.md),[MessageHeader/mes-response-example](MessageHeader-mes-response-example.md),[Observation/obs-averageBloodPressure-example](Observation-obs-averageBloodPressure-example.md),[Observation/obs-bloodPressure-example](Observation-obs-bloodPressure-example.md),[Observation/obs-bmi-example](Observation-obs-bmi-example.md),[Observation/obs-careExp-example](Observation-obs-careExp-example.md),[Observation/obs-clinical-result-example](Observation-obs-clinical-result-example.md),[Observation/obs-ecg-example](Observation-obs-ecg-example.md),[Observation/obs-head-circumference-example](Observation-obs-head-circumference-example.md),[Observation/obs-heart-rate-example](Observation-obs-heart-rate-example.md),[Observation/obs-height-example](Observation-obs-height-example.md),[Observation/obs-loinc-example](Observation-obs-loinc-example.md),[Observation/obs-occupation-example](Observation-obs-occupation-example.md),[Observation/obs-ofc-percentile-example](Observation-obs-ofc-percentile-example.md),[Observation/obs-pediatric-bmi-age-example](Observation-obs-pediatric-bmi-age-example.md),[Observation/obs-pediatric-weight-height-example](Observation-obs-pediatric-weight-height-example.md),[Observation/obs-pregnancy-intent-example](Observation-obs-pregnancy-intent-example.md),[Observation/obs-pregnancy-status-example](Observation-obs-pregnancy-status-example.md),[Observation/obs-pulse-oximetry-example](Observation-obs-pulse-oximetry-example.md),[Observation/obs-respiratory-rate-example](Observation-obs-respiratory-rate-example.md),[Observation/obs-screening-assessment-example](Observation-obs-screening-assessment-example.md),[Observation/obs-sexual-orientation-example](Observation-obs-sexual-orientation-example.md),[Observation/obs-simple-example](Observation-obs-simple-example.md),[Observation/obs-temperature-example](Observation-obs-temperature-example.md),[Observation/obs-treatment-intervention-preference-example](Observation-obs-treatment-intervention-preference-example.md),[Observation/obs-vital](Observation-obs-vital.md),[Observation/obs-weight-example](Observation-obs-weight-example.md),[QuestionnaireResponse/qr-example](QuestionnaireResponse-qr-example.md),[SmokingStatusTypeCode](ValueSet-smoking-status-type-code.md),[TWCoreComposition](StructureDefinition-Composition-twcore.md),[TWCoreDiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md),[TWCoreDocumentReference](StructureDefinition-DocumentReference-twcore.md),[TWCoreObservationAverageBloodPressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TWCoreObservationCareExperiencePreference](StructureDefinition-Observation-careExperiencePreference-twcore.md),[TWCoreObservationClinicalResult](StructureDefinition-Observation-clinical-result-twcore.md),[TWCoreObservationECG](StructureDefinition-Observation-ecg-twcore.md),[TWCoreObservationOccupation](StructureDefinition-Observation-occupation-twcore.md),[TWCoreObservationPediatricBMIforAge](StructureDefinition-Observation-pediatric-bmi-age-twcore.md),[TWCoreObservationPediatricHeadOccipitalFrontalCircumferencePercentile](StructureDefinition-Observation-pediatric-head-circumference-twcore.md),[TWCoreObservationPediatricWeightforHeight](StructureDefinition-Observation-pediatric-weight-height-twcore.md),[TWCoreObservationPregnancyIntent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TWCoreObservationPregnancyStatus](StructureDefinition-Observation-pregnancy-status-twcore.md),[TWCoreObservationPulseOximetry](StructureDefinition-Observation-pulse-oximetry-twcore.md),[TWCoreObservationScreeningAssessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TWCoreObservationSexualOrientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TWCoreObservationSimple](StructureDefinition-Observation-simple-twcore.md),[TWCoreObservationSmokingStatus](StructureDefinition-Observation-smoking-status-twcore.md),[TWCoreObservationTreatmentInterventionPreference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TWCoreObservationVitalSigns](StructureDefinition-Observation-vitalSigns-twcore.md),[TWCoreProcedure](StructureDefinition-Procedure-twcore.md),[TWCoreServiceRequest](StructureDefinition-ServiceRequest-twcore.md)and[TWVitalSigns](ValueSet-vital-signs-tw.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AllergyIntolerance/all-cat-example](AllergyIntolerance-all-cat-example.md), [AllergyIntolerance/all-medication-example](AllergyIntolerance-all-medication-example.md)...Show 70 more,[AllergyIntolerance/all-nut-example](AllergyIntolerance-all-nut-example.md),[AllergyIntolerance/all-seafood-example](AllergyIntolerance-all-seafood-example.md),[Bundle/bun-document-example](Bundle-bun-document-example.md),[Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md),[Bundle/bun-message-request-example](Bundle-bun-message-request-example.md),[CareTeam/careteam-example](CareTeam-careteam-example.md),[Device/dev-example](Device-dev-example.md),[Encounter/enc-example](Encounter-enc-example.md),[ImagingStudy/img-example](ImagingStudy-img-example.md),[Media/media-example](Media-media-example.md),[MedicationStatement/med-sta-drop-example](MedicationStatement-med-sta-drop-example.md),[MedicationStatement/med-sta-example](MedicationStatement-med-sta-example.md),[MedicationStatement/med-sta-inflamed-example](MedicationStatement-med-sta-inflamed-example.md),[MedicationStatement/med-sta-injection-example](MedicationStatement-med-sta-injection-example.md),[Observation/obs-averageBloodPressure-example](Observation-obs-averageBloodPressure-example.md),[Observation/obs-pregnancy-status-example](Observation-obs-pregnancy-status-example.md),[Observation/obs-sexual-orientation-example](Observation-obs-sexual-orientation-example.md),[Observation/obs-simple-example](Observation-obs-simple-example.md),[Observation/obs-smoking-status-example](Observation-obs-smoking-status-example.md),[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md),[Practitioner/pra-nurse-example](Practitioner-pra-nurse-example.md),[Practitioner/pra-phc-example](Practitioner-pra-phc-example.md),[Practitioner/pra-radio-example](Practitioner-pra-radio-example.md),[PractitionerRole/praro-dr-example](PractitionerRole-praro-dr-example.md),[PractitionerRole/praro-nurse-example](PractitionerRole-praro-nurse-example.md),[PractitionerRole/praro-phc-example](PractitionerRole-praro-phc-example.md),[PractitionerRole/praro-radio-example](PractitionerRole-praro-radio-example.md),[PregnancyStatusCodeSCT](ValueSet-snomed-pregnancy-status-code.md),[Procedure/pro-appendectomy-example](Procedure-pro-appendectomy-example.md),[Procedure/pro-example](Procedure-pro-example.md),[ServiceRequest/sr-example](ServiceRequest-sr-example.md),[SexualOrientationCodeSCT](ValueSet-snomed-sexual-orientation-code.md),[SmokingStatusComprehensiveCode](ValueSet-smoking-status-comprehensive-code.md),[SmokingStatusTypeCode](ValueSet-smoking-status-type-code.md),[Specimen/spe-ance-example](Specimen-spe-ance-example.md),[Specimen/spe-blood-example](Specimen-spe-blood-example.md),[Specimen/spe-stool-example](Specimen-spe-stool-example.md),[Specimen/spe-ur-example](Specimen-spe-ur-example.md),[TWConditionCodeSCT](ValueSet-condition-code-sct-tw.md),[TWCoreAllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md),[TWCoreCareTeam](StructureDefinition-CareTeam-twcore.md),[TWCoreCondition](StructureDefinition-Condition-twcore.md),[TWCoreDiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md),[TWCoreDocumentReference](StructureDefinition-DocumentReference-twcore.md),[TWCoreEncounter](StructureDefinition-Encounter-twcore.md),[TWCoreGoal](StructureDefinition-Goal-twcore.md),[TWCoreImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TWCoreMedia](StructureDefinition-Media-twcore.md),[TWCoreMedication](StructureDefinition-Medication-twcore.md),[TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TWCoreObservationAverageBloodPressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TWCoreObservationBMI](StructureDefinition-Observation-bmi-twcore.md),[TWCoreObservationBloodPressure](StructureDefinition-Observation-bloodPressure-twcore.md),[TWCoreObservationClinicalResult](StructureDefinition-Observation-clinical-result-twcore.md),[TWCoreObservationLaboratoryResult](StructureDefinition-Observation-laboratoryResult-twcore.md),[TWCoreObservationPregnancyStatus](StructureDefinition-Observation-pregnancy-status-twcore.md),[TWCoreObservationSexualOrientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TWCoreObservationSmokingStatus](StructureDefinition-Observation-smoking-status-twcore.md),[TWCoreObservationVitalSigns](StructureDefinition-Observation-vitalSigns-twcore.md),[TWCorePractitioner](StructureDefinition-Practitioner-twcore.md),[TWCorePractitionerRole](StructureDefinition-PractitionerRole-twcore.md),[TWCoreProcedure](StructureDefinition-Procedure-twcore.md),[TWCoreServiceRequest](StructureDefinition-ServiceRequest-twcore.md),[TWCoreSpecimen](StructureDefinition-Specimen-twcore.md),[TWHealthProfessionalSCT](ValueSet-health-professional-sct-tw.md),[TWMedicalDepartmentSCT](ValueSet-medical-department-sct-tw.md),[TWMedicationPathSCT](ValueSet-medication-path-sct-tw.md)and[TWServiceRequestCategory](ValueSet-serviceRequest-category.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Admit source](http://terminology.hl7.org/7.0.1/CodeSystem-admit-source.html): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/all-cat-example](AllergyIntolerance-all-cat-example.md), [AllergyIntolerance/all-medication-example](AllergyIntolerance-all-medication-example.md), [AllergyIntolerance/all-nut-example](AllergyIntolerance-all-nut-example.md), [AllergyIntolerance/all-seafood-example](AllergyIntolerance-all-seafood-example.md) and [TWCoreAllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/all-cat-example](AllergyIntolerance-all-cat-example.md), [AllergyIntolerance/all-medication-example](AllergyIntolerance-all-medication-example.md), [AllergyIntolerance/all-nut-example](AllergyIntolerance-all-nut-example.md), [AllergyIntolerance/all-seafood-example](AllergyIntolerance-all-seafood-example.md) and [TWCoreAllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md)
* [Condition Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-category.html): [Condition/con-example](Condition-con-example.md) and [TWCoreCondition](StructureDefinition-Condition-twcore.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-clinical.html): [Condition/con-example](Condition-con-example.md) and [TWCoreCondition](StructureDefinition-Condition-twcore.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/7.0.1/CodeSystem-condition-ver-status.html): [Condition/con-example](Condition-con-example.md) and [TWCoreCondition](StructureDefinition-Condition-twcore.md)
* [Contact entity type](http://terminology.hl7.org/7.0.1/CodeSystem-contactentity-type.html): [TWCoreOrganization](StructureDefinition-Organization-twcore.md)
* [Coverage Class Codes](http://terminology.hl7.org/7.0.1/CodeSystem-coverage-class.html): [Coverage/coverage-example](Coverage-coverage-example.md) and [TWCoreCoverage](StructureDefinition-Coverage-twcore.md)
* [Coverage SelfPay Codes](http://terminology.hl7.org/7.0.1/CodeSystem-coverage-selfpay.html): [TWCoreCoverage](StructureDefinition-Coverage-twcore.md)
* [DataAbsentReason](http://terminology.hl7.org/7.0.1/CodeSystem-data-absent-reason.html): [TWCoreObservationClinicalResult](StructureDefinition-Observation-clinical-result-twcore.md) and [TWCoreObservationVitalSigns](StructureDefinition-Observation-vitalSigns-twcore.md)
* [Diagnosis Role](http://terminology.hl7.org/7.0.1/CodeSystem-diagnosis-role.html): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [Diet](http://terminology.hl7.org/7.0.1/CodeSystem-diet.html): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [Discharge disposition](http://terminology.hl7.org/7.0.1/CodeSystem-discharge-disposition.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md), [Encounter/enc-example](Encounter-enc-example.md) and [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [DoseAndRateType](http://terminology.hl7.org/7.0.1/CodeSystem-dose-rate-type.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 5 more,[MedicationRequest/med-req-cod-example](MedicationRequest-med-req-cod-example.md),[MedicationRequest/med-req-ref-example](MedicationRequest-med-req-ref-example.md),[TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md)and[TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md)
* [Special arrangements](http://terminology.hl7.org/7.0.1/CodeSystem-encounter-special-arrangements.html): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [Encounter type](http://terminology.hl7.org/7.0.1/CodeSystem-encounter-type.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md), [Encounter/enc-example](Encounter-enc-example.md) and [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [List Empty Reasons](http://terminology.hl7.org/7.0.1/CodeSystem-list-empty-reason.html): [TWCoreComposition](StructureDefinition-Composition-twcore.md)
* [List Order Codes](http://terminology.hl7.org/7.0.1/CodeSystem-list-order.html): [TWCoreComposition](StructureDefinition-Composition-twcore.md)
* [Location type](http://terminology.hl7.org/7.0.1/CodeSystem-location-physical-type.html): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md) and [TWCoreLocation](StructureDefinition-Location-twcore.md)
* [MedicationDispense Performer Function Codes](http://terminology.hl7.org/7.0.1/CodeSystem-medicationdispense-performer-function.html): [TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md)
* [MedicationRequest Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-medicationrequest-category.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md), [MedicationRequest/med-req-cod-example](MedicationRequest-med-req-cod-example.md), [MedicationRequest/med-req-ref-example](MedicationRequest-med-req-ref-example.md) and [TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md)
* [MedicationRequest Course of Therapy Codes](http://terminology.hl7.org/7.0.1/CodeSystem-medicationrequest-course-of-therapy.html): [TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md)
* [MedicationRequest Status Reason Codes](http://terminology.hl7.org/7.0.1/CodeSystem-medicationrequest-status-reason.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md), [MedicationRequest/med-req-cod-example](MedicationRequest-med-req-cod-example.md), [MedicationRequest/med-req-ref-example](MedicationRequest-med-req-ref-example.md) and [TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md)
* [Example Message Reason Codes](http://terminology.hl7.org/7.0.1/CodeSystem-message-reasons-encounter.html): [TWCoreMessageHeader](StructureDefinition-MessageHeader-twcore.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 34 more,[Bundle/bun-message-request-example](Bundle-bun-message-request-example.md),[Observation/obs-averageBloodPressure-example](Observation-obs-averageBloodPressure-example.md),[Observation/obs-bloodPressure-example](Observation-obs-bloodPressure-example.md),[Observation/obs-bmi-example](Observation-obs-bmi-example.md),[Observation/obs-clinical-result-example](Observation-obs-clinical-result-example.md),[Observation/obs-ecg-example](Observation-obs-ecg-example.md),[Observation/obs-head-circumference-example](Observation-obs-head-circumference-example.md),[Observation/obs-heart-rate-example](Observation-obs-heart-rate-example.md),[Observation/obs-height-example](Observation-obs-height-example.md),[Observation/obs-lab-example](Observation-obs-lab-example.md),[Observation/obs-loinc-example](Observation-obs-loinc-example.md),[Observation/obs-occupation-example](Observation-obs-occupation-example.md),[Observation/obs-ofc-percentile-example](Observation-obs-ofc-percentile-example.md),[Observation/obs-pediatric-bmi-age-example](Observation-obs-pediatric-bmi-age-example.md),[Observation/obs-pediatric-weight-height-example](Observation-obs-pediatric-weight-height-example.md),[Observation/obs-pregnancy-intent-example](Observation-obs-pregnancy-intent-example.md),[Observation/obs-pregnancy-status-example](Observation-obs-pregnancy-status-example.md),[Observation/obs-pulse-oximetry-example](Observation-obs-pulse-oximetry-example.md),[Observation/obs-respiratory-rate-example](Observation-obs-respiratory-rate-example.md),[Observation/obs-screening-assessment-example](Observation-obs-screening-assessment-example.md),[Observation/obs-sexual-orientation-example](Observation-obs-sexual-orientation-example.md),[Observation/obs-simple-example](Observation-obs-simple-example.md),[Observation/obs-smoking-status-example](Observation-obs-smoking-status-example.md),[Observation/obs-temperature-example](Observation-obs-temperature-example.md),[Observation/obs-vital](Observation-obs-vital.md),[Observation/obs-weight-example](Observation-obs-weight-example.md),[TWCategoryCode](ValueSet-category-code-tw.md),[TWCoreObservationClinicalResult](StructureDefinition-Observation-clinical-result-twcore.md),[TWCoreObservationECG](StructureDefinition-Observation-ecg-twcore.md),[TWCoreObservationLaboratoryResult](StructureDefinition-Observation-laboratoryResult-twcore.md),[TWCoreObservationScreeningAssessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TWCoreObservationSimple](StructureDefinition-Observation-simple-twcore.md),[TWCoreObservationVitalSigns](StructureDefinition-Observation-vitalSigns-twcore.md)and[TWObservationClinicalResultCategory](ValueSet-observation-clinical-result-category.md)
* [Organization type](http://terminology.hl7.org/7.0.1/CodeSystem-organization-type.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 8 more,[Bundle/bun-message-request-example](Bundle-bun-message-request-example.md),[TWCoreOrganization](StructureDefinition-Organization-twcore.md),[TWCoreOrganizationCo](StructureDefinition-Organization-co-twcore.md),[TWCoreOrganizationGovt](StructureDefinition-Organization-govt-twcore.md),[TWCoreOrganizationHosp](StructureDefinition-Organization-hosp-twcore.md),[莉梓股份有限公司](Organization-org-co-example.md),[衛生福利部](Organization-org-govt-example.md)and[衛生福利部臺北醫院](Organization-org-hosp-example.md)
* [Participant type](http://terminology.hl7.org/7.0.1/CodeSystem-participant-type.html): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [Observation Reference Range Meaning Codes](http://terminology.hl7.org/7.0.1/CodeSystem-referencerange-meaning.html): [TWCoreObservationClinicalResult](StructureDefinition-Observation-clinical-result-twcore.md) and [TWCoreObservationVitalSigns](StructureDefinition-Observation-vitalSigns-twcore.md)
* [Service type](http://terminology.hl7.org/7.0.1/CodeSystem-service-type.html): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/7.0.1/CodeSystem-subscriber-relationship.html): [Coverage/coverage-example](Coverage-coverage-example.md)
* [diagnosticServiceSectionId](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0074.html): [Bundle/bun-message-request-example](Bundle-bun-message-request-example.md), [DiagnosticReport/dia-example](DiagnosticReport-dia-example.md) and [TWCoreDiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)
* [re-admissionIndicator](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0092.html): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [bedStatus](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0116.html): [TWCoreLocation](StructureDefinition-Location-twcore.md)
* [contactRole2](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0131.html): [TWCorePatient](StructureDefinition-Patient-twcore.md) and [TWCoreRelatedPerson](StructureDefinition-RelatedPerson-twcore.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 24 more,[Bundle/bun-example](Bundle-bun-example.md),[Bundle/bun-message-request-example](Bundle-bun-message-request-example.md),[Coverage/coverage-example](Coverage-coverage-example.md),[ImagingStudy/img-example](ImagingStudy-img-example.md),[Patient/pat-child-example](Patient-pat-child-example.md),[Patient/pat-example](Patient-pat-example.md),[Patient/pat-residentNumber-example](Patient-pat-residentNumber-example.md),[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md),[Practitioner/pra-nurse-example](Practitioner-pra-nurse-example.md),[Practitioner/pra-phc-example](Practitioner-pra-phc-example.md),[Practitioner/pra-radio-example](Practitioner-pra-radio-example.md),[PractitionerRole/praro-dr-example](PractitionerRole-praro-dr-example.md),[PractitionerRole/praro-nurse-example](PractitionerRole-praro-nurse-example.md),[PractitionerRole/praro-phc-example](PractitionerRole-praro-phc-example.md),[PractitionerRole/praro-radio-example](PractitionerRole-praro-radio-example.md),[TWCoreCoverage](StructureDefinition-Coverage-twcore.md),[TWCoreEncounter](StructureDefinition-Encounter-twcore.md),[TWCoreOrganization](StructureDefinition-Organization-twcore.md),[TWCoreOrganizationHosp](StructureDefinition-Organization-hosp-twcore.md),[TWCorePatient](StructureDefinition-Patient-twcore.md),[TWCorePractitioner](StructureDefinition-Practitioner-twcore.md),[TWIdentifierType](ValueSet-identifier-type-tw.md),[衛生福利部桃園醫院](Organization-org-example.md)and[衛生福利部臺北醫院](Organization-org-hosp-example.md)
* [additivePreservative](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0371.html): [TWCoreSpecimen](StructureDefinition-Specimen-twcore.md)
* [treatment](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0373.html): [TWCoreSpecimen](StructureDefinition-Specimen-twcore.md)
* [specimenType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0487.html): [TWCoreSpecimen](StructureDefinition-Specimen-twcore.md)
* [specimenCondition](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0493.html): [TWCoreSpecimen](StructureDefinition-Specimen-twcore.md)
* [relevantClincialInformation](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0916.html): [Specimen/spe-ance-example](Specimen-spe-ance-example.md), [Specimen/spe-blood-example](Specimen-spe-blood-example.md), [Specimen/spe-stool-example](Specimen-spe-stool-example.md), [Specimen/spe-ur-example](Specimen-spe-ur-example.md) and [TWCoreSpecimen](StructureDefinition-Specimen-twcore.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 12 more,[Composition/com-example](Composition-com-example.md),[Composition/com-surgery-example](Composition-com-surgery-example.md),[Coverage/coverage-example](Coverage-coverage-example.md),[Encounter/enc-example](Encounter-enc-example.md),[MedicationDispense/med-dis-drop-example](MedicationDispense-med-dis-drop-example.md),[MedicationDispense/med-dis-inflamed-example](MedicationDispense-med-dis-inflamed-example.md),[MedicationDispense/med-dis-injection-example](MedicationDispense-med-dis-injection-example.md),[MedicationDispense/med-dis-ref-example](MedicationDispense-med-dis-ref-example.md),[TWCoreComposition](StructureDefinition-Composition-twcore.md),[TWCoreDocumentReference](StructureDefinition-DocumentReference-twcore.md),[TWCoreEncounter](StructureDefinition-Encounter-twcore.md)and[TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md)
* [ActPriority](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActPriority.html): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [ActReason](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActReason.html): [MedicationDispense/med-dis-drop-example](MedicationDispense-med-dis-drop-example.md), [MedicationDispense/med-dis-inflamed-example](MedicationDispense-med-dis-inflamed-example.md)...Show 4 more,[MedicationDispense/med-dis-injection-example](MedicationDispense-med-dis-injection-example.md),[MedicationDispense/med-dis-ref-example](MedicationDispense-med-dis-ref-example.md),[TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md)and[TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md)
* [Confidentiality](http://terminology.hl7.org/7.0.1/CodeSystem-v3-Confidentiality.html): [TWCoreComposition](StructureDefinition-Composition-twcore.md)
* [EncounterSpecialCourtesy](http://terminology.hl7.org/7.0.1/CodeSystem-v3-EncounterSpecialCourtesy.html): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md)
* [GTSAbbreviation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-GTSAbbreviation.html): [TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md), [TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md), [TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md) and [TWMedicationFrequencyHL7](ValueSet-medication-frequency-hl7-tw.md)
* [MaritalStatus](http://terminology.hl7.org/7.0.1/CodeSystem-v3-MaritalStatus.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 4 more,[Bundle/bun-example](Bundle-bun-example.md),[Bundle/bun-message-request-example](Bundle-bun-message-request-example.md),[Patient/pat-example](Patient-pat-example.md)and[TWCorePatient](StructureDefinition-Patient-twcore.md)
* [NullFlavor](http://terminology.hl7.org/7.0.1/CodeSystem-v3-NullFlavor.html): [LOINCPregnancyIntentCode](ValueSet-loinc-pregnancy-intent-code.md), [PregnancyStatusCodeSCT](ValueSet-snomed-pregnancy-status-code.md)...Show 6 more,[SexualOrientationCodeSCT](ValueSet-snomed-sexual-orientation-code.md),[TWCoreEncounter](StructureDefinition-Encounter-twcore.md),[TWCoreObservationPregnancyIntent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TWCoreObservationPregnancyStatus](StructureDefinition-Observation-pregnancy-status-twcore.md),[TWCoreObservationSexualOrientation](StructureDefinition-Observation-sexual-orientation-twcore.md)and[TWCorePatient](StructureDefinition-Patient-twcore.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ObservationInterpretation.html): [TWCoreObservationClinicalResult](StructureDefinition-Observation-clinical-result-twcore.md) and [TWCoreObservationVitalSigns](StructureDefinition-Observation-vitalSigns-twcore.md)
* [ParticipationType](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationType.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md), [Encounter/enc-example](Encounter-enc-example.md), [TWCoreEncounter](StructureDefinition-Encounter-twcore.md) and [TWCoreImagingStudy](StructureDefinition-ImagingStudy-twcore.md)
* [RoleCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RoleCode.html): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 13 more,[Bundle/bun-example](Bundle-bun-example.md),[Bundle/bun-message-request-example](Bundle-bun-message-request-example.md),[Patient/pat-child-example](Patient-pat-child-example.md),[Patient/pat-example](Patient-pat-example.md),[RelatedPerson/rel-example](RelatedPerson-rel-example.md),[TWCoreLocation](StructureDefinition-Location-twcore.md),[TWCorePatient](StructureDefinition-Patient-twcore.md),[TWCoreRelatedPerson](StructureDefinition-RelatedPerson-twcore.md),[明捷眼科診所](Location-loc-oph-example.md),[第二藥局](Location-loc-pharm-example.md),[衛生福利部臺北醫院X光室](Location-loc-hrad-example.md),[衛生福利部臺北醫院急診室](Location-loc-er-example.md)and[衛生福利部臺北醫院耳鼻喉科](Location-loc-ent-example.md)
* [TimingEvent](http://terminology.hl7.org/7.0.1/CodeSystem-v3-TimingEvent.html): [TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md), [TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md) and [TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md)
* [Orderable Drug Form](http://terminology.hl7.org/7.0.1/CodeSystem-v3-orderableDrugForm.html): [Bundle/bun-example](Bundle-bun-example.md), [Medication/med-example](Medication-med-example.md)...Show 6 more,[MedicationDispense/med-dis-drop-example](MedicationDispense-med-dis-drop-example.md),[MedicationDispense/med-dis-inflamed-example](MedicationDispense-med-dis-inflamed-example.md),[MedicationDispense/med-dis-injection-example](MedicationDispense-med-dis-injection-example.md),[MedicationDispense/med-dis-ref-example](MedicationDispense-med-dis-ref-example.md),[OrderableDrugForm](ValueSet-v3-orderableDrugForm.md)and[TWCoreMedication](StructureDefinition-Medication-twcore.md)
* [Substance Admin Substitution](http://terminology.hl7.org/7.0.1/CodeSystem-v3-substanceAdminSubstitution.html): [MedicationDispense/med-dis-drop-example](MedicationDispense-med-dis-drop-example.md), [MedicationDispense/med-dis-inflamed-example](MedicationDispense-med-dis-inflamed-example.md)...Show 4 more,[MedicationDispense/med-dis-injection-example](MedicationDispense-med-dis-injection-example.md),[MedicationDispense/med-dis-ref-example](MedicationDispense-med-dis-ref-example.md),[TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md)and[TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md)


* This resource includes content from the Digital Imaging and Communications in Medicine (DICOM) Standard, Copyright 2011 by the National Electrical Manufacturers Association

* [Media Modality](http://hl7.org/fhir/R4/codesystem-media-modality.html): [TWCoreMedia](StructureDefinition-Media-twcore.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/5.0.0/CodeSystem-v3-rxNorm.html): [TWCoreMedication](StructureDefinition-Medication-twcore.md), [TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md), [TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md), [TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md) and [TWMedicationRXNORM](ValueSet-medication-rxnorm-tw.md)


* World Health Organization (WHO)

* [臺灣健保署2014年中文版ICD-10-CM](CodeSystem-icd-10-cm-2014-tw.md): [TW2014ICD10CM](ValueSet-icd-10-cm-2014-tw.md) and [TWCoreCondition](StructureDefinition-Condition-twcore.md)
* [臺灣健保署2021年中文版ICD-10-CM](CodeSystem-icd-10-cm-2021-tw.md): [Condition/con-example](Condition-con-example.md), [TW2021ICD10CM](ValueSet-icd-10-cm-2021-tw.md) and [TWCoreCondition](StructureDefinition-Condition-twcore.md)
* [臺灣健保署2023年中文版ICD-10-CM](CodeSystem-icd-10-cm-2023-tw.md): [TW2023ICD10CM](ValueSet-icd-10-cm-2023-tw.md) and [TWCoreCondition](StructureDefinition-Condition-twcore.md)
* [臺灣健保署2014年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2014-tw.md): [TW2014ICD10PCS](ValueSet-icd-10-pcs-2014-tw.md), [TWCoreProcedure](StructureDefinition-Procedure-twcore.md) and [TWCoreServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* [臺灣健保署2021年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2021-tw.md): [ImagingStudy/img-ct-example](ImagingStudy-img-ct-example.md), [ImagingStudy/img-example](ImagingStudy-img-example.md)...Show 7 more,[ImagingStudy/img-mr-example](ImagingStudy-img-mr-example.md),[Procedure/pro-example](Procedure-pro-example.md),[TW2021ICD10PCS](ValueSet-icd-10-pcs-2021-tw.md),[TWCoreDiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md),[TWCoreImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TWCoreProcedure](StructureDefinition-Procedure-twcore.md)and[TWCoreServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* [臺灣健保署2023年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2023-tw.md): [TW2023ICD10PCS](ValueSet-icd-10-pcs-2023-tw.md), [TWCoreDiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md), [TWCoreImagingStudy](StructureDefinition-ImagingStudy-twcore.md), [TWCoreProcedure](StructureDefinition-Procedure-twcore.md) and [TWCoreServiceRequest](StructureDefinition-ServiceRequest-twcore.md)


* 中華民國人壽保險商業同業公會

* [臺灣壽險公會傷害保險個人職業分類表](CodeSystem-occupation-lia-roc-tw.md): [Observation/obs-occupation-example](Observation-obs-occupation-example.md), [TWCoreObservationOccupation](StructureDefinition-Observation-occupation-twcore.md) and [TWLIAROCOccupation](ValueSet-occupation-lia-roc-tw.md)


* 中華民國勞動部

* [臺灣勞動部職業標準分類](CodeSystem-occupation-mol-tw.md): [TWCoreObservationOccupation](StructureDefinition-Observation-occupation-twcore.md) and [TWMolOccupation](ValueSet-occupation-mol-tw.md)


* 中華郵政

* [臺灣中華郵政3碼郵遞區號](CodeSystem-postal-code3-tw.md): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 11 more,[Bundle/bun-example](Bundle-bun-example.md),[Bundle/bun-message-request-example](Bundle-bun-message-request-example.md),[Patient/pat-child-example](Patient-pat-child-example.md),[Patient/pat-example](Patient-pat-example.md),[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md),[Practitioner/pra-nurse-example](Practitioner-pra-nurse-example.md),[Practitioner/pra-phc-example](Practitioner-pra-phc-example.md),[Practitioner/pra-radio-example](Practitioner-pra-radio-example.md),[RelatedPerson/rel-example](RelatedPerson-rel-example.md),[TWPostalCode](StructureDefinition-tw-postal-code.md)and[TWPostalCode3](ValueSet-postal-code3-tw.md)
* [臺灣中華郵政5碼郵遞區號](CodeSystem-postal-code5-tw.md): [TWPostalCode](StructureDefinition-tw-postal-code.md) and [TWPostalCode5](ValueSet-postal-code5-tw.md)
* [臺灣中華郵政6碼郵遞區號](CodeSystem-postal-code6-tw.md): [TWPostalCode](StructureDefinition-tw-postal-code.md) and [TWPostalCode6](ValueSet-postal-code6-tw.md)


* 內政部戶政司

* [臺灣戶政司婚姻狀態](CodeSystem-marital-status-tw.md): [TWMaritalStatus](ValueSet-marital-status-tw.md)


* 行政院主計總處

* [行政院主計總處行業分類](CodeSystem-industry-dgbas-tw.md): [Observation/obs-occupation-example](Observation-obs-occupation-example.md), [TWCoreObservationOccupation](StructureDefinition-Observation-occupation-twcore.md) and [TWIndustry](ValueSet-industry-dgbas-tw.md)


* 衛生福利部

* [臺灣健保署藥品使用頻率](CodeSystem-medication-frequency-nhi-tw.md): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 7 more,[MedicationRequest/med-req-cod-example](MedicationRequest-med-req-cod-example.md),[MedicationRequest/med-req-ref-example](MedicationRequest-med-req-ref-example.md),[TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TWMedicationFrequencyHL7](ValueSet-medication-frequency-hl7-tw.md)and[TWMedicationFrequencyNHI](ValueSet-medication-frequency-nhi-tw.md)


* 衛生福利部中央健康保險署

* [臺灣健保署就醫科別](CodeSystem-medical-consultation-department-nhi-tw.md): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md), [TWCorePractitionerRole](StructureDefinition-PractitionerRole-twcore.md), [TWMedicalConsultationDepartment](ValueSet-medical-consultation-department-tw.md) and [TWMedicalConsultationDepartmentNHI](ValueSet-medical-consultation-department-nhi-tw.md)
* [臺灣健保署醫療服務給付項目](CodeSystem-medical-service-payment-tw.md): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 8 more,[Bundle/bun-message-request-example](Bundle-bun-message-request-example.md),[DiagnosticReport/dia-example](DiagnosticReport-dia-example.md),[Observation/obs-lab-example](Observation-obs-lab-example.md),[TWCoreDiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md),[TWCoreProcedure](StructureDefinition-Procedure-twcore.md),[TWCoreServiceRequest](StructureDefinition-ServiceRequest-twcore.md),[TWLaboratoryCategory](ValueSet-laboratory-category-tw.md)and[TWMedicalServicePayment](ValueSet-procedure-tw.md)
* [臺灣健保署診療科別](CodeSystem-medical-treatment-department-nhi-tw.md): [TWCoreEncounter](StructureDefinition-Encounter-twcore.md), [TWCorePractitionerRole](StructureDefinition-PractitionerRole-twcore.md), [TWMedicalTreatmentDepartment](ValueSet-medical-treatment-department-tw.md) and [TWMedicalTreatmentDepartmentNHI](ValueSet-medical-treatment-department-nhi-tw.md)
* [臺灣健保署用藥品項](CodeSystem-medication-nhi-tw.md): [MedicationStatement/med-sta-example](MedicationStatement-med-sta-example.md), [TWCoreMedication](StructureDefinition-Medication-twcore.md)...Show 4 more,[TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md)and[TWMedicationNHI](ValueSet-medication-nhi-tw.md)
* [臺灣健保署給藥途徑](CodeSystem-medication-path-tw.md): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 7 more,[MedicationRequest/med-req-cod-example](MedicationRequest-med-req-cod-example.md),[MedicationRequest/med-req-ref-example](MedicationRequest-med-req-ref-example.md),[TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TWMedicationPath](ValueSet-medication-path-tw.md)and[TWMedicationPathSCT](ValueSet-medication-path-sct-tw.md)
* [臺灣健保署中藥用藥品項](CodeSystem-nhi-medication-ch-herb-tw.md): [TWCHHerbMedicationNHI](ValueSet-nhi-medication-ch-herb-tw.md), [TWCoreMedication](StructureDefinition-Medication-twcore.md), [TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md), [TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md) and [TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md)


* 衛生福利部統計處

* [臺灣醫事司醫事人員類別](CodeSystem-health-professional-tw.md): [TWCorePractitioner](StructureDefinition-Practitioner-twcore.md), [TWCorePractitionerRole](StructureDefinition-PractitionerRole-twcore.md), [TWHealthProfessional](ValueSet-health-professional-tw.md) and [TWHealthProfessionalSCT](ValueSet-health-professional-sct-tw.md)


* 衛生福利部資訊處

* [臺灣衛福部資訊處照護計畫類別](CodeSystem-careplan-category-tw.md): [CarePlan/careplan-example](CarePlan-careplan-example.md) and [TWCoreCarePlan](StructureDefinition-CarePlan-twcore.md)
* [臺灣衛福部資訊處類型代碼](CodeSystem-category-code-tw.md): [Observation/obs-careExp-example](Observation-obs-careExp-example.md), [Observation/obs-treatment-intervention-preference-example](Observation-obs-treatment-intervention-preference-example.md)...Show 6 more,[TWCategoryCode](ValueSet-category-code-tw.md),[TWCoreObservationScreeningAssessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TWCoreObservationSimple](StructureDefinition-Observation-simple-twcore.md),[TWCoreServiceRequest](StructureDefinition-ServiceRequest-twcore.md),[TWObservationScreeningAssessmentCategory](ValueSet-observation-screening-assessment-category.md)and[TWServiceRequestCategory](ValueSet-serviceRequest-category.md)
* [臺灣衛福部資訊處Provenance參與類型](CodeSystem-provenance-participant-type-tw.md): [TWCoreProvenance](StructureDefinition-Provenance-twcore.md) and [TWProvenancePaticipantTypeHL7](ValueSet-provenance-participant-type-hl7-tw.md)
* [臺灣衛福部資訊處識別碼類型](CodeSystem-v2-0203.md): [TWCoreOrganization](StructureDefinition-Organization-twcore.md), [TWCoreOrganizationCo](StructureDefinition-Organization-co-twcore.md)...Show 6 more,[TWCoreOrganizationGovt](StructureDefinition-Organization-govt-twcore.md),[TWCorePatient](StructureDefinition-Patient-twcore.md),[TWCorePractitioner](StructureDefinition-Practitioner-twcore.md),[TWIdentifierType](ValueSet-identifier-type-tw.md),[莉梓股份有限公司](Organization-org-co-example.md)and[衛生福利部](Organization-org-govt-example.md)


* 衛生福利部醫事司

* [臺灣醫事司醫事機構代碼](CodeSystem-organization-identifier-tw.md): [TWCoreOrganizationHosp](StructureDefinition-Organization-hosp-twcore.md) and [TWOrganizationIdentifier](ValueSet-organization-identifier-tw.md)


* 衛生福利部食品藥物管理署

* [臺灣食藥署醫療器材許可證](CodeSystem-medication-device-fda-tw.md): [TWCoreMedication](StructureDefinition-Medication-twcore.md), [TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md), [TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md), [TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md) and [TWMedicationFDA](ValueSet-medication-fda-tw.md)
* [臺灣食藥署藥品許可證](CodeSystem-medication-fda-tw.md): [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)...Show 14 more,[Bundle/bun-example](Bundle-bun-example.md),[Medication/med-example](Medication-med-example.md),[MedicationDispense/med-dis-drop-example](MedicationDispense-med-dis-drop-example.md),[MedicationDispense/med-dis-inflamed-example](MedicationDispense-med-dis-inflamed-example.md),[MedicationDispense/med-dis-injection-example](MedicationDispense-med-dis-injection-example.md),[MedicationRequest/med-req-cod-example](MedicationRequest-med-req-cod-example.md),[MedicationStatement/med-sta-drop-example](MedicationStatement-med-sta-drop-example.md),[MedicationStatement/med-sta-inflamed-example](MedicationStatement-med-sta-inflamed-example.md),[MedicationStatement/med-sta-injection-example](MedicationStatement-med-sta-injection-example.md),[TWCoreMedication](StructureDefinition-Medication-twcore.md),[TWCoreMedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TWCoreMedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TWCoreMedicationStatement](StructureDefinition-MedicationStatement-twcore.md)and[TWMedicationFDA](ValueSet-medication-fda-tw.md)


