# Slide Microscopy - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example ImagingStudy: Slide Microscopy

### Slide Microscopy

**識別碼(official)**：urn:oid: 2.16.886.103.102695.293755960071087971037154104444119427201
**識別碼(usual)**：A20210527083803 **識別碼(secondary)**：D1M_18S_1

**狀態**：Available([ImagingStudyStatus](http://hl7.org/fhir/R4/valueset-imagingstudy-status.html)#available)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**檢查相關Series的數量**：1

**檢查相關Instances的數量**：6

**檢查開始日期與時間**：2021-05-27T00:00:00+08:00

> **系列(series)實例**：**DICOM系列實例UID**：2.16.886.103.102695.7661805881534741258144674448294792877
**所使用的成像儀器**： Slide Microscopy([CID 29 Acquisition Modality](http://dicom.nema.org/resources/ontology/DCM)#SM)



## Resource Content

```json
{
  "resourceType" : "ImagingStudy",
  "id" : "img-sm-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "system" : "urn:dicom:uid",
      "value" : "urn:oid: 2.16.886.103.102695.293755960071087971037154104444119427201"
    },
    {
      "use" : "usual",
      "value" : "A20210527083803"
    },
    {
      "use" : "secondary",
      "value" : "D1M_18S_1"
    }
  ],
  "status" : "available",
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "started" : "2021-05-27T00:00:00+08:00",
  "numberOfSeries" : 1,
  "numberOfInstances" : 6,
  "series" : [
    {
      "uid" : "2.16.886.103.102695.7661805881534741258144674448294792877",
      "modality" : {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "code" : "SM",
        "display" : "Slide Microscopy"
      }
    }
  ]
}

```
