# 雙側乳房磁振造影 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example ImagingStudy: 雙側乳房磁振造影

### 雙側乳房磁振造影

**識別碼(official)**：urn:oid:2.16.886.103.102695.210984610692795733666714058539
**識別碼(usual)**：a085557173658239

**狀態**：Available([ImagingStudyStatus](http://hl7.org/fhir/R4/valueset-imagingstudy-status.html)#available)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**檢查開始日期與時間**：2008-04-19T09:14:28+08:00

**執行的處置或手術代碼**雙側乳房磁振造影 ([臺灣健保署2021年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2021-tw.md)#BH32ZZZ)

**影像描述**：MRI Breast Bilateral with and without Contrast

> **系列(series)實例(701)**：**DICOM系列實例UID**：2.16.886.103.102695.146297080074792942851314092932
**數字識別碼**： 701
**所使用的成像儀器**： Magnetic Resonance([CID 29 Acquisition Modality](http://dicom.nema.org/resources/ontology/DCM)#MR)
**摘要**： AX BLISS_AUTO SENSE
**身體部位**：BREAST
> **SOP實例**：**UID**：2.16.886.103.102695.121913313496219293911851524363
**DICOM class 類型**： 1.2.840.10008.5.1.4.1.1.4
**序號**： 1
**實例的描述**： ORIGINAL&PRIMARY&M_FFE&M&FFE


> **系列(series)實例(401)**：**DICOM系列實例UID**：2.16.886.103.102695.146297080074792942851314092932
**數字識別碼**： 401
**所使用的成像儀器**： MR([CID 29 Acquisition Modality](http://dicom.nema.org/resources/ontology/DCM)#MR)
**摘要**： STIR SENSE
**身體部位**：BREAST
> **SOP實例(1)**：**UID**：2.16.886.103.102695.163339141228950338477395854866
**DICOM class 類型**：urn:oid:1.2.840.10008.5.1.4.1.1.4
**序號**： 1
**實例的描述**： ORIGINAL&PRIMARY&M_IR&M&IR

> **SOP實例(2)**：**UID**：2.16.886.103.102695.214225290980747163090417854498
**DICOM class 類型**：urn:oid:1.2.840.10008.5.1.4.1.1.4
**序號**： 2
**實例的描述**： ORIGINAL&PRIMARY&M_IR&M&IR




## Resource Content

```json
{
  "resourceType" : "ImagingStudy",
  "id" : "img-mr-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "system" : "urn:dicom:Uid",
      "value" : "urn:oid:2.16.886.103.102695.210984610692795733666714058539"
    },
    {
      "use" : "usual",
      "value" : "a085557173658239"
    }
  ],
  "status" : "available",
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "started" : "2008-04-19T09:14:28+08:00",
  "procedureCode" : [
    {
      "coding" : [
        {
          "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2021-tw",
          "code" : "BH32ZZZ",
          "display" : "雙側乳房磁振造影"
        }
      ]
    }
  ],
  "description" : "MRI Breast Bilateral with and without Contrast",
  "series" : [
    {
      "uid" : "2.16.886.103.102695.146297080074792942851314092932",
      "number" : 401,
      "modality" : {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "code" : "MR"
      },
      "description" : "STIR SENSE",
      "bodySite" : {
        "display" : "BREAST"
      },
      "instance" : [
        {
          "uid" : "2.16.886.103.102695.163339141228950338477395854866",
          "sopClass" : {
            "system" : "urn:ietf:rfc:3986",
            "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.4"
          },
          "number" : 1,
          "title" : "ORIGINAL\\PRIMARY\\M_IR\\M\\IR"
        },
        {
          "uid" : "2.16.886.103.102695.214225290980747163090417854498",
          "sopClass" : {
            "system" : "urn:ietf:rfc:3986",
            "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.4"
          },
          "number" : 2,
          "title" : "ORIGINAL\\PRIMARY\\M_IR\\M\\IR"
        }
      ]
    }
  ]
}

```
