# 腹部超音波 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example ImagingStudy: 腹部超音波

### 腹部超音波

**狀態**：Available ([ImagingStudyStatus](http://hl7.org/fhir/imagingstudy-status)#available)

**識別碼(official)**：2ffe0c20-50d8-49df-85f6-6452d1d201b9

**檢查開始日期與時間**：2022-08-01T19:00:14

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**就醫事件**：[Encounter/enc-example](Encounter-enc-example.md) "就醫資料"

**檢查相關Series的數量**：1

**檢查相關Instances的數量**：1

**處置或手術**：[Procedure/pro-example](Procedure-pro-example.md) "處置或手術基本資料"
**執行的處置或手術代碼**：腹部超音波([TW2021ICD10PCS](CodeSystem-icd-10-pcs-2021-tw.md)#BW40ZZZ)

> **系列(series)實例**：**DICOM系列實例UID**：2.25.88017001449189502323411118737039844242
**所使用的成像儀器**： Ultrasound([CID 29 Acquisition Modality](http://dicom.nema.org/resources/ontology/DCM)#US)
**身體部位**：Pectoral region([SNOMED CT](http://snomed.info/sct)#251007)
**檢查執行者**：[Practitioner/pra-radio-example](Practitioner-pra-radio-example.md)"王曉明"
> **SOP實例**：**UID**：2.25.284548087604447302186649612333159050027
**DICOM class 類型**： urn:oid:1.2.840.10008.5.1.4.1.1.3.1



## Resource Content

```json
{
  "resourceType" : "ImagingStudy",
  "id" : "img-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ACSN",
            "display" : "Accession ID"
          }
        ]
      },
      "system" : "http://www.moi.gov.tw",
      "value" : "2ffe0c20-50d8-49df-85f6-6452d1d201b9"
    }
  ],
  "status" : "available",
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "encounter" : {
    "reference" : "Encounter/enc-example"
  },
  "started" : "2022-08-01T19:00:14+08:00",
  "numberOfSeries" : 1,
  "numberOfInstances" : 1,
  "procedureReference" : {
    "reference" : "Procedure/pro-example"
  },
  "procedureCode" : [
    {
      "coding" : [
        {
          "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2021-tw",
          "code" : "BW40ZZZ",
          "display" : "腹部超音波"
        }
      ]
    }
  ],
  "series" : [
    {
      "uid" : "2.25.88017001449189502323411118737039844242",
      "modality" : {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "code" : "US"
      },
      "bodySite" : {
        "system" : "http://snomed.info/sct",
        "code" : "251007",
        "display" : "Pectoral region"
      },
      "performer" : [
        {
          "actor" : {
            "reference" : "Practitioner/pra-radio-example"
          }
        }
      ],
      "instance" : [
        {
          "uid" : "2.25.284548087604447302186649612333159050027",
          "sopClass" : {
            "system" : "urn:ietf:rfc:3986",
            "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.3.1"
          }
        }
      ]
    }
  ]
}

```
