# 胸椎電腦斷層掃描 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example ImagingStudy: 胸椎電腦斷層掃描

### 胸椎電腦斷層掃描

**識別碼(official)**：urn:oid:2.16.886.103.102695.988079582344471175076015633105
**識別碼(usual)**：a173095681219824

**狀態**：Available([ImagingStudyStatus](http://hl7.org/fhir/R4/valueset-imagingstudy-status.html)#available)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**檢查開始日期與時間**：1986-09-28T12:04:56+08:00

**執行的處置或手術代碼**：胸椎電腦斷層掃描([臺灣健保署2021年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2021-tw.md)#BR27ZZZ)

> **系列(series)實例**：**DICOM系列實例UID**：2.16.886.103.102695.227571573286142502566010959726
**數字識別碼**： 6
**所使用的成像儀器**： Computed Tomography([CID 29 Acquisition Modality](http://dicom.nema.org/resources/ontology/DCM)#CT)
**摘要**： Abdomen 5.0 B20f
**身體部位**：CHEST
> **SOP實例(1)**：**UID**：2.16.886.103.102695.164912026667369755433481996914
**DICOM class 類型**： urn:oid:1.2.840.10008.5.1.4.1.1.2
**序號**： 1
**實例的描述**： ORIGINAL&PRIMARY&LOCALIZER&CT_SOM5 TOP

> **SOP實例(2)**：**UID**：2.16.886.103.102695.211371491775300429718822081671
**DICOM class 類型**： urn:oid:1.2.840.10008.5.1.4.1.1.2
**序號**： 2
**實例的描述**： DERIVED&SECONDARY&LOCALIZER&CT_SOM5 TOP&CSA RESAMPLED

> **SOP實例(3)**：**UID**：2.16.886.103.102695.157108816098836770904535991652
**DICOM class 類型**： urn:oid:1.2.840.10008.5.1.4.1.1.2
**序號**： 3
**實例的描述**：ORIGINAL&PRIMARY&AXIAL&CT_SOM5 SPI




## Resource Content

```json
{
  "resourceType" : "ImagingStudy",
  "id" : "img-ct-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "system" : "urn:dicom:uid",
      "value" : "urn:oid:2.16.886.103.102695.988079582344471175076015633105"
    },
    {
      "use" : "usual",
      "value" : "a173095681219824"
    }
  ],
  "status" : "available",
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "started" : "1986-09-28T12:04:56+08:00",
  "procedureCode" : [
    {
      "coding" : [
        {
          "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2021-tw",
          "code" : "BR27ZZZ",
          "display" : "胸椎電腦斷層掃描"
        }
      ]
    }
  ],
  "series" : [
    {
      "uid" : "2.16.886.103.102695.227571573286142502566010959726",
      "number" : 3,
      "modality" : {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "code" : "CT"
      },
      "description" : "Abdomen 5.0 B20f",
      "bodySite" : {
        "display" : "CHEST"
      },
      "instance" : [
        {
          "uid" : "2.16.886.103.102695.212912695636234135693070447763",
          "sopClass" : {
            "system" : "urn:ietf:rfc:3986",
            "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.2"
          },
          "number" : 1,
          "title" : "ORIGINAL\\PRIMARY\\AXIAL\\CT_SOM5 SPI"
        },
        {
          "uid" : "2.16.886.103.102695.154619478553564561574922203964",
          "sopClass" : {
            "system" : "urn:ietf:rfc:3986",
            "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.2"
          },
          "number" : 2,
          "title" : "ORIGINAL\\PRIMARY\\AXIAL\\CT_SOM5 SPI"
        },
        {
          "uid" : "2.16.886.103.102695.143863457172810804031650949757",
          "sopClass" : {
            "system" : "urn:ietf:rfc:3986",
            "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.2"
          },
          "number" : 3,
          "title" : "ORIGINAL\\PRIMARY\\AXIAL\\CT_SOM5 SPI"
        },
        {
          "uid" : "2.16.886.103.102695.158154616477252779922391910665",
          "sopClass" : {
            "system" : "urn:ietf:rfc:3986",
            "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.2"
          }
        }
      ]
    }
  ]
}

```
