# 就醫資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Encounter: 就醫資料

### 就醫資料

**識別碼**：E22081702

**就醫現況**：finished

**就醫分類**：pre-admission ([ActEncounterCode](https://terminology.hl7.org/4.0.0/ValueSet-v3-ActEncounterCode.html)#PRENC)

**就醫種類**：Annual diabetes mellitus screening ([Encounter type](http://hl7.org/fhir/R4/codesystem-encounter-type.html)#ADMS)

**服務型別**：腎臟內科(Nephrology (qualifier value)) ([Service type](http://snomed.info/sct)#394589003)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**出院後的地點**：Home ([Discharge disposition](http://hl7.org/fhir/R4/codesystem-encounter-discharge-disposition.html)#home)

**就醫發生的地點**：[Location/loc-ent-example](Location-loc-ent-example.md) "衛生福利部臺北醫院"

### 參與就醫的健康照護服務提供者

| | | | |
| :--- | :--- | :--- | :--- |
| - | **角色** | **參與時段** | **參與人** |
| * | primary performer([ParticipationType](https://terminology.hl7.org/4.0.0/CodeSystem-v3-ParticipationType.html)#PPRF) | 2022-08-01 17:00:14+08:00 --> 2022-08-01 18:00:14+08:00 | [Practitioner/pra-dr-example](Practitioner-pra-dr-example.md)"王依昇" |

**就醫的開始和結束時間**：2022-08-01 17:00:14+08:00 --> 2022-08-01T18:00:14 08:00

**就醫原因**：FH: Diabetes mellitus ([SNOMED CT](https://browser.ihtsdotools.org/)#160303001)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "enc-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
    ]
  },
  "identifier" : [
    {
      "system" : "http://healthcare.example.org/identifiers/enocunter",
      "value" : "E22081702"
    }
  ],
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "PRENC"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/encounter-type",
          "code" : "ADMS"
        }
      ]
    }
  ],
  "serviceType" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "394589003",
        "display" : "Nephrology (qualifier value)"
      }
    ],
    "text" : "腎臟內科"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "participant" : [
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "PPRF"
            }
          ]
        }
      ],
      "period" : {
        "start" : "2022-08-01T17:00:14+08:00",
        "end" : "2022-08-01T18:00:14+08:00"
      },
      "individual" : {
        "reference" : "Practitioner/pra-dr-example"
      }
    }
  ],
  "period" : {
    "start" : "2022-08-01T17:00:14+08:00",
    "end" : "2022-08-01T18:00:14+08:00"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "160303001",
          "display" : "FH: Diabetes mellitus"
        }
      ]
    }
  ],
  "hospitalization" : {
    "dischargeDisposition" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/discharge-disposition",
          "code" : "home"
        }
      ]
    }
  },
  "location" : [
    {
      "location" : {
        "reference" : "Location/loc-ent-example"
      }
    }
  ]
}

```
