# 驗傷報告 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example DocumentReference: 驗傷報告

### 驗傷報告

**狀態**：Current ([DocumentReferenceStatus](http://hl7.org/fhir/R4/codesystem-document-reference-status.html)#current)

**類型(type)**：驗傷報告(Injury event summary Document) ([LOINC](http://loinc.org)#74209-8)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**日期**：2024-01-23T15:45:00

**紀錄者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**就醫資料**：[Encounter/enc-example](Encounter-enc-example.md) "就醫資料"

**紀錄中使用的檔案**：

> **檔案類型(type)**：image/jpeg**檔案**：[Wound Photo](https://obs.line-scdn.net/0hJczFr9HRFUxHPzhi5CVqG31pFiN0UwZPIwlETwRRS3g5ClpKL1wPImRrSCg6D1ISKQlYKGY7Dn1jBlZPf1sP/w1200)



## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "doc-wound-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore"
    ]
  },
  "status" : "current",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "74209-8",
        "display" : "Injury event summary Document"
      }
    ],
    "text" : "驗傷報告"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "date" : "2024-01-23T15:45:00Z",
  "author" : [
    {
      "reference" : "Practitioner/pra-dr-example"
    }
  ],
  "custodian" : {
    "reference" : "Organization/org-hosp-example"
  },
  "content" : [
    {
      "attachment" : {
        "contentType" : "image/jpeg",
        "url" : "https://obs.line-scdn.net/0hJczFr9HRFUxHPzhi5CVqG31pFiN0UwZPIwlETwRRS3g5ClpKL1wPImRrSCg6D1ISKQlYKGY7Dn1jBlZPf1sP/w1200",
        "title" : "Wound Photo"
      }
    }
  ],
  "context" : {
    "encounter" : [
      {
        "reference" : "Encounter/enc-example"
      }
    ]
  }
}

```
