# 門診紀錄 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example DocumentReference: 門診紀錄

### 門診紀錄

**狀態**：Current ([DocumentReferenceStatus](http://hl7.org/fhir/R4/codesystem-document-reference-status.html)#current)

**類型(type)**：門診紀錄(Outpatient Note) ([LOINC](http://loinc.org)#34108-1)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**日期**：2024-01-23T12:34:56

**紀錄者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**紀錄維護機構**：[Organization/org-hosp-example](Organization-org-hosp-example.md) "衛生福利部臺北醫院"

**紀錄中使用的檔案**：

> **檔案類型(type)**：application/pdf**檔案**：[ConsultationReport.pdf](ConsultationReport.pdf)



## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "doc-outpatient-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore"
    ]
  },
  "status" : "current",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "34108-1",
        "display" : "Outpatient Note"
      }
    ],
    "text" : "門診紀錄"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "date" : "2024-01-23T12:34:56Z",
  "author" : [
    {
      "reference" : "Practitioner/pra-dr-example"
    }
  ],
  "custodian" : {
    "reference" : "Organization/org-hosp-example"
  },
  "content" : [
    {
      "attachment" : {
        "contentType" : "application/pdf",
        "url" : "ConsultationReport.pdf",
        "title" : "Consultation Report"
      }
    }
  ]
}

```
