# 診斷報告資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example DiagnosticReport: 診斷報告資料

### 診斷報告

**診斷狀態**：Remission ([DiagnosticReportStatus](http://hl7.org/fhir/R4/valueset-diagnostic-report-status.html)#registered)

**診斷分類**：Laboratory ([DiagnosticServiceSectionCodes](http://hl7.org/fhir/R4/valueset-diagnostic-service-sections.html)#LAB)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**臨床相關報告時間**：2022-08-01 05:00:14-0500

**診斷報告時間**：2022-08-01 06:00:14-0500

**病情、問題或診斷識別**：血中尿素氮([LOINC](http://loinc.org)#09002C)

**診斷結果**：[Observation/obs-lab-example](Observation-obs-lab-example.md)

**診斷者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "dia-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore"
    ]
  },
  "status" : "registered",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "LAB",
          "display" : "Laboratory"
        }
      ],
      "text" : "Laboratory"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw",
        "code" : "09002C",
        "display" : "血中尿素氮"
      }
    ],
    "text" : "血中尿素氮"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2022-08-01T17:00:14+08:00",
  "issued" : "2022-08-01T18:00:14+08:00",
  "performer" : [
    {
      "reference" : "Practitioner/pra-dr-example"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/obs-lab-example"
    }
  ]
}

```
