# 病情、問題或診斷資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Condition: 病情、問題或診斷資料

### 病情、問題或診斷資料

**臨床狀態**：Remission ([ConditionClinicalStatusCodes](http://terminology.hl7.org/CodeSystem/condition-clinical)#remission)

**驗證狀態**：Confirmed ([ConditionVerificationStatus](http://terminology.hl7.org/CodeSystem/condition-ver-status)#confirmed)

**病情、問題或診斷分類**：Encounter Diagnosis ([Condition Category Codes](http://terminology.hl7.org/CodeSystem/condition-category)#encounter-diagnosis)

**嚴重程度**：Mild ([LOINC](https://loinc.org/)#LA6752-5)

**病情、問題或診斷識別**：起因於潛在病的糖尿病，伴有低血糖，未伴有昏迷 ([臺灣2021年中文版ICD-10-CM](CodeSystem-icd-10-cm-2021-tw.md)#E08.649)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**實際日期**：2022-08-01 05:00:14-0500

**緩解日期**：2022-08-01 06:00:14-0500

**診斷者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "con-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "remission"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "encounter-diagnosis"
        }
      ]
    }
  ],
  "severity" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA6752-5"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2021-tw",
        "code" : "E08.649"
      }
    ],
    "text" : "起因於潛在病的糖尿病，伴有低血糖，未伴有昏迷"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "onsetDateTime" : "2022-08-01T17:00:14+08:00",
  "abatementDateTime" : "2022-08-01T18:00:14+08:00",
  "asserter" : {
    "reference" : "Practitioner/pra-dr-example"
  }
}

```
