# 臺灣健保署給藥途徑代碼對應SNOMED CT - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ConceptMap: 臺灣健保署給藥途徑代碼對應SNOMED CT 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ConceptMap/medication-path-tw | *Version*:0.3.0 |
| Active as of 2024-01-16 | *Computable Name*:TWMedicationPath |

 
此對應表為臺灣健保署給藥途徑代碼對應至國際標準碼SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "medication-path-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ConceptMap/medication-path-tw",
  "version" : "0.3.0",
  "name" : "TWMedicationPath",
  "title" : "臺灣健保署給藥途徑代碼對應SNOMED CT",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-01-16",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此對應表為臺灣健保署給藥途徑代碼對應至國際標準碼SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。",
  "sourceUri" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-path-tw",
  "targetUri" : "http://hl7.org/fhir/ValueSet/route-codes",
  "group" : [
    {
      "source" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-path-tw",
      "target" : "http://snomed.info/sct",
      "element" : [
        {
          "code" : "AD",
          "display" : "右耳",
          "target" : [
            {
              "code" : "10547007",
              "display" : "Auricular use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "AS",
          "display" : "左耳",
          "target" : [
            {
              "code" : "10547007",
              "display" : "Auricular use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "AU",
          "display" : "每耳",
          "target" : [
            {
              "code" : "10547007",
              "display" : "Auricular use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "HD",
          "display" : "皮下灌注",
          "target" : [
            {
              "code" : "1611000175109",
              "display" : "Sublesional route",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "IA",
          "display" : "動脈注射",
          "target" : [
            {
              "code" : "58100008",
              "display" : "Intra-arterial use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "ID",
          "display" : "皮內注射",
          "target" : [
            {
              "code" : "372464004",
              "display" : "Intradermal use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "IM",
          "display" : "肌肉注射",
          "target" : [
            {
              "code" : "78421000",
              "display" : "Intramuscular use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "IVA",
          "display" : "靜脈添加",
          "target" : [
            {
              "code" : "47625008",
              "display" : "Intravenous use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "IVD",
          "display" : "靜脈點滴滴入",
          "target" : [
            {
              "code" : "47625008",
              "display" : "Intravenous use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "IVI",
          "display" : "玻璃体內注射",
          "target" : [
            {
              "code" : "418401004",
              "display" : "Intravitreal route",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "IVP",
          "display" : "靜脈注入",
          "target" : [
            {
              "code" : "47625008",
              "display" : "Intravenous use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "NA",
          "display" : "鼻用",
          "target" : [
            {
              "code" : "46713006",
              "display" : "Nasal use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "OD",
          "display" : "右眼",
          "target" : [
            {
              "code" : "54485002",
              "display" : "Ophthalmic use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "OS",
          "display" : "左眼",
          "target" : [
            {
              "code" : "54485002",
              "display" : "Ophthalmic use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "OU",
          "display" : "每眼",
          "target" : [
            {
              "code" : "54485002",
              "display" : "Ophthalmic use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PO",
          "display" : "口服",
          "target" : [
            {
              "code" : "26643006",
              "display" : "Oral use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "SC",
          "display" : "皮下注射",
          "target" : [
            {
              "code" : "34206005",
              "display" : "SC use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "SCI",
          "display" : "結膜下注射",
          "target" : [
            {
              "code" : "416174007",
              "display" : "Suborbital use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "SKIN",
          "display" : "皮膚用",
          "target" : [
            {
              "code" : "448598008",
              "display" : "Cutaneous route",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "SL",
          "display" : "舌下",
          "target" : [
            {
              "code" : "37839007",
              "display" : "Sublingual use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "RECT",
          "display" : "肛門用",
          "target" : [
            {
              "code" : "37161004",
              "display" : "Rectal use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "TOPI",
          "display" : "局部塗擦(與LA易混淆)",
          "target" : [
            {
              "code" : "6064005",
              "display" : "Topical route",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "VAG",
          "display" : "陰道用",
          "target" : [
            {
              "code" : "16857009",
              "display" : "Vaginal use",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "EXT",
          "display" : "外用",
          "target" : [
            {
              "code" : "6064005",
              "display" : "Topical route",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    }
  ]
}

```
