# 臺灣中華郵政6碼郵遞區號 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣中華郵政6碼郵遞區號 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code6-tw | *Version*:2024-06-28 |
| Active as of 2024-06-28 | *Computable Name*:TWPostalCode6 |
| **Copyright/Legal**: 中華郵政 | |

 
臺灣中華郵政6碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的『3+3郵遞區號查詢應用系統』。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。
代碼出版日期：2020-10-22；資料所屬單位：中華郵政。 
**因原始資料無代碼版本資訊，故使用其公開授權聲明之「更新日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱。 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWPostalCode6](ValueSet-postal-code6-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "postal-code6-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code6-tw",
  "version" : "2024-06-28",
  "name" : "TWPostalCode6",
  "title" : "臺灣中華郵政6碼郵遞區號",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-06-28",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣中華郵政6碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的『3+3郵遞區號查詢應用系統』。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。    \n代碼出版日期：2020-10-22；資料所屬單位：中華郵政。\n\n*因原始資料無代碼版本資訊，故使用其公開授權聲明之「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱。",
  "copyright" : "中華郵政",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 28,
  "property" : [
    {
      "code" : "city",
      "description" : "鄉鎮市區",
      "type" : "string"
    },
    {
      "code" : "district",
      "description" : "縣市名稱",
      "type" : "string"
    },
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "100001",
      "display" : "臺北市中正區永綏街/延平南路/忠孝西路一段/武昌街一段/武昌街一段/重慶南路一段/重慶南路一段/博愛路/開封街一段/開封街一段/漢口街一段",
      "definition" : "臺北市中正區永綏街全;延平南路雙96號以下;忠孝西路一段雙122號以上;武昌街一段單45號以上;武昌街一段雙48號以上;重慶南路一段雙4號至8號;重慶南路一段雙12號至20號;博愛路雙130號以下;開封街一段單33號以上;開封街一段雙22號以上;漢口街一段雙128號以上",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100003",
      "display" : "臺北市中正區沅陵街/忠孝西路一段/武昌街一段/武昌街一段/重慶南路一段/重慶南路一段/重慶南路一段/重慶南路一段/博愛路",
      "definition" : "臺北市中正區沅陵街全;忠孝西路一段雙94號至120號;武昌街一段單43號以下;武昌街一段雙46號以下;重慶南路一段單39號至75號;重慶南路一段單81號至87號;重慶南路一段雙22號至28號;重慶南路一段雙32號至94號;博愛路單67號至103號",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100004",
      "display" : "臺北市中正區重慶南路一段/重慶南路一段/博愛路/衡陽路/衡陽路/襄陽路/襄陽路/懷寧街/懷寧街/寶慶路",
      "definition" : "臺北市中正區重慶南路一段單89號至163號;重慶南路一段雙96號至118巷;博愛路單105號至119號;衡陽路單71號以下;衡陽路雙70號以下;襄陽路單27號以上;襄陽路雙4號以上;懷寧街單79號以上;懷寧街雙76號以上;寶慶路1號",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100005",
      "display" : "臺北市中正區中華路一段/秀山街/酉陽街/延平南路/延平南路/桃源街/博愛路/博愛路/衡陽路/衡陽路/寶慶路/寶慶路",
      "definition" : "臺北市中正區中華路一段單1巷至55號;秀山街全;酉陽街全;延平南路單89號至117號;延平南路雙98號至140號;桃源街全;博愛路單65號以下;博愛路雙152號至162號;衡陽路單73號以上;衡陽路雙72號以上;寶慶路單5號以上;寶慶路32號",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100006",
      "display" : "臺北市中正區中華路一段/公園路/公園路/延平南路/延平南路/長沙街一段/重慶南路一段/重慶南路一段/重慶南路一段/重慶南路一段/常德街/常德街/凱達格蘭大道/凱達格蘭大道/博愛路/博愛路/貴陽街一段/愛國西路/漢口街一段/漢口街一段",
      "definition" : "臺北市中正區中華路一段單57號以上;公園路單15之3號以上;公園路雙52號以上;延平南路單119號至141號;延平南路雙142號至182號;長沙街一段全;重慶南路一段單37號以下;重慶南路一段單165號以上;重慶南路一段雙120號至122號;重慶南路一段雙126巷以上;常德街單3號以上;常德街雙全;凱達格蘭大道單全;凱達格蘭大道雙4號以上;博愛路133號;博愛路雙164號至172號;貴陽街一段全;愛國西路單3號以上;漢口街一段單37號至83號;漢口街一段雙52號至100號",
      "property" : [
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        }
      ]
    },
    {
      "code" : "100007",
      "display" : "臺北市中正區忠孝西路一段/信陽街/南陽街/南陽街/開封街一段/開封街一段/漢口街一段/館前路/襄陽路/襄陽路/懷寧街/懷寧街",
      "definition" : "臺北市中正區忠孝西路一段雙68號至92號;信陽街全;南陽街單15號以上;南陽街雙24號以上;開封街一段單31號以下;開封街一段雙20號以下;漢口街一段單35號以下;館前路雙全;襄陽路單3號至25號;襄陽路2號;懷寧街單77號以下;懷寧街雙74號以下",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        }
      ]
    },
    {
      "code" : "100008",
      "display" : "臺北市中正區中山南路/中山南路/公園路/公園路/忠孝西路一段/忠孝西路一段/忠孝西路一段/林森南路/青島西路/青島東路/青島東路/南陽街/南陽街/許昌街/漢口街一段/鎮江街",
      "definition" : "臺北市中正區中山南路單3號至9號;中山南路雙全;公園路單15之1號以下;公園路雙50號以下;忠孝西路一段2號;忠孝西路一段雙8號至48號;忠孝西路一段雙52號至64號;林森南路雙12號以下;青島西路全;青島東路單3號至9號;青島東路雙10號以下;南陽街單13號以下;南陽街雙22號以下;許昌街全;漢口街一段雙50號以下;鎮江街全",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        }
      ]
    },
    {
      "code" : "100009",
      "display" : "臺北市中正區中山北路一段/中山北路一段/天津街/天津街/北平西路/北平西路/北平西路/北平東路/北平東路/市民大道一段/市民大道二段/延平南路/忠孝西路一段/忠孝東路一段/漢口街一段/漢口街一段/鄭州路",
      "definition" : "臺北市中正區中山北路一段單3號以下;中山北路一段雙48號以下;天津街單15號以下;天津街雙12號以下;北平西路1號;北平西路單5號至49號;北平西路雙全;北平東路單全;北平東路雙2之1號以上;市民大道一段雙100號至168號;市民大道二段雙全;延平南路單43號以下;忠孝西路一段單全;忠孝東路一段單全;漢口街一段單85號以上;漢口街一段雙102號至126號;鄭州路8號",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        }
      ]
    },
    {
      "code" : "100010",
      "display" : "臺北市中正區忠孝東路二段/杭州北路/金山南路一段/臨沂街/臨沂街/臨沂街",
      "definition" : "臺北市中正區忠孝東路二段雙全;杭州北路全;金山南路一段單15號以下;臨沂街單7號至27號;臨沂街27巷全;臨沂街雙6巷至18號",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100011",
      "display" : "臺北市中正區延平南路/林森北路/林森北路/信義路二段/信義路二段/信義路二段/博愛路/館前路",
      "definition" : "臺北市中正區延平南路單45號至87號;林森北路單35號以下;林森北路雙32號以下;信義路二段17巷全;信義路二段45巷全;信義路二段79巷全;博愛路雙132號至150號;館前路單全",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100012",
      "display" : "臺北市中正區中山南路/金山南路一段/信義路一段/信義路一段/信義路二段/信義路二段/信義路二段/信義路二段/臨沂街",
      "definition" : "臺北市中正區中山南路單11號以上;金山南路一段單65號以上;信義路一段單全;信義路一段雙全;信義路二段單15號以下;信義路二段單19號至43號;信義路二段單47號至77號;信義路二段單81號至121號;臨沂街雙40號以上",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100013",
      "display" : "臺北市中正區八德路一段/市民大道三段/市民大道三段/忠孝東路二段/金山北路/紹興北街/新生北路一段/新生南路一段/臨沂街/臨沂街",
      "definition" : "臺北市中正區八德路一段全;市民大道三段雙6號以下;市民大道三段雙10號至84號;忠孝東路二段單全;金山北路全;紹興北街全;新生北路一段雙34號以下;新生南路一段雙44號以下;臨沂街單5號以下;臨沂街雙4號以下",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-12"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100014",
      "display" : "臺北市中正區仁愛路二段/市民大道三段/新生南路一段/濟南路二段",
      "definition" : "臺北市中正區仁愛路二段單37號以上;市民大道三段8號;新生南路一段雙50之1號至122號;濟南路二段62巷全",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100015",
      "display" : "臺北市中正區信義路二段/連雲街/連雲街/連雲街/連雲街/新生南路一段",
      "definition" : "臺北市中正區信義路二段單247號以上;連雲街29巷全;連雲街37巷全;連雲街單71號至81號;連雲街雙72號至74號;新生南路一段雙124號以上",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100016",
      "display" : "臺北市中正區信義路二段/連雲街/連雲街/連雲街/連雲街/連雲街/連雲街/臨沂街/臨沂街/臨沂街/臨沂街/臨沂街/臨沂街/臨沂街/臨沂街",
      "definition" : "臺北市中正區信義路二段單123號至245號;連雲街27號;連雲街單31號至35號;連雲街單39號至69號;連雲街單83號以上;連雲街雙38號至70號;連雲街74巷全;臨沂街45巷全;臨沂街71巷單17號以下;臨沂街71巷單19號以上;臨沂街71巷雙全;臨沂街單75巷以上;臨沂街雙20號至22號;臨沂街雙26號至30號;臨沂街雙34號至38號",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100017",
      "display" : "臺北市中正區仁愛路二段/臨沂街/臨沂街/臨沂街/臨沂街",
      "definition" : "臺北市中正區仁愛路二段雙68號以上;臨沂街單63巷至69號;臨沂街69巷全;臨沂街71巷19弄全;臨沂街73號",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100018",
      "display" : "臺北市中正區仁愛路二段/連雲街/連雲街/臨沂街/臨沂街/臨沂街",
      "definition" : "臺北市中正區仁愛路二段雙48之1號至66號;連雲街單25號以下;連雲街雙36號以下;臨沂街單29巷至41號;臨沂街單47號至61號;臨沂街61巷全",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100019",
      "display" : "臺北市中正區仁愛路一段/仁愛路一段/杭州南路一段/杭州南路一段/杭州南路一段/金山南路一段",
      "definition" : "臺北市中正區仁愛路一段雙40號以下;仁愛路一段雙52號以上;杭州南路一段71巷單全;杭州南路一段單117號以上;杭州南路一段雙24號以上;金山南路一段雙96號以上",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100020",
      "display" : "臺北市中正區仁愛路二段/杭州南路一段/杭州南路一段/杭州南路一段/金山南路一段",
      "definition" : "臺北市中正區仁愛路二段雙48號以下;杭州南路一段71巷雙全;杭州南路一段單101號至115號;杭州南路一段101巷全;金山南路一段雙72號至94號",
      "property" : [
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        }
      ]
    },
    {
      "code" : "100022",
      "display" : "臺北市中正區杭州南路一段/杭州南路一段/杭州南路一段/金山南路一段/金山南路一段/泰安街/銅山街/臨沂街/臨沂街",
      "definition" : "臺北市中正區杭州南路一段單35號至69號;杭州南路一段單73號至75號;杭州南路一段單79號至99號;金山南路一段單17號至63巷;金山南路一段雙58號至70號;泰安街全;銅山街全;臨沂街24巷全;臨沂街32巷全",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100023",
      "display" : "臺北市中正區杭州南路一段/金山南路一段/齊東街/濟南路二段/濟南路二段/濟南路二段",
      "definition" : "臺北市中正區杭州南路一段單21巷至33號;金山南路一段雙56號以下;齊東街全;濟南路二段單3號至73號;濟南路二段雙60號以下;濟南路二段雙64號以上",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100024",
      "display" : "臺北市中正區忠孝東路一段/杭州南路一段/杭州南路一段/林森南路/青島東路/青島東路/紹興南街/紹興南街",
      "definition" : "臺北市中正區忠孝東路一段雙全;杭州南路一段單19號以下;杭州南路一段雙10號以下;林森南路單31號以下;青島東路單11號以上;青島東路雙12號以上;紹興南街單5號以下;紹興南街雙4號以下",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100025",
      "display" : "臺北市中正區仁愛路一段/林森南路/林森南路/徐州路/紹興南街/紹興南街/濟南路一段",
      "definition" : "臺北市中正區仁愛路一段單3號至35號;林森南路單33號至113號;林森南路雙14號至104號;徐州路全;紹興南街單7號以上;紹興南街雙6號以上;濟南路一段單5號以上",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        }
      ]
    },
    {
      "code" : "100026",
      "display" : "臺北市中正區丹陽街/仁愛路一段/仁愛路二段/杭州南路一段/杭州南路一段/濟南路一段",
      "definition" : "臺北市中正區丹陽街全;仁愛路一段單37號以上;仁愛路二段單35號以下;杭州南路一段77巷全;杭州南路一段雙12號至22號;濟南路一段雙全",
      "property" : [
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        }
      ]
    },
    {
      "code" : "100027",
      "display" : "臺北市中正區和平西路一段/和平西路一段/和平西路二段/福州街/福州街",
      "definition" : "臺北市中正區和平西路一段單21號以上;和平西路一段雙80號以上;和平西路二段單59號以下;福州街單49號以下;福州街雙10巷以上",
      "property" : [
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "100028",
      "display" : "臺北市中正區和平西路一段/和平西路一段/南昌路一段/牯嶺街/愛國東路/羅斯福路二段",
      "definition" : "臺北市中正區和平西路一段單19號以下;和平西路一段雙78號以下;南昌路一段單77號以上;牯嶺街93號;愛國東路1號;羅斯福路二段雙98號以下",
      "property" : [
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-06"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "100029",
      "display" : "臺北市中正區金華街/金華街/寧波東街/寧波東街/潮州街/羅斯福路一段",
      "definition" : "臺北市中正區金華街單49號以下;金華街雙18號以下;寧波東街單9巷以下;寧波東街雙全;潮州街單9號以下;羅斯福路一段單25號至97號",
      "property" : [
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "100030",
      "display" : "臺北市中正區杭州南路二段/金華街/金華街/愛國東路/潮州街/羅斯福路一段/羅斯福路二段",
      "definition" : "臺北市中正區杭州南路二段雙全;金華街單51號至109號;金華街雙20號至34號;愛國東路雙100號至158號;潮州街雙4號至20號;羅斯福路一段單99號以上;羅斯福路二段單13號以下",
      "property" : [
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-10-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
