# 臺灣中華郵政3碼郵遞區號 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣中華郵政3碼郵遞區號 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw | *Version*:2015-01-22 |
| Active as of 2015-01-22 | *Computable Name*:TWPostalCode3 |
| **Copyright/Legal**: 中華郵政 | |

 
臺灣中華郵政3碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的「臺灣地區郵遞區號前3碼一覽表 103/12(Excel版)」。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。
代碼出版日期：2015-01-22；資料所屬單位：中華郵政。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWPostalCode3](ValueSet-postal-code3-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "postal-code3-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
  "version" : "2015-01-22",
  "name" : "TWPostalCode3",
  "title" : "臺灣中華郵政3碼郵遞區號",
  "status" : "active",
  "experimental" : false,
  "date" : "2015-01-22",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣中華郵政3碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的「臺灣地區郵遞區號前3碼一覽表 103/12(Excel版)」。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。   \n代碼出版日期：2015-01-22；資料所屬單位：中華郵政。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱\n\n\n",
  "copyright" : "中華郵政",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 5,
  "property" : [
    {
      "code" : "city",
      "description" : "鄉鎮市區",
      "type" : "string"
    },
    {
      "code" : "district",
      "description" : "縣市名稱",
      "type" : "string"
    },
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "103",
      "display" : "臺北市大同區",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "大同區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2015-01-22"
        }
      ]
    },
    {
      "code" : "105",
      "display" : "臺北市松山區",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "松山區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2015-01-22"
        }
      ]
    },
    {
      "code" : "330",
      "display" : "桃園市桃園區",
      "property" : [
        {
          "code" : "city",
          "valueString" : "桃園區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2015-01-22"
        },
        {
          "code" : "district",
          "valueString" : "桃園市"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "414",
      "display" : "臺中市烏日區",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "city",
          "valueString" : "烏日區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2015-01-22"
        },
        {
          "code" : "district",
          "valueString" : "臺中市"
        }
      ]
    },
    {
      "code" : "911",
      "display" : "屏東縣竹田鄉",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-12-28"
        },
        {
          "code" : "district",
          "valueString" : "屏東縣"
        },
        {
          "code" : "city",
          "valueString" : "竹田"
        }
      ]
    }
  ]
}

```
