# 臺灣勞動部職業標準分類 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣勞動部職業標準分類 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/occupation-mol-tw | *Version*:2010-05-01 |
| Active as of 2010-05-01 | *Computable Name*:TWMolOccupation |
| **Copyright/Legal**: 中華民國勞動部 | |

 
臺灣勞動部職業標準分類，參照至[中華民國勞動部](https://www.mol.gov.tw/1607/2458/2510/)的[職業標準分類(第6次修訂)](https://statdb.mol.gov.tw/html/svy12/1236menu.htm)代碼出版日期：2010-05-01；資料所屬單位：中華民國勞動部。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWMolOccupation](ValueSet-occupation-mol-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "occupation-mol-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/occupation-mol-tw",
  "version" : "2010-05-01",
  "name" : "TWMolOccupation",
  "title" : "臺灣勞動部職業標準分類",
  "status" : "active",
  "experimental" : false,
  "date" : "2010-05-01",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣勞動部職業標準分類，參照至[中華民國勞動部](https://www.mol.gov.tw/1607/2458/2510/)的[職業標準分類(第6次修訂)](https://statdb.mol.gov.tw/html/svy12/1236menu.htm)\n代碼出版日期：2010-05-01；資料所屬單位：中華民國勞動部。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*",
  "copyright" : "中華民國勞動部",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "count" : 554,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "1",
      "display" : "民意代表、主管及經理人員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2010-05-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "11",
          "display" : "民意代表、高階主管及總執行長",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "111",
              "display" : "民意代表及高階主管人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1111",
                  "display" : "民意代表",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1112",
                  "display" : "政府高階主管人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1113",
                  "display" : "民間團體高階主管人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "112",
              "display" : "總經理及總執行長",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1120",
                  "display" : "總經理及總執行長",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "12",
          "display" : "行政及商業經理人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "121",
              "display" : "企業服務及行政經理人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1211",
                  "display" : "財務經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1212",
                  "display" : "人力資源經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1219",
                  "display" : "其他企業服務及行政經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "122",
              "display" : "行銷及研發經理人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1221",
                  "display" : "行銷及有關經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1222",
                  "display" : "廣告及公關經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1223",
                  "display" : "研究發展經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "13",
          "display" : "生產及專業服務經理人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "131",
              "display" : "農、林、漁、牧業生產經理人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1310",
                  "display" : "農、林、漁、牧業生產經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "132",
              "display" : "採礦、製造、營造及配送經理人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1321",
                  "display" : "採礦及採石經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1322",
                  "display" : "製造經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1323",
                  "display" : "營造經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1324",
                  "display" : "供給、配送及倉儲經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "133",
              "display" : "資訊及通訊技術服務經理人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1330",
                  "display" : "資訊及通訊技術服務經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "134",
              "display" : "專業服務經理人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1341",
                  "display" : "醫療保健服務主管人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1342",
                  "display" : "老人照顧服務主管人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1343",
                  "display" : "社會福利服務主管人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1344",
                  "display" : "教育服務主管人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1345",
                  "display" : "金融及保險服務經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1349",
                  "display" : "其他專業服務經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "14",
          "display" : "餐旅、零售及其他場所服務經理人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "141",
              "display" : "旅館及餐廳經理人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1411",
                  "display" : "旅館經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1412",
                  "display" : "餐廳經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "142",
              "display" : "批發及零售場所經理人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1420",
                  "display" : "批發及零售場所經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "149",
              "display" : "其他場所服務經理人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1491",
                  "display" : "運動、休閒及文化中心經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1499",
                  "display" : "未分類其他場所服務經理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "2",
      "display" : "專業人員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2010-05-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "21",
          "display" : "科學及工程專業人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "211",
              "display" : "物理、化學及地球科學專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2111",
                  "display" : "物理及天文學專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2112",
                  "display" : "氣象學專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2113",
                  "display" : "化學專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2114",
                  "display" : "地質及地球物理學專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "212",
              "display" : "數學、精算及統計學專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2120",
                  "display" : "數學、精算及統計學專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "213",
              "display" : "生命科學專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2131",
                  "display" : "生物、植物及動物學有關專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2132",
                  "display" : "農、林、漁、牧業專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2133",
                  "display" : "環境保護專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "214",
              "display" : "非電科技工程專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2141",
                  "display" : "工業及生產工程師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2142",
                  "display" : "土木工程師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2143",
                  "display" : "環境工程師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2144",
                  "display" : "機械工程師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2145",
                  "display" : "化學工程師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2146",
                  "display" : "採礦工程師、冶金學及有關專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2149",
                  "display" : "其他工程專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "215",
              "display" : "電科技工程師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2151",
                  "display" : "電機工程師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2152",
                  "display" : "電子工程師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2153",
                  "display" : "電信工程師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "216",
              "display" : "建築師、規劃師及測量師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2161",
                  "display" : "建築師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2162",
                  "display" : "都市及交通規劃師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2163",
                  "display" : "測量師及製圖師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "217",
              "display" : "設計師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2171",
                  "display" : "室內設計師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2172",
                  "display" : "平面及多媒體設計師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2173",
                  "display" : "產品及服裝設計師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "22",
          "display" : "醫療保健專業人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "221",
              "display" : "醫師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2210",
                  "display" : "醫師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "222",
              "display" : "護理及助產專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2220",
                  "display" : "護理及助產專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "223",
              "display" : "牙醫師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2230",
                  "display" : "牙醫師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "224",
              "display" : "中醫師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2240",
                  "display" : "中醫師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "225",
              "display" : "獸醫師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2250",
                  "display" : "獸醫師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "226",
              "display" : "藥師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2260",
                  "display" : "藥師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "229",
              "display" : "其他醫療保健專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2291",
                  "display" : "環境及職業衛生專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2292",
                  "display" : "物理治療師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2293",
                  "display" : "營養師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2294",
                  "display" : "聽力及語言治療師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2295",
                  "display" : "職能治療師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2299",
                  "display" : "未分類其他醫療保健專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "23",
          "display" : "教學專業人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "231",
              "display" : "高等教育教師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2310",
                  "display" : "高等教育教師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "232",
              "display" : "中等教育教師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2320",
                  "display" : "中等教育教師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "233",
              "display" : "初等教育及學前教育教師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2331",
                  "display" : "初等教育教師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2332",
                  "display" : "學前教育人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "234",
              "display" : "特殊教育教師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2340",
                  "display" : "特殊教育教師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "239",
              "display" : "其他教學專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2391",
                  "display" : "語言才藝教師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2392",
                  "display" : "音樂才藝教師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2393",
                  "display" : "藝術才藝教師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2394",
                  "display" : "資訊技術訓練師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2395",
                  "display" : "升學及就業補習班教師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2399",
                  "display" : "未分類其他教學專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "24",
          "display" : "商業及行政專業人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "241",
              "display" : "財務專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2411",
                  "display" : "會計專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2412",
                  "display" : "財務及投資顧問",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "242",
              "display" : "行政專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2421",
                  "display" : "組織及政策管理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2422",
                  "display" : "人事及員工培訓專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "243",
              "display" : "行銷、公關及技術銷售專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2431",
                  "display" : "廣告及行銷專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2432",
                  "display" : "公關專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2433",
                  "display" : "資訊及通訊技術銷售專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2434",
                  "display" : "醫療及其他技術銷售專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "25",
          "display" : "資訊及通訊專業人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "251",
              "display" : "軟體與應用程式開發人員及分析師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2511",
                  "display" : "系統分析及設計師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2512",
                  "display" : "軟體開發及程式設計師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2513",
                  "display" : "網站及多媒體程式開發人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2519",
                  "display" : "其他軟體、應用程式開發人員及分析師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "252",
              "display" : "資料庫及網路專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2521",
                  "display" : "資料庫設計師及管理師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2522",
                  "display" : "系統管理師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2523",
                  "display" : "電腦網路專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2529",
                  "display" : "其他資料庫及網路專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "26",
          "display" : "法律、社會及文化專業人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "261",
              "display" : "法律專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2611",
                  "display" : "律師及公設辯護人",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2612",
                  "display" : "法官",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2613",
                  "display" : "檢察官",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2619",
                  "display" : "其他法律專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "262",
              "display" : "檔案、文物及圖書館管理專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2621",
                  "display" : "檔案及文物管理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2622",
                  "display" : "圖書館管理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "263",
              "display" : "社會及宗教專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2631",
                  "display" : "經濟學專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2632",
                  "display" : "社會、人類學及有關專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2633",
                  "display" : "哲學、歷史及政治學專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2634",
                  "display" : "心理學專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2635",
                  "display" : "社會工作專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2636",
                  "display" : "宗教專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "264",
              "display" : "作家、新聞記者及語言學專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2641",
                  "display" : "作家及有關撰稿人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2642",
                  "display" : "新聞記者",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2643",
                  "display" : "語言學及翻譯專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "265",
              "display" : "創作及表演藝術人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2651",
                  "display" : "視覺藝術創作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2652",
                  "display" : "音樂、歌唱表演及作曲人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2653",
                  "display" : "舞蹈表演及編舞人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2654",
                  "display" : "電影、舞台及有關導演與製作人",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2655",
                  "display" : "演員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2656",
                  "display" : "廣播、電視及其他媒體播報員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2659",
                  "display" : "其他創作及表演藝術人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "3",
      "display" : "技術員及助理專業人員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2010-05-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "31",
          "display" : "科學及工程助理專業人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "311",
              "display" : "物理、化學及工程科學技術員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3111",
                  "display" : "物理及化學技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3112",
                  "display" : "營建工程技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3113",
                  "display" : "電機工程技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3114",
                  "display" : "電子工程技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3115",
                  "display" : "機械工程技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3116",
                  "display" : "化學工程技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3117",
                  "display" : "工業及生產技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3118",
                  "display" : "製圖員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3119",
                  "display" : "其他工程科學技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "312",
              "display" : "採礦、製造及營造監督人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3121",
                  "display" : "採礦監督人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3122",
                  "display" : "製造監督人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3123",
                  "display" : "營造監督人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "313",
              "display" : "製程控制技術員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3131",
                  "display" : "發電設備操作員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3132",
                  "display" : "焚化爐、水處理及有關設備操作員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3133",
                  "display" : "化學加工設備控制員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3134",
                  "display" : "石油及天然氣精煉設備操作員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3135",
                  "display" : "金屬生產製程控制員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3139",
                  "display" : "其他製程控制技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "314",
              "display" : "生命科學技術員及有關助理專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3141",
                  "display" : "生命科學技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3142",
                  "display" : "農、林、漁、牧技術員及推廣人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "315",
              "display" : "船舶、航空器監管及有關技術員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3151",
                  "display" : "船舶輪機長及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3152",
                  "display" : "船舶艙面監管及引水人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3153",
                  "display" : "飛航駕駛員及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3154",
                  "display" : "飛航管制員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3155",
                  "display" : "飛航安全電子技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "32",
          "display" : "醫療保健助理專業人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "321",
              "display" : "醫學及藥學技術員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3211",
                  "display" : "醫學影像及治療設備技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3212",
                  "display" : "醫學及病理檢驗技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3213",
                  "display" : "藥學技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3214",
                  "display" : "醫學及牙科輔具技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "322",
              "display" : "護理助理專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3220",
                  "display" : "護理助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "323",
              "display" : "傳統醫學技術員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3230",
                  "display" : "傳統醫學技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "324",
              "display" : "獸醫助理專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3240",
                  "display" : "獸醫助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "329",
              "display" : "其他醫療保健助理專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3291",
                  "display" : "牙醫助理人員及鑲牙生",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3292",
                  "display" : "醫學紀錄及保健資訊技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3293",
                  "display" : "配鏡技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3294",
                  "display" : "物理治療技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3295",
                  "display" : "環境及職業衛生技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3296",
                  "display" : "救護車工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3299",
                  "display" : "未分類其他醫療保健助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "33",
          "display" : "商業及行政助理專業人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "331",
              "display" : "財務及數學助理專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3311",
                  "display" : "證券金融交易員及經紀人",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3312",
                  "display" : "信用及貸款人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3313",
                  "display" : "會計助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3314",
                  "display" : "統計、數學及精算助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3315",
                  "display" : "財物及損失鑑價人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "332",
              "display" : "銷售及採購代理人與經紀人",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3321",
                  "display" : "保險代理人",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3322",
                  "display" : "商業銷售代表",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3323",
                  "display" : "採購員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3324",
                  "display" : "買賣經紀人",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "333",
              "display" : "企業支援服務代理人",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3331",
                  "display" : "報關代理人",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3332",
                  "display" : "會議及活動規劃人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3333",
                  "display" : "職業介紹人及承包人",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3334",
                  "display" : "不動產經紀人",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3339",
                  "display" : "其他企業支援服務代理人",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "334",
              "display" : "辦公室監督人員及專業祕書",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3341",
                  "display" : "辦公室監督人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3342",
                  "display" : "專業秘書",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "335",
              "display" : "政府管理助理專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3351",
                  "display" : "海關及邊界檢查人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3352",
                  "display" : "政府稅務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3353",
                  "display" : "政府社會福利人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3354",
                  "display" : "政府核照人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3355",
                  "display" : "政府偵查人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3359",
                  "display" : "其他政府管理助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "34",
          "display" : "法律、社會、文化及有關助理專業人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "341",
              "display" : "法律、社會及宗教助理專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3411",
                  "display" : "法律及有關助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3412",
                  "display" : "社會工作助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3413",
                  "display" : "宗教助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "342",
              "display" : "運動及健身工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3421",
                  "display" : "運動員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3422",
                  "display" : "運動、健身及休閒娛樂指導員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "343",
              "display" : "藝術、文化及烹飪助理專業人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3431",
                  "display" : "攝影師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3432",
                  "display" : "美術館、圖書館及博物館助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3433",
                  "display" : "行政主廚",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3439",
                  "display" : "其他藝術及文化有關助理專業人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "35",
          "display" : "資訊及通訊傳播技術員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "351",
              "display" : "資訊及通訊技術員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3511",
                  "display" : "資訊及通訊操作技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3512",
                  "display" : "資訊及通訊使用者支援技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3513",
                  "display" : "電腦網路及系統技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3514",
                  "display" : "網站技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "352",
              "display" : "電信及傳播技術員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3521",
                  "display" : "廣播及視聽技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3522",
                  "display" : "電信工程技術員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "4",
      "display" : "事務支援人員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2010-05-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "41",
          "display" : "一般及文書事務人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "411",
              "display" : "一般辦公室事務人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4110",
                  "display" : "一般辦公室事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "412",
              "display" : "事務秘書",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4120",
                  "display" : "事務秘書",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "413",
              "display" : "資料輸入及有關事務人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4130",
                  "display" : "資料輸入及有關事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "42",
          "display" : "顧客服務事務人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "421",
              "display" : "銀行櫃員、收帳員及有關事務人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4211",
                  "display" : "銀行櫃員及有關事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4212",
                  "display" : "博弈及有關事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4213",
                  "display" : "典當及有關事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4214",
                  "display" : "收帳及有關事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "422",
              "display" : "顧客資訊事務人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4221",
                  "display" : "旅遊諮詢及有關事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4222",
                  "display" : "接待員及服務台事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4223",
                  "display" : "總機人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4224",
                  "display" : "電話及網路客服人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4225",
                  "display" : "統計調查訪談人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4229",
                  "display" : "其他顧客資訊事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "43",
          "display" : "會計、生產、運輸及有關事務人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "431",
              "display" : "會計、統計及有關事務人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4311",
                  "display" : "會計及簿記事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4312",
                  "display" : "統計、財務及保險事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "432",
              "display" : "生產、運輸及有關事務人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4321",
                  "display" : "存貨事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4322",
                  "display" : "生產事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4323",
                  "display" : "運輸事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "49",
          "display" : "其他事務支援人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "491",
              "display" : "人事事務人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4910",
                  "display" : "人事事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "499",
              "display" : "未分類其他事務支援人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4991",
                  "display" : "圖書館事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4992",
                  "display" : "郵件處理及投遞人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4993",
                  "display" : "編碼、校對及有關事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4994",
                  "display" : "歸檔及複印事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4995",
                  "display" : "教育有關事務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4999",
                  "display" : "其他未分類事務支援人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "5",
      "display" : "服務及銷售工作人員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2010-05-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "51",
          "display" : "個人服務工作人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "511",
              "display" : "旅運服務及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5111",
                  "display" : "飛機及船舶旅運服務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5112",
                  "display" : "隨車服務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5113",
                  "display" : "嚮導人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "512",
              "display" : "廚師",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5120",
                  "display" : "廚師",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "513",
              "display" : "餐飲服務人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5131",
                  "display" : "飲料調製員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5139",
                  "display" : "其他餐飲服務人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "514",
              "display" : "美髮、美容及造型設計有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5140",
                  "display" : "美髮、美容及造型設計有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "515",
              "display" : "建築物及家事管理員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5151",
                  "display" : "建築物管理員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5152",
                  "display" : "家庭家事管理員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5159",
                  "display" : "其他場所家事管理員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "519",
              "display" : "其他個人服務工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5191",
                  "display" : "占星、算命及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5192",
                  "display" : "殯葬及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5193",
                  "display" : "寵物美容師及動物照料工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5194",
                  "display" : "汽車駕駛教練",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5199",
                  "display" : "未分類其他個人服務工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "52",
          "display" : "銷售及展示工作人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "521",
              "display" : "街頭及市場銷售人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5211",
                  "display" : "攤販及市場銷售人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5212",
                  "display" : "街頭餐飲銷售人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "522",
              "display" : "商店銷售有關人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5220",
                  "display" : "商店銷售有關人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "523",
              "display" : "收銀員及售票員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5230",
                  "display" : "收銀員及售票員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "529",
              "display" : "其他銷售及展示工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5291",
                  "display" : "時裝及其他模特兒",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5292",
                  "display" : "展售說明人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5293",
                  "display" : "家戶推銷員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5294",
                  "display" : "電話及網路行銷人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5295",
                  "display" : "加油站服務員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5296",
                  "display" : "餐食服務櫃台工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5299",
                  "display" : "未分類其他銷售及展示工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "53",
          "display" : "個人照顧工作人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "531",
              "display" : "兒童照顧工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5310",
                  "display" : "兒童照顧工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "532",
              "display" : "個人健康照顧工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5320",
                  "display" : "個人健康照顧工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "54",
          "display" : "保安服務工作人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "540",
              "display" : "保安服務工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5401",
                  "display" : "消防人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5402",
                  "display" : "警察",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5403",
                  "display" : "法警及矯正機關戒護人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5404",
                  "display" : "保全及警衛人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5409",
                  "display" : "其他保安服務工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "6",
      "display" : "農、林、漁、牧業生產人員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2010-05-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "60",
          "display" : "農、林、漁、牧業生產人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "601",
              "display" : "農藝及園藝作物栽培人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6010",
                  "display" : "農藝及園藝作物栽培人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "602",
              "display" : "動物飼育人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6021",
                  "display" : "家畜飼育人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6022",
                  "display" : "家禽飼育人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6023",
                  "display" : "養蜂及養蠶人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6029",
                  "display" : "其他動物飼育人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "603",
              "display" : "農牧綜合生產人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6030",
                  "display" : "農牧綜合生產人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "604",
              "display" : "林業生產人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6040",
                  "display" : "林業生產人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "605",
              "display" : "漁業生產人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6051",
                  "display" : "水產養殖人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6052",
                  "display" : "內陸、沿岸及近海漁撈人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6053",
                  "display" : "遠洋漁撈人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "7",
      "display" : "技藝有關工作人員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2010-05-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "71",
          "display" : "營建及有關工作人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "711",
              "display" : "營建構造及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7111",
                  "display" : "砌磚及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7112",
                  "display" : "砌石、裁石及石雕工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7113",
                  "display" : "混凝土鋪設及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7114",
                  "display" : "營建木作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7119",
                  "display" : "其他營建構造及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "712",
              "display" : "建築物修整及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7121",
                  "display" : "屋頂工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7122",
                  "display" : "地面、牆面鋪設及磁磚鋪貼人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7123",
                  "display" : "泥作工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7124",
                  "display" : "絕緣材料安裝人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7125",
                  "display" : "玻璃安裝人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7126",
                  "display" : "管道裝設人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7127",
                  "display" : "空調及冷凍機械裝修人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "713",
              "display" : "油漆、建築物清潔及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7131",
                  "display" : "油漆、噴漆及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7132",
                  "display" : "建築物清潔人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "72",
          "display" : "金屬、機具製造及有關工作人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "721",
              "display" : "金屬鑄模、焊接、板金及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7211",
                  "display" : "金屬砂模及砂心製造人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7212",
                  "display" : "焊接及切割人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7213",
                  "display" : "板金人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7214",
                  "display" : "金屬結構預備及組合人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7215",
                  "display" : "索具裝置及鋼纜絞結人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "722",
              "display" : "鍛造、工具製造及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7221",
                  "display" : "鍛造、錘造及鍛壓工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7222",
                  "display" : "工具製造及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7223",
                  "display" : "金屬工具機設定及操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7224",
                  "display" : "金屬打磨及工具磨削人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "723",
              "display" : "機械維修人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7231",
                  "display" : "機動車輛維修人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7232",
                  "display" : "航空器維修人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7233",
                  "display" : "產業用機器維修人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7234",
                  "display" : "自行車及有關維修人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "73",
          "display" : "手工藝及印刷工作人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "731",
              "display" : "手工藝工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7311",
                  "display" : "精密儀器製造及修理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7312",
                  "display" : "樂器製造及調音人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7313",
                  "display" : "珠寶及貴金屬製作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7314",
                  "display" : "陶瓷製品有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7315",
                  "display" : "玻璃製造、切割、研磨及修整人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7316",
                  "display" : "招牌書寫、裝飾繪畫、雕刻及蝕刻人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7317",
                  "display" : "木、竹、藤及有關材質手工藝工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7318",
                  "display" : "紡織品及皮革手工藝工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7319",
                  "display" : "其他手工藝工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "732",
              "display" : "印刷及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7321",
                  "display" : "印刷前置工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7322",
                  "display" : "印刷人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7323",
                  "display" : "裝訂及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "74",
          "display" : "電力及電子設備裝修人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "741",
              "display" : "電力設備裝修人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7411",
                  "display" : "建築物電力系統裝修人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7412",
                  "display" : "電力機械裝修人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7413",
                  "display" : "電線裝修人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "742",
              "display" : "電子設備裝修人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7421",
                  "display" : "資訊及通訊設備裝修人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7429",
                  "display" : "其他電子設備裝修人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "79",
          "display" : "其他技藝有關工作人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "791",
              "display" : "食品製造及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7911",
                  "display" : "肉類、魚類屠宰及有關食品處理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7912",
                  "display" : "麵包、點心及糖果製造人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7913",
                  "display" : "乳製品製造人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7914",
                  "display" : "蔬果及有關保藏人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7915",
                  "display" : "食品、飲料試味及分級人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7919",
                  "display" : "其他食品製造及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "792",
              "display" : "木材處理、家具木工及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7921",
                  "display" : "木材乾燥及保存處理人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7922",
                  "display" : "家具木工及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7923",
                  "display" : "木工機器設定及操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "793",
              "display" : "成衣及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7931",
                  "display" : "裁縫、毛皮加工及製帽人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7932",
                  "display" : "服飾打樣及剪裁人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7933",
                  "display" : "縫紉、刺繡及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7934",
                  "display" : "鞣革、製革及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7935",
                  "display" : "製鞋及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "799",
              "display" : "未分類其他技藝有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7991",
                  "display" : "潛水人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7992",
                  "display" : "引爆及爆破人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7993",
                  "display" : "非食品飲料產品分級及檢查人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7994",
                  "display" : "消毒及除蟲有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7999",
                  "display" : "其他未分類技藝有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "8",
      "display" : "機械設備操作及組裝人員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2010-05-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "81",
          "display" : "生產機械設備操作人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "811",
              "display" : "採礦及礦物處理設備操作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8111",
                  "display" : "採礦及採石工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8112",
                  "display" : "礦石及石材處理設備操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8113",
                  "display" : "鑽井及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8114",
                  "display" : "水泥、石材及其他礦產品機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "812",
              "display" : "金屬製造及表面處理設備操作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8121",
                  "display" : "金屬製造設備操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8122",
                  "display" : "金屬表面處理機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "813",
              "display" : "化學及照相產品機械操作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8131",
                  "display" : "藥品及化粧品機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8132",
                  "display" : "照相產品機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8139",
                  "display" : "其他化學產品機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "814",
              "display" : "橡膠、塑膠及紙製品機械操作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8141",
                  "display" : "橡膠製品機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8142",
                  "display" : "塑膠製品機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8143",
                  "display" : "紙製品機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "815",
              "display" : "紡織品、毛皮及皮革製品機械操作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8151",
                  "display" : "纖維準備、紡紗、併紗及撚線機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8152",
                  "display" : "紡織及針織機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8153",
                  "display" : "縫製機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8154",
                  "display" : "漂染及整理機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8155",
                  "display" : "毛皮及皮革準備機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8156",
                  "display" : "製鞋及有關機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8157",
                  "display" : "洗衣店機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8159",
                  "display" : "其他紡織品、毛皮及皮革製品機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "816",
              "display" : "食品及有關產品機械操作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8160",
                  "display" : "食品及有關產品機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "817",
              "display" : "木材加工及造紙設備操作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8171",
                  "display" : "木材加工設備操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8172",
                  "display" : "紙漿及造紙設備操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "819",
              "display" : "其他生產機械設備操作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8191",
                  "display" : "玻璃及陶瓷生產設備操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8192",
                  "display" : "蒸汽引擎及鍋爐操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8193",
                  "display" : "包裝及有關機械操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8199",
                  "display" : "未分類其他生產機械設備操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "82",
          "display" : "組裝人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "820",
              "display" : "組裝人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8201",
                  "display" : "機械組裝人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8202",
                  "display" : "電力及電子設備組裝人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8209",
                  "display" : "其他組裝人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "83",
          "display" : "駕駛及移運設備操作人員",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "831",
              "display" : "軌道車輛駕駛及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8311",
                  "display" : "軌道車輛駕駛人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8312",
                  "display" : "軌道制動器、號誌及轉轍器操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "832",
              "display" : "機車、小客車及小貨車駕駛人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8321",
                  "display" : "機車駕駛人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8322",
                  "display" : "小客車及小貨車駕駛人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "833",
              "display" : "大客車及大貨車駕駛人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8331",
                  "display" : "大客車駕駛人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8332",
                  "display" : "大貨車駕駛人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "834",
              "display" : "移運設備操作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8341",
                  "display" : "農業及林業移運設備操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8342",
                  "display" : "推土機及有關設備操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8343",
                  "display" : "吊車、起重機及有關設備操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8349",
                  "display" : "其他移運設備操作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "835",
              "display" : "船舶艙面水手及有關工作人員",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8350",
                  "display" : "船舶艙面水手及有關工作人員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "9",
      "display" : "基層技術工及勞力工",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2010-05-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "91",
          "display" : "清潔工及幫工",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "911",
              "display" : "家庭及類似場所清潔工及幫工",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9111",
                  "display" : "家庭清潔工及幫工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9112",
                  "display" : "辦公室、旅館及類似場所清潔工及幫工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "919",
              "display" : "其他清潔工",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9191",
                  "display" : "車輛清潔工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9192",
                  "display" : "玻璃帷幕清潔工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9199",
                  "display" : "未分類其他清潔工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "92",
          "display" : "農、林、漁、牧業勞力工",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "920",
              "display" : "農、林、漁、牧業勞力工",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9201",
                  "display" : "農牧業勞力工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9202",
                  "display" : "林業勞力工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9203",
                  "display" : "漁業勞力工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "93",
          "display" : "採礦、營建、製造及運輸勞力工",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "931",
              "display" : "採礦及營建勞力工",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9311",
                  "display" : "採礦及採石勞力工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9312",
                  "display" : "營建勞力工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "932",
              "display" : "製造勞力工",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9320",
                  "display" : "製造勞力工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "933",
              "display" : "運輸及倉儲勞力工",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9330",
                  "display" : "運輸及倉儲勞力工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "94",
          "display" : "街頭服務工及非餐飲小販",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "940",
              "display" : "街頭服務工及非餐飲小販",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9401",
                  "display" : "街頭服務工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9402",
                  "display" : "街頭非餐飲小販",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "95",
          "display" : "廢棄物服務工及環境清掃工",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "950",
              "display" : "廢棄物服務工及環境清掃工",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9501",
                  "display" : "廢棄物收集工及回收資源分類工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9502",
                  "display" : "環境清掃工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "99",
          "display" : "其他基層技術工及勞力工",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "990",
              "display" : "其他基層技術工及勞力工",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9901",
                  "display" : "食品烹調助手",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9902",
                  "display" : "抄表員及自動販賣機收款員",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9909",
                  "display" : "未分類其他基層技術工及勞力工",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "0",
      "display" : "軍人",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2010-05-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "01",
          "display" : "軍人",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2010-05-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "010",
              "display" : "軍人",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2010-05-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "0100",
                  "display" : "軍人",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2010-05-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
