# 臺灣壽險公會傷害保險個人職業分類表 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣壽險公會傷害保險個人職業分類表 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/occupation-lia-roc-tw | *Version*:2023-06-01 |
| Active as of 2023-06-01 | *Computable Name*:TWLIAROCOccupation |
| **Copyright/Legal**: 中華民國人壽保險商業同業公會 | |

 
臺灣壽險公會傷害保險個人職業分類表，參照至[中華民國人壽保險商業同業公會](https://www.lia-roc.org.tw/)代碼出版日期：2023-06-01；資料所屬單位：中華民國人壽保險商業同業公會。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWLIAROCOccupation](ValueSet-occupation-lia-roc-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "occupation-lia-roc-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/occupation-lia-roc-tw",
  "version" : "2023-06-01",
  "name" : "TWLIAROCOccupation",
  "title" : "臺灣壽險公會傷害保險個人職業分類表",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-01",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣壽險公會傷害保險個人職業分類表，參照至[中華民國人壽保險商業同業公會](https://www.lia-roc.org.tw/)\n代碼出版日期：2023-06-01；資料所屬單位：中華民國人壽保險商業同業公會。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*",
  "copyright" : "中華民國人壽保險商業同業公會",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 1324,
  "property" : [
    {
      "code" : "OccupationClassification",
      "description" : "職業分類",
      "type" : "string"
    },
    {
      "code" : "OccupationBreakdown",
      "description" : "職業細分類",
      "type" : "string"
    },
    {
      "code" : "NatureOfWork",
      "description" : "工作性質",
      "type" : "string"
    },
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "00010010",
      "display" : "內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "00一般職業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0001  機關團體公司行號"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00010020",
      "display" : "外勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "00一般職業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0001  機關團體公司行號"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010010",
      "display" : "農場經營者（不親自作業）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010020",
      "display" : "農夫",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010030",
      "display" : "長短工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010040",
      "display" : "果農",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010050",
      "display" : "苗圃栽培人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010060",
      "display" : "花圃栽培人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010070",
      "display" : "飼養家禽家畜人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010080",
      "display" : "農業技師、指導員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010090",
      "display" : "農業機械之操作或修護人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010100",
      "display" : "農具商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010110",
      "display" : "農產品加工業實驗人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010111",
      "display" : "農產品加工業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010120",
      "display" : "茶農、製茶人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010130",
      "display" : "檳榔種植、採檳榔",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010140",
      "display" : "農會指導員、推廣員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010150",
      "display" : "養鴿、放鴿人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010160",
      "display" : "農產品加工業領班、工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010170",
      "display" : "昆蟲（蜜蜂）飼養人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010180",
      "display" : "病蟲害防治人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01010190",
      "display" : "科技農夫(不親自作業)、生物科技工程師、飼料研究員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0101 農業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01020010",
      "display" : "畜牧場經營者（不親自作業）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0102 牧業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01020020",
      "display" : "畜牧工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0102 牧業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01020040",
      "display" : "獸醫 (畜牧業、農業)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0102 牧業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01020050",
      "display" : "訓犬人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0102 牧業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01020060",
      "display" : "動物養殖人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0102 牧業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01020080",
      "display" : "屠宰場人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "01農牧業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0102 牧業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010010",
      "display" : "漁塭經營者（不親自作業）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010011",
      "display" : "漁塭經營者（親自作業）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010020",
      "display" : "養殖人員（內陸）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010021",
      "display" : "養殖人員（沿海）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010030",
      "display" : "水族館經營者",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010040",
      "display" : "捕魚人（內陸）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010041",
      "display" : "捕魚人（沿海）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010050",
      "display" : "水產實驗人員(室內)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010051",
      "display" : "水產實驗人員(室外)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010060",
      "display" : "海邊撈魚苗者",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010070",
      "display" : "漁產加工業實驗人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010071",
      "display" : "漁產加工業品管員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010080",
      "display" : "釣魚、釣蝦場經營者、工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010090",
      "display" : "漁產加工業領班、工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0201 內陸漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02020010",
      "display" : "遠洋漁船船員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0202 海上漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02020020",
      "display" : "近海漁船船員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0202 海上漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02020030",
      "display" : "海釣船人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "02漁業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0202 海上漁業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03010010",
      "display" : "領班",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0301 森林砍伐業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03010020",
      "display" : "監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0301 森林砍伐業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03010030",
      "display" : "伐木工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0301 森林砍伐業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03010040",
      "display" : "鋸木工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0301 森林砍伐業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03010050",
      "display" : "運材車輛之司機及押運人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0301 森林砍伐業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03010060",
      "display" : "起重機之操作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0301 森林砍伐業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03010070",
      "display" : "裝運工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0301 森林砍伐業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020010",
      "display" : "木材工廠現場之職員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020020",
      "display" : "領班",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020030",
      "display" : "分級員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020040",
      "display" : "檢查員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020050",
      "display" : "標記員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020060",
      "display" : "磅秤員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020070",
      "display" : "鋸木工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020080",
      "display" : "防腐劑工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020090",
      "display" : "木材儲藏槽工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020100",
      "display" : "木材搬運工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020110",
      "display" : "吊車操作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020120",
      "display" : "合板製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020130",
      "display" : "木材工廠負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03020140",
      "display" : "木材工廠品管員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0302 木材加工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03030010",
      "display" : "領班",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0303 造林業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03030020",
      "display" : "山地造林工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0303 造林業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03030030",
      "display" : "山林管理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0303 造林業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03030040",
      "display" : "森林防火人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0303 造林業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03030050",
      "display" : "平地育苗工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0303 造林業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03030060",
      "display" : "實驗室育苗栽培人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0303 造林業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03030070",
      "display" : "救難人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0303 造林業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03030080",
      "display" : "導覽解說員(室外)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0303 造林業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03030081",
      "display" : "導覽解說員(室內)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "03木材森林業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0303 造林業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04010010",
      "display" : "礦工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0401 坑道內作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04020010",
      "display" : "經營者（不到現場者）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0402 坑外作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04020020",
      "display" : "經營者（到現場者）、現場監督人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0402 坑外作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04020030",
      "display" : "經理人員、行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0402 坑外作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04020040",
      "display" : "礦業工程師、技師、領班",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0402 坑外作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04020050",
      "display" : "工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0402 坑外作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04020060",
      "display" : "工礦安全人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0402 坑外作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04030010",
      "display" : "所有作業人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0403 海上作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04030011",
      "display" : "潛水人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0403 海上作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04040010",
      "display" : "採石業工人(河床)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0404 採砂石業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04040011",
      "display" : "採石業工人(山地)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0404 採砂石業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04040020",
      "display" : "採砂業工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0404 採砂石業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04040030",
      "display" : "砂石場負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0404 採砂石業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04040040",
      "display" : "採石爆破人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0404 採砂石業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04040050",
      "display" : "石材切割工人(大理石、花崗石)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0404 採砂石業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04040060",
      "display" : "石材磨光工人(大理石、花崗石)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0404 採砂石業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04040070",
      "display" : "採石輸送帶機器操作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0404 採砂石業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04050010",
      "display" : "行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0405 陸上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04050020",
      "display" : "工程師、領班  (不參與現場工作者)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0405 陸上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04050030",
      "display" : "技術員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0405 陸上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04050040",
      "display" : "油氣井清潔保養修護工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0405 陸上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04050050",
      "display" : "鑽勘設備安裝換修保養工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0405 陸上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04050060",
      "display" : "鑽油井工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0405 陸上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04050070",
      "display" : "儲油槽清潔工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0405 陸上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04060010",
      "display" : "工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0406 海上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04060020",
      "display" : "技術員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0406 海上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04060030",
      "display" : "油氣井清潔保養修護工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0406 海上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04060040",
      "display" : "鑽勘設備安裝換修保養工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0406 海上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04060050",
      "display" : "鑽油井工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "04礦業採石業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0406 海上油礦開採業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010010",
      "display" : "計程車行、貨運行、貨櫃業之負責人（不參與駕駛者）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010020",
      "display" : "外務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010030",
      "display" : "內勤工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010040",
      "display" : "自用小客車司機",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010050",
      "display" : "自用大客車司機",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010060",
      "display" : "計程車司機、多元計程車司機(含UBER司機)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010070",
      "display" : "遊覽車司機及服務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010080",
      "display" : "客運車司機及服務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010090",
      "display" : "小型客貨兩用車司機",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010100",
      "display" : "自用貨車司機、隨車人員、小型自用貨車司機",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010110",
      "display" : "人力三輪車伕",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010120",
      "display" : "鐵牛車駕駛人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010130",
      "display" : "機動三輪車伕",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010140",
      "display" : "櫃檯售票員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010150",
      "display" : "客運車稽核人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010160",
      "display" : "營業用貨車司機",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010170",
      "display" : "營業用貨車隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010180",
      "display" : "搬運、搬家工人司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010190",
      "display" : "砂石車司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010200",
      "display" : "工程卡車司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010210",
      "display" : "液化、氣化、油罐車司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010220",
      "display" : "貨櫃車司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010230",
      "display" : "纜車操縱員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010240",
      "display" : "垃圾車(司機及隨車人員)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010250",
      "display" : "靈車司機、靈車隨車人員、靈柩搬運人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010260",
      "display" : "快遞司機 (貨車）、物流公司司機(貨車)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010261",
      "display" : "快遞司機(機車)、物流公司司機(機車)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010270",
      "display" : "拖吊車司機、隨車人員（一般道路）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010271",
      "display" : "拖吊車司機、隨車人員（高速公路）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010280",
      "display" : "堆高機駕駛（非航運）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010290",
      "display" : "貨櫃場管理員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010300",
      "display" : "娃娃車司機",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010310",
      "display" : "救護車司機、救護車隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010320",
      "display" : "消防車司機",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010330",
      "display" : "貨櫃場吊車駕駛",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010340",
      "display" : "拖板車司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010350",
      "display" : "混凝土預拌車司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010360",
      "display" : "拼裝車司機",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010370",
      "display" : "聯結車司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010380",
      "display" : "吊車司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010390",
      "display" : "曳引車司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010400",
      "display" : "教練車教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010410",
      "display" : "送外賣機車或自行車駕駛、外送平台外送員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010430",
      "display" : "環保資源回收車司機、隨車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010440",
      "display" : "道路工程車司機、機械操作員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010450",
      "display" : "挖土機(怪手)操作員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010460",
      "display" : "鏟土機駕駛",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010470",
      "display" : "遊覽車車上銷售員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010480",
      "display" : "代駕人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05010490",
      "display" : "復康巴士司機",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0501 陸運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020010",
      "display" : "站長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020020",
      "display" : "票房工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020030",
      "display" : "播音員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020040",
      "display" : "一般內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020050",
      "display" : "車站剪票員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020060",
      "display" : "服務臺人員、站務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020070",
      "display" : "月臺工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020080",
      "display" : "行李搬運人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020090",
      "display" : "車站清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020100",
      "display" : "隨車人員（技術人員除外）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020110",
      "display" : "駕駛員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020120",
      "display" : "燃料填充員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020130",
      "display" : "機工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020140",
      "display" : "電工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020150",
      "display" : "修護廠廠長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020160",
      "display" : "修護廠一般內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020170",
      "display" : "修護廠工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020180",
      "display" : "修護廠技工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020190",
      "display" : "修路工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020200",
      "display" : "維護工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020210",
      "display" : "平交道看守人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020220",
      "display" : "貨運：領班",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020230",
      "display" : "貨運：搬運人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020240",
      "display" : "巡查人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020250",
      "display" : "外務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05020260",
      "display" : "志工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0502  鐵路、捷運、高鐵"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030010",
      "display" : "船長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 客貨輪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030020",
      "display" : "輪機長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 客貨輪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030030",
      "display" : "大副",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "高級船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030040",
      "display" : "二副",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "高級船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030050",
      "display" : "三副",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "高級船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030060",
      "display" : "大管輪",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "高級船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030070",
      "display" : "二管輪",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "高級船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030080",
      "display" : "三管輪",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "高級船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030090",
      "display" : "報務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "高級船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030100",
      "display" : "事務長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "高級船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030110",
      "display" : "醫務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "高級船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030120",
      "display" : "水手長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "一般船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030130",
      "display" : "水手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "一般船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030140",
      "display" : "銅匠",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "一般船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030150",
      "display" : "木匠",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "一般船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030160",
      "display" : "泵匠",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "一般船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030170",
      "display" : "電機師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "一般船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030180",
      "display" : "廚師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "一般船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030190",
      "display" : "服務生",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "一般船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030200",
      "display" : "實習生",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "一般船員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030210",
      "display" : "遊覽船之駕駛及工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｂ 遊覽船及小汽艇"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030220",
      "display" : "小汽艇之駕駛及工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｂ 遊覽船及小汽艇"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030230",
      "display" : "碼頭工人及領班",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030240",
      "display" : "推高機操作員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030250",
      "display" : "倉庫管理人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030260",
      "display" : "領航員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030270",
      "display" : "引水人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030280",
      "display" : "關務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030290",
      "display" : "稽查人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030300",
      "display" : "緝私人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030310",
      "display" : "D 拖船駕駛員及工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030320",
      "display" : "渡輪駕駛員及工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030330",
      "display" : "E 救難船員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030340",
      "display" : "港口疏濬",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030350",
      "display" : "碼頭吊車操作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030360",
      "display" : "船艙清潔 (船舶靠岸後)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05030370",
      "display" : "內勤工作人員(陸地)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 港口作業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040010",
      "display" : "站長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040020",
      "display" : "播音員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040030",
      "display" : "服務臺人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040040",
      "display" : "一般內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040050",
      "display" : "塔臺工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040060",
      "display" : "關務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040070",
      "display" : "檢查人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040080",
      "display" : "運務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040090",
      "display" : "緝私人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040100",
      "display" : "站內清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040110",
      "display" : "機場內交通車司機、空橋車駕駛",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040120",
      "display" : "行李貨運搬運人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040130",
      "display" : "加添燃料員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040140",
      "display" : "飛機洗刷人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040150",
      "display" : "清潔人員（高牆或天花板）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040160",
      "display" : "跑道維護人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040170",
      "display" : "機械員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040180",
      "display" : "飛機修護人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040181",
      "display" : "地面導航人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ａ 航空站"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040190",
      "display" : "辦事處人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｂ 航空公司"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040200",
      "display" : "票務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｂ 航空公司"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040210",
      "display" : "機場櫃檯人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｂ 航空公司"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040220",
      "display" : "清艙員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｂ 航空公司"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040221",
      "display" : "櫃檯行李員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｂ 航空公司"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040230",
      "display" : "一般內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 航空貨運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040240",
      "display" : "外務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 航空貨運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040250",
      "display" : "報關人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 航空貨運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040260",
      "display" : "理貨員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｃ 航空貨運"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040270",
      "display" : "民航機飛行人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｄ 空勤人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040280",
      "display" : "機上服務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｄ 空勤人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040290",
      "display" : "直昇機飛行人員(含輕型航空器駕駛人員)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｄ 空勤人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040291",
      "display" : "民航機培訓人員(航空公司飛行訓練學員)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｄ 空勤人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040292",
      "display" : "民航機飛行空安官",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｄ 空勤人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040293",
      "display" : "民航機試飛員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｄ 空勤人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05040300",
      "display" : "無人機工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "05交通運輸業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0503 航運"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "Ｄ 空勤人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06010010",
      "display" : "一般內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0601 旅遊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06010020",
      "display" : "外務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0601 旅遊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06010030",
      "display" : "導遊、領隊",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0601 旅遊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06010040",
      "display" : "送機人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0601 旅遊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06010050",
      "display" : "機場接送人員、泊車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0601 旅遊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06010060",
      "display" : "登山嚮導",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0601 旅遊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06010070",
      "display" : "國內泛舟安全人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0601 旅遊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06010080",
      "display" : "導覽解說員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0601 旅遊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06010090",
      "display" : "旅行社負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0601 旅遊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020010",
      "display" : "旅館業負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020020",
      "display" : "一般內勤服務人員（辦公室職員、櫃檯、服務檯）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020030",
      "display" : "外務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020040",
      "display" : "收帳員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020050",
      "display" : "技工（註：餐飲部工作人員比照餐飲業）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020060",
      "display" : "搬運行李服務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020070",
      "display" : "客房服務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020080",
      "display" : "清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020090",
      "display" : "洗衣人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020100",
      "display" : "水電、機電工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020110",
      "display" : "飯店保全人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06020120",
      "display" : "泊車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0602 旅館業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030010",
      "display" : "負責人、經理人員、店長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030020",
      "display" : "一般內勤工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030030",
      "display" : "櫃檯人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030040",
      "display" : "收帳員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030050",
      "display" : "採購人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030060",
      "display" : "廚師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030070",
      "display" : "服務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030080",
      "display" : "洗碗人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030090",
      "display" : "清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030100",
      "display" : "調酒師、品酒師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030110",
      "display" : "外務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030120",
      "display" : "早餐店工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030130",
      "display" : "自助餐工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030140",
      "display" : "領檯帶位人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030150",
      "display" : "速食店工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030160",
      "display" : "小吃店人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030170",
      "display" : "外燴辦桌人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030180",
      "display" : "咖啡店人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030190",
      "display" : "泡沫茶店人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030200",
      "display" : "行動咖啡車工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030210",
      "display" : "飲食攤販",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030220",
      "display" : "美食評論家",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06030230",
      "display" : "冰雕人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "06餐旅業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0603 餐飲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010010",
      "display" : "建築師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010020",
      "display" : "製圖員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010030",
      "display" : "內勤工作人員、工地售屋人員(不包含引導參觀工地)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010040",
      "display" : "測量員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010050",
      "display" : "工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010060",
      "display" : "監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010070",
      "display" : "業務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010080",
      "display" : "引導參觀工地之服務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010090",
      "display" : "領班",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010100",
      "display" : "模板工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010110",
      "display" : "木匠",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010120",
      "display" : "泥水匠、混凝土混合機操作員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010140",
      "display" : "油漆工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010150",
      "display" : "水電工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010170",
      "display" : "鋼骨結構架設工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010180",
      "display" : "鷹架架設工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010190",
      "display" : "焊工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010200",
      "display" : "建築工程車輛駕駛員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010210",
      "display" : "建築工程車輛機械操作員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010220",
      "display" : "承包商（土木建築）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010230",
      "display" : "磨石工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010240",
      "display" : "洗石工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010250",
      "display" : "石棉瓦或浪板安裝工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010260",
      "display" : "鋁門窗裝修人員、鐵門窗裝修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010270",
      "display" : "排水工程人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010280",
      "display" : "防水工程人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010290",
      "display" : "防熱工程人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010300",
      "display" : "營造廠負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010310",
      "display" : "挑磚工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010320",
      "display" : "貼瓷磚（室內）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010321",
      "display" : "貼瓷磚（外牆）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010330",
      "display" : "帆布鐵架架設",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010340",
      "display" : "空調風管架設人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010350",
      "display" : "拆屋、遷屋人員、違建拆除大隊",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010360",
      "display" : "輕鋼架架設人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010370",
      "display" : "挖井工程人員（鑽井工人）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010380",
      "display" : "鐵屋架設、施工 (搭設鐵皮屋)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010390",
      "display" : "寺廟或教堂彩繪人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010400",
      "display" : "大樓玻璃帷幕安裝、空中吊車操作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010410",
      "display" : "雜工、臨時工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010420",
      "display" : "綁鐵工、鐵工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010430",
      "display" : "建築機具維修工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010440",
      "display" : "工地清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010450",
      "display" : "鐵塔架設人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010460",
      "display" : "搭設舞台人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010470",
      "display" : "圍牆鐵網搭建",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010480",
      "display" : "擋土牆施工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010490",
      "display" : "園藝造景人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010500",
      "display" : "工地福利社負責人及銷售人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010510",
      "display" : "邊坡工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010520",
      "display" : "燈塔技工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010530",
      "display" : "太陽能板安裝人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010540",
      "display" : "天車操作人員(機房)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010541",
      "display" : "天車操作人員(現場)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0701  建築公司\r\n土木工程"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020010",
      "display" : "工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020020",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020030",
      "display" : "山地舖設工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020031",
      "display" : "平地舖設工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020040",
      "display" : "維護工人、修路工人、舖柏油工人、馬路景觀工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020050",
      "display" : "電線架設及維護工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020060",
      "display" : "管道舖設及維護工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020070",
      "display" : "高速公路工程人員（含美化工程）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020080",
      "display" : "交通號誌裝設及標線人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020090",
      "display" : "公園、道路路燈裝修工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07020100",
      "display" : "高速公路工程監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0702 道路鋪設"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07030010",
      "display" : "工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0703 造修船業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07030020",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0703 造修船業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07030030",
      "display" : "工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0703 造修船業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07030040",
      "display" : "修護遊艇工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0703 造修船業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07030050",
      "display" : "船體切割人員(陸上)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0703 造修船業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07030060",
      "display" : "船體切割人員(海上)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0703 造修船業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07030070",
      "display" : "拆船工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0703 造修船業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07030080",
      "display" : "船舶驗收人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0703 造修船業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07030090",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0703 造修船業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07040010",
      "display" : "安裝工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0704 電梯昇降梯"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07040020",
      "display" : "修理及維護工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0704 電梯昇降梯"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07040030",
      "display" : "操作員(不包括礦場使用者)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0704 電梯昇降梯"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07050010",
      "display" : "設計製圖人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0705 裝潢業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07050020",
      "display" : "地毯之裝設人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0705 裝潢業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07050030",
      "display" : "室內裝潢人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0705 裝潢業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07050040",
      "display" : "室外裝潢人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0705 裝潢業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07050050",
      "display" : "承包商、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0705 裝潢業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07060010",
      "display" : "地質探測員（山區、海上）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0706 其他工程業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07060011",
      "display" : "地質探測員（平地）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0706 其他工程業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07060020",
      "display" : "工地看守員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0706 其他工程業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07060030",
      "display" : "海灣港口工程人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0706 其他工程業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07060040",
      "display" : "水壩工程人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0706 其他工程業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07060050",
      "display" : "橋樑工程人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0706 其他工程業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07060060",
      "display" : "隧道工程人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0706 其他工程業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07060070",
      "display" : "潛水工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0706 其他工程業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07060080",
      "display" : "爆破工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0706 其他工程業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07060090",
      "display" : "挖泥船工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "07建築工程業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0706 其他工程業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010010",
      "display" : "鋼鐵場技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010020",
      "display" : "鋼鐵場工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010030",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010040",
      "display" : "工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010050",
      "display" : "鋼鐵場負責人(不需到現場)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010060",
      "display" : "鋼鐵場負責人(需現場指導或實際參與工作)、廠長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010070",
      "display" : "鋼鐵場品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010080",
      "display" : "勞工安全檢查人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010090",
      "display" : "鋼鐵場製模工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010100",
      "display" : "鋼鐵場起重機操作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010110",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010120",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0801 鋼鐵場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020010",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020020",
      "display" : "板金工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020030",
      "display" : "裝配工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020040",
      "display" : "焊接工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020050",
      "display" : "車床工（全自動）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020051",
      "display" : "車床工（其他）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020060",
      "display" : "鑄造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020070",
      "display" : "鍋爐工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020080",
      "display" : "鉛字鑄造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020090",
      "display" : "鐵工廠工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020100",
      "display" : "機械廠工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020110",
      "display" : "電鍍工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020120",
      "display" : "銑床工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020121",
      "display" : "銑床工(全自動)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020130",
      "display" : "剪床工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020140",
      "display" : "沖床工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020150",
      "display" : "ＣＮＣ操作（電腦雕刻機）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020160",
      "display" : "線割（銅線電子切割）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020170",
      "display" : "鐵工廠、機械廠品管人員或工安人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020180",
      "display" : "技工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020190",
      "display" : "高爾夫球具製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020200",
      "display" : "高爾夫球桿頭磨光",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020210",
      "display" : "修理工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020220",
      "display" : "彎管工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020230",
      "display" : "熱處理",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020240",
      "display" : "大小五金製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020250",
      "display" : "風管製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020260",
      "display" : "鋁合金鑄造",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020270",
      "display" : "鐵櫃技工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020280",
      "display" : "貨櫃製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020290",
      "display" : "鉗工、丸鐵工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020300",
      "display" : "模具工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020310",
      "display" : "翻砂工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020320",
      "display" : "鐵捲工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020330",
      "display" : "鑽床工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020340",
      "display" : "泵浦裝配技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020350",
      "display" : "模具設計",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020360",
      "display" : "機械操作修理員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020370",
      "display" : "螺絲製造",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020380",
      "display" : "配電盤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020390",
      "display" : "油壓機操作",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020400",
      "display" : "磨床",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020410",
      "display" : "冷作",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020420",
      "display" : "鍛造",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020430",
      "display" : "鐵工廠、機械場負責人（不需到現場）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020431",
      "display" : "鐵工廠、機械場負責人（需現場指導或實際參與工作）、廠長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020440",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020450",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0802  鐵工廠\r\n機械廠"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030010",
      "display" : "電子業工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030020",
      "display" : "電子業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030030",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030040",
      "display" : "裝配人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030050",
      "display" : "修理工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030060",
      "display" : "包裝人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030070",
      "display" : "製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030080",
      "display" : "電子業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030090",
      "display" : "無塵室工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030100",
      "display" : "操作自動ＩＣ人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030110",
      "display" : "物料倉管",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030120",
      "display" : "ＩＣ板電鍍",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030130",
      "display" : "電子業負責人（不需到現場）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030140",
      "display" : "電子業負責人（需現場指導或實際參與工作）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030150",
      "display" : "光電及光學工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030160",
      "display" : "電氣焊接工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030170",
      "display" : "研發人員、設計人員、製程人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030180",
      "display" : "電路板維修工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030190",
      "display" : "機器人工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030200",
      "display" : "半導體製品機械設備操作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030210",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030220",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030230",
      "display" : "電子業軟體工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0803 電子業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040010",
      "display" : "電機業工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040020",
      "display" : "電機業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040030",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040040",
      "display" : "空氣調節器之裝修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040050",
      "display" : "有關高壓電之工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040060",
      "display" : "冷凍修理工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040070",
      "display" : "電機業負責人（不需到現場）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040080",
      "display" : "電機業負責人（需現場指導或實際參與工作）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040090",
      "display" : "電機業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040100",
      "display" : "家電用品維修",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040110",
      "display" : "室內消防器材裝修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040120",
      "display" : "電機裝配修理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040130",
      "display" : "室內消防器材檢測(不含安裝)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040140",
      "display" : "變壓器裝置維修",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040150",
      "display" : "烤漆",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040160",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040170",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040180",
      "display" : "電機業軟體工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0804 電機業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050010",
      "display" : "塑膠、橡膠業工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050020",
      "display" : "塑膠、橡膠業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050030",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050040",
      "display" : "一般工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050050",
      "display" : "塑膠、橡膠射出成型工人（自動）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050060",
      "display" : "塑膠、橡膠射出成型工人（其他）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050070",
      "display" : "塑膠、橡膠業負責人（不需到現場）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050080",
      "display" : "塑膠、橡膠業負責人（需現場指導或實際參與工作）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050090",
      "display" : "塑膠、橡膠業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050100",
      "display" : "塑膠袋製造、印刷",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050110",
      "display" : "高週波充氣玩具製造",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050120",
      "display" : "鞋模製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050130",
      "display" : "高爾夫球、乒乓球製造",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050140",
      "display" : "塑膠、橡膠射出機器維修",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050150",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050160",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0805 塑膠\r\n橡膠業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08060010",
      "display" : "水泥業工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0806 水泥業\r\n（包括水泥、石膏、石灰）"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08060020",
      "display" : "水泥業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0806 水泥業\r\n（包括水泥、石膏、石灰）"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08060030",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0806 水泥業\r\n（包括水泥、石膏、石灰）"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08060040",
      "display" : "工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0806 水泥業\r\n（包括水泥、石膏、石灰）"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08060050",
      "display" : "採掘工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0806 水泥業\r\n（包括水泥、石膏、石灰）"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08060060",
      "display" : "爆破工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0806 水泥業\r\n（包括水泥、石膏、石灰）"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08060070",
      "display" : "工安人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0806 水泥業\r\n（包括水泥、石膏、石灰）"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08060080",
      "display" : "水泥業負責人（不需到現場）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0806 水泥業\r\n（包括水泥、石膏、石灰）"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08060081",
      "display" : "水泥業負責人（需現場指導或實際參與工作）、廠長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0806 水泥業\r\n（包括水泥、石膏、石灰）"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070010",
      "display" : "化學原料業工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070020",
      "display" : "化學原料業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070030",
      "display" : "一般工人、作業員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070040",
      "display" : "硫酸、鹽酸、硝酸製造工、有毒物品製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070050",
      "display" : "電池製造（技師）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070051",
      "display" : "電池製造（工人）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070060",
      "display" : "液化氣體製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070090",
      "display" : "化學品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070100",
      "display" : "化學實驗師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070110",
      "display" : "殺蟲劑製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070120",
      "display" : "油漆製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070130",
      "display" : "海綿、泡綿製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070140",
      "display" : "廠區行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070150",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070160",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070170",
      "display" : "調香師(香氛類)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070180",
      "display" : "藥品研發人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0807 化學原料業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08080010",
      "display" : "火藥爆竹製造及處理人員（包括爆竹、煙火製造工）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0808 炸藥業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08080020",
      "display" : "廠務管理、廠長",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0808 炸藥業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090010",
      "display" : "汽機車、自行車製造及修理業工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090020",
      "display" : "汽機車、自行車製造及修理業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090030",
      "display" : "製造工人（汽、機車）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090040",
      "display" : "製造工人（自行車）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090050",
      "display" : "修理保養工人（汽、機車）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090060",
      "display" : "修理保養工人（自行車）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090070",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090080",
      "display" : "試車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090090",
      "display" : "汽機車、自行車製造及修理業負責人（不需到現場）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090100",
      "display" : "汽機車、自行車製造及修理業負責人（需現場指導或實際參與工作）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090110",
      "display" : "汽機車、自行車製造及修理業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090120",
      "display" : "鈑金工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090130",
      "display" : "汽車輪胎換修買賣、定位",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090131",
      "display" : "汽車美容裝潢人員(包含改車)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090140",
      "display" : "汽車修理廠引導員(不參與修理)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090150",
      "display" : "汽車檢驗員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090160",
      "display" : "瓦斯車安裝人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090170",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090180",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0809\r\n汽車、機車、自行車製造業\r\n修理業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100010",
      "display" : "紡織及成衣業工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100020",
      "display" : "設計師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100030",
      "display" : "紡織及成衣業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100040",
      "display" : "製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100050",
      "display" : "染整工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100060",
      "display" : "紡織及成衣業負責人（不需到現場）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100070",
      "display" : "打版師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100080",
      "display" : "紡織及成衣業負責人（需現場指導或實際參與工作）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100090",
      "display" : "針織工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100100",
      "display" : "紡織及成衣業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100110",
      "display" : "成衣（毛衣、針織）代工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100120",
      "display" : "機械維修",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100130",
      "display" : "紡紗工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0810 紡織及成衣業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08110010",
      "display" : "造紙工業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0811 造紙工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08110020",
      "display" : "監工、領班",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0811 造紙工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08110030",
      "display" : "造紙廠工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0811 造紙工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08110040",
      "display" : "紙漿廠工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0811 造紙工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08110050",
      "display" : "紙箱製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0811 造紙工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08110060",
      "display" : "紙箱包裝人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0811 造紙工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08110070",
      "display" : "紙盒黏貼人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0811 造紙工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08110080",
      "display" : "造紙工業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0811 造紙工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08110090",
      "display" : "裁紙工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0811 造紙工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120010",
      "display" : "傢俱製造業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120020",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120030",
      "display" : "木製傢俱製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120040",
      "display" : "木製傢俱修理工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120050",
      "display" : "金屬傢俱製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120060",
      "display" : "金屬傢俱修理工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120070",
      "display" : "設計師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120080",
      "display" : "傢俱製造業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120090",
      "display" : "傢俱油漆工（噴漆、烤漆）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120100",
      "display" : "傢俱運送、組裝工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120110",
      "display" : "石材傢俱製造、修理工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120120",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120130",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0812 傢俱製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08130010",
      "display" : "竹木製手工藝品之加工人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0813 手工藝品業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08130020",
      "display" : "竹木製手工藝品之雕刻工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0813 手工藝品業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08130030",
      "display" : "金屬手工藝品之加工人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0813 手工藝品業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08130040",
      "display" : "金屬手工藝品之雕刻工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0813 手工藝品業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08130050",
      "display" : "布類紙品工藝品之加工人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0813 手工藝品業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08130060",
      "display" : "礦石手工藝品加工人員、玻璃手工藝品製造人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0813 手工藝品業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08130070",
      "display" : "珠寶加工人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0813 手工藝品業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08130080",
      "display" : "皮革手工藝品加工人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0813 手工藝品業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08130090",
      "display" : "陶瓷廠工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0813 手工藝品業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08140010",
      "display" : "電線電纜業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0814 電線電纜業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08140020",
      "display" : "電線電纜業工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0814 電線電纜業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150010",
      "display" : "冰塊製造",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150020",
      "display" : "食品及飲料製造業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150030",
      "display" : "製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150040",
      "display" : "碾米廠操作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150050",
      "display" : "麵包師父",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150060",
      "display" : "製麵人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150070",
      "display" : "食品飲料製造業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150080",
      "display" : "食品加工人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150090",
      "display" : "包裝人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150100",
      "display" : "煙、酒製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150110",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150120",
      "display" : "酒廠化驗人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150130",
      "display" : "煙酒廠機械操作",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150140",
      "display" : "煙酒廠機械維修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150150",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150160",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08150170",
      "display" : "食品檢驗人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0815 食品飲料製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160010",
      "display" : "家電製造業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160020",
      "display" : "一般製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160030",
      "display" : "裝配工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160040",
      "display" : "包裝人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160050",
      "display" : "焊接工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160060",
      "display" : "沖床工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160070",
      "display" : "剪床工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160080",
      "display" : "銑床工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160081",
      "display" : "銑床工(全自動)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160090",
      "display" : "鑄造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160100",
      "display" : "車床工（全自動）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160110",
      "display" : "車床工（其他）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160120",
      "display" : "家電製造業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160130",
      "display" : "家電維修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160140",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08160150",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0816 家電製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08170010",
      "display" : "玻璃及琉璃製造業品管人員   、工安人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0817 玻璃及琉璃製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08170020",
      "display" : "玻璃及琉璃製造業技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0817 玻璃及琉璃製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08170030",
      "display" : "領班、監工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0817 玻璃及琉璃製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08170040",
      "display" : "玻璃、琉璃製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0817 玻璃及琉璃製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08170050",
      "display" : "眼鏡鏡片染色人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0817 玻璃及琉璃製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08180010",
      "display" : "皮革製品製造業技師、品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0818 皮革製品製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08180020",
      "display" : "皮革製品製造業製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0818 皮革製品製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190010",
      "display" : "倉管人員（不搬貨）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190011",
      "display" : "倉管人員（搬貨）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190020",
      "display" : "樂器安裝組合維修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190030",
      "display" : "中藥材加工人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190040",
      "display" : "鑰匙加工人員、刻印加工人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190050",
      "display" : "化妝品製造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190060",
      "display" : "木炭製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190070",
      "display" : "木雕師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190080",
      "display" : "香燭製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190090",
      "display" : "醫療器材裝修工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190100",
      "display" : "工廠機器維修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08190110",
      "display" : "各式球類製造(不包含高爾夫球、乒乓球製造)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0819 其他製造業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08200010",
      "display" : "製藥廠工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0820生技醫療業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08200020",
      "display" : "製藥廠品管員、技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0820生技醫療業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08200030",
      "display" : "實驗室研究人員、研發人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0820生技醫療業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08200040",
      "display" : "生產製造人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0820生技醫療業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08200050",
      "display" : "生技醫療業品管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "08製造業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0820生技醫療業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010010",
      "display" : "內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010020",
      "display" : "外勤記者",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010030",
      "display" : "攝影記者",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010040",
      "display" : "戰地記者",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010050",
      "display" : "推銷員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010060",
      "display" : "排版、製版人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010061",
      "display" : "電腦排版人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010070",
      "display" : "裝訂人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010080",
      "display" : "印刷機械操作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010090",
      "display" : "送貨員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010100",
      "display" : "送報員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010110",
      "display" : "裁紙工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0901\r\n新聞業雜誌業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09020010",
      "display" : "一般內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0902 廣告業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09020020",
      "display" : "業務員、AE公關",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0902 廣告業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09020030",
      "display" : "廣告影片之拍攝錄製人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0902 廣告業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09020040",
      "display" : "戶外廣告招牌製作架設人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0902 廣告業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09020050",
      "display" : "廣告招牌繪製人員（地面工作）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0902 廣告業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09020060",
      "display" : "廣告旗幟製作",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0902 廣告業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09020070",
      "display" : "獎牌紀念品製作",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0902 廣告業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09020080",
      "display" : "道路號誌、標誌製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0902 廣告業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09020090",
      "display" : "廣告宣傳單發送人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "09新聞 廣告業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "0902 廣告業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010010",
      "display" : "一般醫務行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010020",
      "display" : "一般醫師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010021",
      "display" : "一般護理人員(護士、護理師)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010022",
      "display" : "一般藥劑師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010030",
      "display" : "精神病科醫師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010031",
      "display" : "精神病科護理人員(護士、護理師)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010032",
      "display" : "精神病科看護",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010040",
      "display" : "獸醫",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010050",
      "display" : "醫院炊事",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010060",
      "display" : "雜工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010070",
      "display" : "清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010080",
      "display" : "一般看護人員、基層照服員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010090",
      "display" : "物理、職能(復健)治療師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010100",
      "display" : "呼吸治療師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010110",
      "display" : "醫院傳送員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010120",
      "display" : "病房助理員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010130",
      "display" : "心理專業人員(含諮商人員)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010140",
      "display" : "營養師、健康管理顧問",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010150",
      "display" : "醫院志工、社工(不須外出訪視)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010160",
      "display" : "醫院志工、社工(須外出訪視)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1001 醫院"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020010",
      "display" : "醫學及病理檢驗人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020020",
      "display" : "分析員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020030",
      "display" : "放射線之技術人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020040",
      "display" : "放射線之修護人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020050",
      "display" : "助產士",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020060",
      "display" : "跌打損傷治療人員(接骨、氣功推拿)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020070",
      "display" : "監獄、看守所醫生、護理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020080",
      "display" : "做月子、育嬰中心工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020090",
      "display" : "中途之家、安養院工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020100",
      "display" : "齒模工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020110",
      "display" : "勞、健保局調查人員（外勤）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020120",
      "display" : "煙毒勒戒所人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020130",
      "display" : "法醫",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020140",
      "display" : "長照管理師、照護系統整合管理師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020150",
      "display" : "長照中心、安養中心護理人員(護士、護理師)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020160",
      "display" : "長照中心、安養中心行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020170",
      "display" : "長照中心、安養中心照護人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020180",
      "display" : "生理訊號工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020190",
      "display" : "居家看護(長照看護)、居家照服人員、居家月子嫂",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10020200",
      "display" : "泌乳師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "10衛生 保健業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1002 保健人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010010",
      "display" : "製片人、一般內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010020",
      "display" : "影片商、系統商、頻道商(負責人)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010021",
      "display" : "影片商、系統商、頻道商(一般員工)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010030",
      "display" : "編劇、電視導播",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010040",
      "display" : "一般演員（導演）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010041",
      "display" : "網紅(含Youtuber)、網路直播人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010050",
      "display" : "武打演員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010060",
      "display" : "特技演員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010070",
      "display" : "化粧師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010080",
      "display" : "場記",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010090",
      "display" : "攝影工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010100",
      "display" : "燈光及音響效果工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010110",
      "display" : "沖片工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010120",
      "display" : "洗片工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010130",
      "display" : "電視記者",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010140",
      "display" : "機械工、電工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010150",
      "display" : "佈景搭設人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010160",
      "display" : "電影院售票員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010170",
      "display" : "電影院放映人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010180",
      "display" : "電影院服務人員兼餐飲販賣",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010190",
      "display" : "影片剪接人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010200",
      "display" : "播音、錄音、配音人員(在錄音室內)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010210",
      "display" : "燈光及音響器材架設人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010220",
      "display" : "現場指導、助理導播",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010230",
      "display" : "採訪車、轉播車駕駛",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010240",
      "display" : "武術指導",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010250",
      "display" : "有線電視架式人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010260",
      "display" : "電影院清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010270",
      "display" : "電影、電視公司外務員(不從事現場作業)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010280",
      "display" : "電視購物主持人、數位購物導覽員、網拍人員、代購人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1101  電影業\r\n電視業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11020010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1102\r\n高爾夫球場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11020020",
      "display" : "球場保養人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1102\r\n高爾夫球場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11020030",
      "display" : "高爾夫球場維護工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1102\r\n高爾夫球場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11020040",
      "display" : "球僮",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1102\r\n高爾夫球場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11030010",
      "display" : "計分員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1103 保齡球館"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11030020",
      "display" : "櫃檯人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1103 保齡球館"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11030030",
      "display" : "機械修護工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1103 保齡球館"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11030040",
      "display" : "清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1103 保齡球館"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11030050",
      "display" : "保齡球館負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1103 保齡球館"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11040010",
      "display" : "撞球場負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1104 撞球場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11040020",
      "display" : "計分員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1104 撞球場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11040030",
      "display" : "撞球場維護工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1104 撞球場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11040040",
      "display" : "撞球場櫃檯人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1104 撞球場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11040050",
      "display" : "撞球場清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1104 撞球場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11050010",
      "display" : "游泳池負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1105 游泳池"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11050020",
      "display" : "管理員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1105 游泳池"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11050030",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1105 游泳池"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11050040",
      "display" : "售票員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1105 游泳池"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11050050",
      "display" : "救生員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1105 游泳池"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11050060",
      "display" : "游泳池維護工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1105 游泳池"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11050070",
      "display" : "游泳池清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1105 游泳池"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11060010",
      "display" : "海水浴場負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1106 海水浴場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11060020",
      "display" : "管理員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1106 海水浴場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11060030",
      "display" : "售票員、售貨員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1106 海水浴場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11060040",
      "display" : "救生員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1106 海水浴場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11060050",
      "display" : "海水浴場維護工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1106 海水浴場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11060060",
      "display" : "海水浴場清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1106 海水浴場"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070010",
      "display" : "其他遊樂園(包括動物園)負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070020",
      "display" : "售票員、售貨員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070030",
      "display" : "電動玩具操作員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070040",
      "display" : "一般清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070050",
      "display" : "獸欄清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070060",
      "display" : "水電機械工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070070",
      "display" : "動物園、馬戲團馴獸師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070080",
      "display" : "飼養人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070090",
      "display" : "獸醫（動物園）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070100",
      "display" : "動物訓練員(非馴獸師)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070110",
      "display" : "娛樂場所工作人員及負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070120",
      "display" : "電動玩具店器具維修工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070130",
      "display" : "大型遊樂場器具維修工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070140",
      "display" : "電動遊戲店或網咖之負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11070150",
      "display" : "觀光地區志工、導覽人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1107\r\n其他遊樂園\r\n(包括動物園)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080010",
      "display" : "作曲人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080020",
      "display" : "編曲人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080030",
      "display" : "演奏人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080040",
      "display" : "繪畫人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080050",
      "display" : "歌唱、舞蹈演藝人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080060",
      "display" : "雕塑人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080070",
      "display" : "戲劇演員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080080",
      "display" : "巡迴演出戲劇團體人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080090",
      "display" : "作家",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080100",
      "display" : "模特兒",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080110",
      "display" : "魔術師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080120",
      "display" : "魔術助理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080130",
      "display" : "演藝經紀人、網紅(含youtuber)經紀人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080140",
      "display" : "宣傳",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080150",
      "display" : "布袋戲偶操作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080160",
      "display" : "人體彩繪師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080170",
      "display" : "舞蹈教室老師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080180",
      "display" : "樂器教學老師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080190",
      "display" : "podcaster播客",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080200",
      "display" : "街頭藝人(特技雜耍類)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11080201",
      "display" : "街頭藝人(非特技雜耍類)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1108\r\n藝術及演藝人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090010",
      "display" : "咖啡廳工作人員(特種營業)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090020",
      "display" : "茶室工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090030",
      "display" : "酒家工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090040",
      "display" : "樂戶工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090050",
      "display" : "舞廳工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090060",
      "display" : "歌廳工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090070",
      "display" : "酒吧工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090080",
      "display" : "特種營業負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090090",
      "display" : "其他場所工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090100",
      "display" : "從事特種營業服務人員(吧女、酒女、舞女、咖啡女郎、按摩女郎…等)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090110",
      "display" : "保鑣",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11090120",
      "display" : "賭場工作人員(荷官)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1109 特種營業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11100010",
      "display" : "線上遊戲業負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1110 線上遊戲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11100020",
      "display" : "線上遊戲業資訊工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1110 線上遊戲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11100030",
      "display" : "遊戲數值企劃師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1110 線上遊戲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11100040",
      "display" : "線上遊戲業行政工作人員(於辦公室內且完全不參與勞務者)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1110 線上遊戲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11100050",
      "display" : "線上遊戲業外勤業務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1110 線上遊戲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11100060",
      "display" : "電競人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1110 線上遊戲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11100070",
      "display" : "電競教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "11娛樂業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1110 線上遊戲業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010010",
      "display" : "教師、行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010020",
      "display" : "學生(不含軍校、警校)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010030",
      "display" : "校工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010040",
      "display" : "軍訓教官",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010050",
      "display" : "體育教師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010060",
      "display" : "健身房、有氧運動教練、體適能培訓師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010070",
      "display" : "餐飲補習班教師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010080",
      "display" : "工藝教師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010090",
      "display" : "校警",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010100",
      "display" : "學校志工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010110",
      "display" : "線上(互動)教師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010120",
      "display" : "基金會行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1201 教育機構"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020010",
      "display" : "負責人（出版商、書店、文具店）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020020",
      "display" : "店員（出版商、書店、文具店）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020030",
      "display" : "書店外務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020040",
      "display" : "書店送貨員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020050",
      "display" : "圖書館工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020060",
      "display" : "博物館工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020070",
      "display" : "汽車駕駛訓練班教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020080",
      "display" : "監理所路考官",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020090",
      "display" : "職業棋士",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020100",
      "display" : "財團法人、社團法人文教團體之董/監事、總經理",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020110",
      "display" : "翻譯人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "12文教機關"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1202 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13000010",
      "display" : "寺廟及教堂管理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "13宗教團體"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1300 宗教人士"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13000020",
      "display" : "宗教團體工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "13宗教團體"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1300 宗教人士"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13000030",
      "display" : "僧尼、道士、法師及傳教人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "13宗教團體"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1300 宗教人士"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13000040",
      "display" : "乩童",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "13宗教團體"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1300 宗教人士"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13000050",
      "display" : "神壇工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "13宗教團體"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1300 宗教人士"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13000060",
      "display" : "算命師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "13宗教團體"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1300 宗教人士"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13000070",
      "display" : "勘與師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "13宗教團體"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1300 宗教人士"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13000080",
      "display" : "八家將",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "13宗教團體"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1300 宗教人士"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13000090",
      "display" : "財團法人、社團法人宗教團體之董/監事、總經理",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "13宗教團體"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1300 宗教人士"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14010010",
      "display" : "內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1401 郵政"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14010020",
      "display" : "外勤郵務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1401 郵政"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14010030",
      "display" : "包裹搬運人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1401 郵政"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020010",
      "display" : "內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020020",
      "display" : "抄錶員、收費員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020030",
      "display" : "電信裝置維護修理工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020031",
      "display" : "電力裝置維護修理工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020040",
      "display" : "電信工程設施之架設人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020041",
      "display" : "電力工程設施之架設人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020050",
      "display" : "電力高壓電工程設施人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020060",
      "display" : "電臺天線維護人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020080",
      "display" : "核能電廠行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020081",
      "display" : "核電廠工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020090",
      "display" : "電信及電力設計工程師（含現場監工）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020100",
      "display" : "水力、火力發電廠工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020110",
      "display" : "核廢料處理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020120",
      "display" : "核能工作人員（核工系、中研院、中科院、台電核工人員）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1402 電信及電力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14030010",
      "display" : "自來水水利工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1403\r\n自來水水利"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14030020",
      "display" : "水壩、水庫管理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1403\r\n自來水水利"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14030030",
      "display" : "水利工程設施人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1403\r\n自來水水利"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14030040",
      "display" : "自來水管裝修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1403\r\n自來水水利"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14030050",
      "display" : "抄錶員、收費員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1403\r\n自來水水利"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14030060",
      "display" : "自來水廠水質分析員（實地）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1403\r\n自來水水利"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14030070",
      "display" : "巡水員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1403\r\n自來水水利"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14040010",
      "display" : "瓦斯業工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1404 瓦斯"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14040020",
      "display" : "管線裝修工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1404 瓦斯"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14040030",
      "display" : "收費員、抄錶員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1404 瓦斯"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14040040",
      "display" : "檢查員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1404 瓦斯"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14040050",
      "display" : "瓦斯器具製造工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1404 瓦斯"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050010",
      "display" : "探測員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050020",
      "display" : "環境保護技師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050030",
      "display" : "一般工廠環保人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050040",
      "display" : "道路清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050050",
      "display" : "環保稽核巡查人員、垃圾車駕駛及清潔隊員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050060",
      "display" : "捕狗大隊",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050070",
      "display" : "化學工程環保人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050080",
      "display" : "下水道清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050090",
      "display" : "儲油槽、儲氣槽清理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050100",
      "display" : "海上油污處理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050110",
      "display" : "資源回收站分類人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050120",
      "display" : "環境噴灑人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050130",
      "display" : "工廠廢棄物清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050140",
      "display" : "污水處理(化糞池/水塔清潔人員)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050150",
      "display" : "垃圾焚化爐處理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050160",
      "display" : "廢五金處理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050170",
      "display" : "環境衛生管理師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050180",
      "display" : "廢土場負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1405 環境保護"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14060010",
      "display" : "廠區行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1406 石化工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14060020",
      "display" : "煉油廠工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1406 石化工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14060030",
      "display" : "煉油廠領班",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1406 石化工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14060040",
      "display" : "煉油廠技術工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1406 石化工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14060050",
      "display" : "煉油廠加油工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1406 石化工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14060060",
      "display" : "煉油廠管線維修",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1406 石化工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14060070",
      "display" : "加油站管線維修",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1406 石化工業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14070010",
      "display" : "風塔維修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1407風力發電產業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14070020",
      "display" : "離岸風塔維修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1407風力發電產業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14070030",
      "display" : "風塔維修訓練人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1407風力發電產業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14070040",
      "display" : "風力發電廠工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1407風力發電產業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14070050",
      "display" : "風力發電廠架設人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1407風力發電產業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14070060",
      "display" : "風電發電廠設計工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "14公共事業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1407風力發電產業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000010",
      "display" : "廚具商(不含安裝)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000020",
      "display" : "陶瓷器商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000030",
      "display" : "古董商（負責人）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000031",
      "display" : "古董商(行)一般員工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000040",
      "display" : "花卉商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000050",
      "display" : "米商(不參與碾米作業)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000060",
      "display" : "雜貨商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000070",
      "display" : "玻璃商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000080",
      "display" : "果菜商(固定攤販)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000090",
      "display" : "石材商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000100",
      "display" : "建材商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000110",
      "display" : "鐵材商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000120",
      "display" : "木材商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000130",
      "display" : "五金商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000140",
      "display" : "電器商(不含安裝)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000150",
      "display" : "水電衛生器材商(不含安裝)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000160",
      "display" : "傢俱、寢具商(不含安裝)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000170",
      "display" : "自行車買賣商(不含修理)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000180",
      "display" : "機車買賣商(不含修理)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000190",
      "display" : "汽車買賣商(不含修理)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000200",
      "display" : "車輛器材、用品買賣商（不含礦物油）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000210",
      "display" : "礦物油買賣商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000220",
      "display" : "眼鏡商、驗光師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000230",
      "display" : "食品飲料商、茶葉商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000240",
      "display" : "文具商、禮品買賣商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000250",
      "display" : "布商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000260",
      "display" : "服飾、皮鞋、皮件買賣商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000270",
      "display" : "魚販(含流動、固定攤販)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000280",
      "display" : "肉販(含流動、固定攤販)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000290",
      "display" : "藥品買賣商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000300",
      "display" : "化學原料商、肥料買賣商、農藥買賣商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000310",
      "display" : "醫療機械儀器商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000320",
      "display" : "手工藝品買賣商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000330",
      "display" : "瓦斯器具商負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "瓦斯器具商"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000340",
      "display" : "瓦斯器具商店員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "瓦斯器具商"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000350",
      "display" : "瓦斯器具商送貨員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "瓦斯器具商"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000360",
      "display" : "瓦斯器具商裝設工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "瓦斯器具商"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000370",
      "display" : "液化瓦斯零售商負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "液化瓦斯零售商"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000380",
      "display" : "液化瓦斯零售商店員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "液化瓦斯零售商"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000390",
      "display" : "液化瓦斯零售商送貨員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "液化瓦斯零售商"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000400",
      "display" : "液化瓦斯零售商瓦斯分裝工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "NatureOfWork",
          "valueString" : "液化瓦斯零售商"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000410",
      "display" : "舊貨收購人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000420",
      "display" : "超市、便利商店店員、藥妝店服務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000421",
      "display" : "大型超市量販店買賣/理貨人員(需操作堆高機等機械)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000430",
      "display" : "銀樓商(負責人)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000431",
      "display" : "銀樓一般員工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000440",
      "display" : "珠寶買賣(不參與加工作業)、珠寶公司內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000441",
      "display" : "珠寶商(負責人)、珠寶公司負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000450",
      "display" : "當鋪商(負責人)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000451",
      "display" : "當鋪一般內勤員工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000452",
      "display" : "當鋪外勤業務",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000460",
      "display" : "香燭、紙錢、爆竹買賣",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000470",
      "display" : "檳榔商(負責人)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000471",
      "display" : "檳榔商(攤)一般員工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000480",
      "display" : "一般流動、固定攤販",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000490",
      "display" : "廢五金買賣商(不負責處理)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000500",
      "display" : "碾米商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000510",
      "display" : "軍火商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000520",
      "display" : "鐘錶商(負責人)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000521",
      "display" : "鐘錶商(行)一般員工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000530",
      "display" : "彩券販售(有店面)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000531",
      "display" : "彩券販售(無店面)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000540",
      "display" : "藝術品拍賣業負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000550",
      "display" : "藝術品拍賣業行政工作人員(於辦公室內且完全不參與勞務者)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000560",
      "display" : "藝術品拍賣外勤業務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000570",
      "display" : "虛擬資產業負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000580",
      "display" : "虛擬資產業行政工作人員(於辦公室內且完全不參與勞務者)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000590",
      "display" : "虛擬資產業外勤業務人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000600",
      "display" : "百貨公司工作人員(櫃檯人員、服務台、樓管、行政人員、專櫃人員)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000610",
      "display" : "夾娃娃機台主",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15000620",
      "display" : "石化燃料貿易商負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "15一般商業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1500 買賣"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010010",
      "display" : "一般內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010020",
      "display" : "外務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010030",
      "display" : "收費員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010040",
      "display" : "調查徵信人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010050",
      "display" : "現金運送員、司機",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010060",
      "display" : "金融機構（銀行、合作社）駐衛警",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010070",
      "display" : "銀行、保險、信託、租賃業公司負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010080",
      "display" : "顧問服務業公司負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010090",
      "display" : "金融業電話行銷人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010100",
      "display" : "證券、投資、信託公司內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010110",
      "display" : "票券公司內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010120",
      "display" : "票券公司業務外勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010130",
      "display" : "理財、管理顧問公司內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010140",
      "display" : "理財、管理顧問公司業務外勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1601 銀行、保險、信託、租貸"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020010",
      "display" : "律師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020020",
      "display" : "會計師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020030",
      "display" : "代書（內勤）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020040",
      "display" : "經紀人（內勤）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020050",
      "display" : "外勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020060",
      "display" : "房屋土地仲介",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020070",
      "display" : "記帳士、記帳及報稅代理人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020080",
      "display" : "專業投資人、理財顧問、投資公司負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020090",
      "display" : "人力仲介",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020100",
      "display" : "房屋仲介公司行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020110",
      "display" : "預售屋房屋代銷人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020120",
      "display" : "遺物清理師、家庭收納師、雜物整理師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020130",
      "display" : "新娘秘書",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16020140",
      "display" : "美甲師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1602 自由業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030010",
      "display" : "公證行外務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030011",
      "display" : "公證人(內勤)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030012",
      "display" : "公證人(外勤)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030020",
      "display" : "報關行外務員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030030",
      "display" : "理髮師、造型師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030040",
      "display" : "美容師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030041",
      "display" : "寵物美容師、溝通師、寵物褓姆、寵物用品店店員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030050",
      "display" : "鐘錶匠",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030060",
      "display" : "鞋匠、雨傘匠、磨刀匠",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030070",
      "display" : "洗衣店人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030450",
      "display" : "保全公司負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030090",
      "display" : "警衛、保全人員（內勤）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030091",
      "display" : "警衛、保全人員、港口警衛及安全人員、機場警衛及安全人員（負有巡邏押運任務者）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030470",
      "display" : "大樓管理總幹事、行政人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030100",
      "display" : "大樓管理員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030110",
      "display" : "攝影師(無外拍)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030111",
      "display" : "攝影師(有外拍)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030140",
      "display" : "清潔、打蠟、消毒、除蟲人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030150",
      "display" : "高樓外部清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030160",
      "display" : "車輛保管人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030170",
      "display" : "加油(氣)站工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030180",
      "display" : "地磅工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030190",
      "display" : "煙囪清潔人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030200",
      "display" : "三溫暖業負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030210",
      "display" : "三溫暖業櫃檯人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030220",
      "display" : "三溫暖業工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030230",
      "display" : "鎖匠、刻印章人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030240",
      "display" : "汽車洗車、打臘美容人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030250",
      "display" : "裁縫師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030260",
      "display" : "水塔、化糞池清理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030280",
      "display" : "搬家人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030290",
      "display" : "職業潛水夫",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030300",
      "display" : "保全設備裝設人員、大樓機電人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030310",
      "display" : "火災現場勘查人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030320",
      "display" : "徵信社外勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030330",
      "display" : "水電工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030340",
      "display" : "紋身藝術人員、刺青師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030350",
      "display" : "民意代表、監立委、省縣市議員、外交人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030390",
      "display" : "民意代表助理",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030360",
      "display" : "村里幹事",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030370",
      "display" : "錄影帶/光碟片出租店負責人、店員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030380",
      "display" : "直銷商、傳銷商",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030400",
      "display" : "形象管理師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030410",
      "display" : "市場調查人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030420",
      "display" : "電訪/電銷人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030430",
      "display" : "芳療師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030440",
      "display" : "冷氣、洗衣機清洗人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16030460",
      "display" : "按摩師(腳底按摩、推拿)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1603 其他"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040010",
      "display" : "葬儀社負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040020",
      "display" : "內勤工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040030",
      "display" : "司儀",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040040",
      "display" : "化粧人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040050",
      "display" : "外務員、生前契約傳銷人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040060",
      "display" : "殯儀館管理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040070",
      "display" : "陣頭、樂隊人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040080",
      "display" : "墓園管理員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040090",
      "display" : "禮堂佈置人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040100",
      "display" : "火葬場處理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040110",
      "display" : "墓地建造工人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16040120",
      "display" : "檢骨師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1604 殯葬業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16050010",
      "display" : "第三方支付服務業、虛擬通貨平台及交易服務業公司負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1605 電支、第三方支付服務業(如：Line  Pay、綠界科技…等)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16050020",
      "display" : "電子票證業、電子支付業、外籍移工匯兌業公司負責人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1605 電支、第三方支付服務業(如：Line  Pay、綠界科技…等)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16050030",
      "display" : "一般行政人員(文書/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1605 電支、第三方支付服務業(如：Line  Pay、綠界科技…等)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16050040",
      "display" : "一般外勤人員(業務/採購)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "16服務業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1605 電支、第三方支付服務業(如：Line  Pay、綠界科技…等)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17000010",
      "display" : "家庭主婦",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "17家庭管理"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1700 家庭管理"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17000020",
      "display" : "佣人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "17家庭管理"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1700 家庭管理"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17000030",
      "display" : "褓姆",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "17家庭管理"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1700 家庭管理"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17000040",
      "display" : "退休人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "17家庭管理"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1700 家庭管理"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17000050",
      "display" : "無業、待業",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "17家庭管理"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1700 家庭管理"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17000060",
      "display" : "房東",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "17家庭管理"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1700 家庭管理"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010010",
      "display" : "警務行政及內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010020",
      "display" : "警察、警官、警員、電信警察、港警所警察（負有巡邏任務者）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010030",
      "display" : "監獄看守所管理人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010040",
      "display" : "交通警察",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010050",
      "display" : "刑警",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010060",
      "display" : "消防隊隊員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010061",
      "display" : "義消",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010070",
      "display" : "保安警察",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010080",
      "display" : "警察大學、警察專科學生",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010090",
      "display" : "警校教官",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010100",
      "display" : "防爆小組",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010110",
      "display" : "空中警察",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010120",
      "display" : "義警",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010130",
      "display" : "義交",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010140",
      "display" : "法警",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010150",
      "display" : "警務特勤人員(維安小組、霹靂小組)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010160",
      "display" : "守望相助人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1801 治安人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18020010",
      "display" : "空巡人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1802  海巡署"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18020020",
      "display" : "岸巡人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1802  海巡署"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18020030",
      "display" : "海巡人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1802  海巡署"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18030010",
      "display" : "法官、檢察官",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1803 法務人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18030011",
      "display" : "書記官",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1803 法務人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18030020",
      "display" : "調查局之調查員（不需蒐証）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1803 法務人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18030030",
      "display" : "調查局之調查員（需蒐証）",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1803 法務人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18030040",
      "display" : "觀護人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "18治安人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1803 法務人員"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000010",
      "display" : "一般軍人",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000020",
      "display" : "特種軍人（傘兵、爆破、佈雷、防爆、負有特殊任務之特勤人員……等    )",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000030",
      "display" : "志願役行政及內勤人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000040",
      "display" : "憲兵",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000050",
      "display" : "軍醫院官兵",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000060",
      "display" : "軍校教官、軍訓教官",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000070",
      "display" : "軍校學生",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000080",
      "display" : "機械、車輛、飛機、修護人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000090",
      "display" : "艦艇及潛艦官兵",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000100",
      "display" : "武器或彈藥製造人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000110",
      "display" : "軍機駕駛及機上工作人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19000120",
      "display" : "軍用車駕駛人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "19軍人"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "1900 現役軍人"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000010",
      "display" : "資訊業維護工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000020",
      "display" : "資訊業系統工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000030",
      "display" : "資訊業銷售工程師 (內勤)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000031",
      "display" : "資訊業銷售工程師 (外務)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000040",
      "display" : "電腦程式設計師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000050",
      "display" : "通信器材買賣商(負責人)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000051",
      "display" : "通信器材買賣(行)一般員工",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000052",
      "display" : "通信器材維修人員(含3C維修)",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000060",
      "display" : "事務機器維修人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000070",
      "display" : "硬體測試人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000080",
      "display" : "室內管線安裝人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000090",
      "display" : "智慧居家管理師、數位轉型專家、數位鑑識分析師、醫療AI資料科學家",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000100",
      "display" : "AR(擴增實境)、VR（虛擬實境）、元宇宙工程師",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20000110",
      "display" : "社群網站小編",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "20資訊業"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2000 資訊業"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21010010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2101 高爾夫球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21010011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2101 高爾夫球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21010020",
      "display" : "高爾夫球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2101 高爾夫球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21010030",
      "display" : "球僮",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2101 高爾夫球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21020010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2102 保齡球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21020011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2102 保齡球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21020020",
      "display" : "保齡球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2102 保齡球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21030010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2103 桌球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21030011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2103 桌球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21030020",
      "display" : "桌球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2103 桌球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21040010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2104 羽球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21040011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2104 羽球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21040020",
      "display" : "羽球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2104 羽球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21050010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2105 游泳"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21050011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2105 游泳"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21050020",
      "display" : "游泳人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2105 游泳"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21060010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2106 射箭"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21060011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2106 射箭"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21060020",
      "display" : "射箭人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2106 射箭"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21070010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2107 網球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21070011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2107 網球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21070020",
      "display" : "網球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2107 網球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21080010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2108 壘球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21080011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2108 壘球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21080020",
      "display" : "壘球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2108 壘球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21090010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2109 溜冰"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21090011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2109 溜冰"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21090020",
      "display" : "溜冰人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2109 溜冰"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21100010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2110 射擊"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21100011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2110 射擊"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21100020",
      "display" : "射擊人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2110 射擊"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21110010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2111 民俗體育活動"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21110011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2111 民俗體育活動"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21110020",
      "display" : "民俗體育活動人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2111 民俗體育活動"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21120010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2112 舉重"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21120011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2112 舉重"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21120020",
      "display" : "舉重人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2112 舉重"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21130010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2113 籃球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21130011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2113 籃球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21130020",
      "display" : "籃球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2113 籃球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21140010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2114 排球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21140011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2114 排球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21140020",
      "display" : "排球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2114 排球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21150010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2115 棒球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21150011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2115 棒球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21150020",
      "display" : "棒球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2115 棒球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21160010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2116 田徑"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21160011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2116 田徑"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21160020",
      "display" : "與賽人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2116 田徑"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21170010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2117 體操"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21170011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2117 體操"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21170020",
      "display" : "體操人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2117 體操"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21180010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2118 滑草"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21180011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2118 滑草"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21180020",
      "display" : "滑草人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2118 滑草"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21190010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2119 帆船"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21190011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2119 帆船"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21190020",
      "display" : "駕乘人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2119 帆船"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21200010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2120 划船"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21200011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2120 划船"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21200020",
      "display" : "駕乘人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2120 划船"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21210010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2121 泛舟"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21210011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2121 泛舟"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21210020",
      "display" : "駕乘人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2121 泛舟"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21220010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2122 巧固球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21220011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2122 巧固球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21220020",
      "display" : "巧固球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2122 巧固球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21230010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2123 手球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21230011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2123 手球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21230020",
      "display" : "手球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2123 手球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21240010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2124 風浪板"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21240011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2124 風浪板"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21240020",
      "display" : "駕乘人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2124 風浪板"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21250010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2125 水上摩托車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21250011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2125 水上摩托車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21250020",
      "display" : "駕乘人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2125 水上摩托車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21260010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2126 足球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21260011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2126 足球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21260020",
      "display" : "足球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2126 足球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21270010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2127 曲棍球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21270011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2127 曲棍球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21270020",
      "display" : "曲棍球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2127 曲棍球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21280010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2128 冰上曲棍球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21280011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2128 冰上曲棍球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21280020",
      "display" : "冰上曲棍球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2128 冰上曲棍球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21290010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2129 橄欖球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21290011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2129 橄欖球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21290020",
      "display" : "橄欖球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2129 橄欖球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21300010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2130 自由車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21300011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2130 自由車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21300020",
      "display" : "自由車選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2130 自由車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21310010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2131 角力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21310011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2131 角力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21310020",
      "display" : "角力人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2131 角力"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21320010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2132 摔角"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21320011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2132 摔角"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21320020",
      "display" : "摔角人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2132 摔角"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21330010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2133 柔道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21330011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2133 柔道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21330020",
      "display" : "柔道人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2133 柔道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21340010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2134 空手道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21340011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2134 空手道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21340020",
      "display" : "空手道人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2134 空手道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21350010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2135 跆拳道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21350011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2135 跆拳道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21350020",
      "display" : "跆拳道人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2135 跆拳道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21360010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2136 國術"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21360011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2136 國術"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21360020",
      "display" : "國術人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2136 國術"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21370010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2137 拳擊"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21370011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2137 拳擊"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21370020",
      "display" : "拳擊人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2137 拳擊"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21380010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2138 潛水"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21380011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2138 潛水"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21380020",
      "display" : "潛水人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2138 潛水"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21390010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2139 滑水"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21390011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2139 滑水"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21390020",
      "display" : "滑水人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2139 滑水"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21400010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2140 滑雪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21400011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2140 滑雪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21400020",
      "display" : "滑雪人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2140 滑雪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21410010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2141 馬術"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21410011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2141 馬術"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21410020",
      "display" : "馬術人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2141 馬術"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21420010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2142 特技表演"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21420011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2142 特技表演"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21420020",
      "display" : "特技表演人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2142 特技表演"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21430010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2143 雪車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21430011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2143 雪車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21430020",
      "display" : "與賽人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2143 雪車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21440010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2144 滑翔機具"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21440011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2144 滑翔機具"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21440020",
      "display" : "駕駛人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2144 滑翔機具"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21450010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2145  汽車、機車、賽車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21450011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2145  汽車、機車、賽車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21450020",
      "display" : "賽車人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2145  汽車、機車、賽車"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21460010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2146 跳傘"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21460011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2146 跳傘"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21460020",
      "display" : "跳傘人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2146 跳傘"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21470010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2147 動力及無動力飛行載具"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21470011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2147 動力及無動力飛行載具"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21470020",
      "display" : "駕駛人員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2147 動力及無動力飛行載具"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21480010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2148 撞球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21480011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2148 撞球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21480020",
      "display" : "撞球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2148 撞球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21490010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2149 迴力球\r\n(壁球)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21490011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2149 迴力球\r\n(壁球)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21490020",
      "display" : "迴力球球員",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2149 迴力球\r\n(壁球)"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21500010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2150 滑板直排輪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21500011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2150 滑板直排輪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21500020",
      "display" : "選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2150 滑板直排輪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21510010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2151 鐵人三項"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21510011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2151 鐵人三項"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21510020",
      "display" : "選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2151 鐵人三項"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21520010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2152 相撲"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21520011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2152 相撲"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21520020",
      "display" : "相撲選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2152 相撲"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21530010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2153 合氣道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21530011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2153 合氣道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21530020",
      "display" : "合氣道選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2153 合氣道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21540010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2154 衝浪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21540011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2154 衝浪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21540020",
      "display" : "衝浪選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2154 衝浪"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21550010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2155 跳水"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21550011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2155 跳水"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21550020",
      "display" : "跳水選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2155 跳水"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21560010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2156 高空彈跳"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21560011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2156 高空彈跳"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21560020",
      "display" : "選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2156 高空彈跳"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21570010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2157 攀岩"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21570011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2157 攀岩"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21570020",
      "display" : "選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2157 攀岩"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21580010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2158 馬球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21580011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2158 馬球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21580020",
      "display" : "選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2158 馬球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21590010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2159 劍道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21590011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2159 劍道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21590020",
      "display" : "選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2159 劍道"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21600010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2160 西洋劍"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21600011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2160 西洋劍"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21600020",
      "display" : "選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2160 西洋劍"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21610010",
      "display" : "教練",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2161槌球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21610011",
      "display" : "裁判",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2161槌球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21610020",
      "display" : "選手",
      "property" : [
        {
          "code" : "OccupationClassification",
          "valueString" : "21職業運動人員"
        },
        {
          "code" : "OccupationBreakdown",
          "valueString" : "2161槌球"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-06-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
