# 臺灣健保署中藥用藥品項 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣健保署中藥用藥品項 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/nhi-medication-ch-herb-tw | *Version*:2024-05-31 |
| Active as of 2024-05-31 | *Computable Name*:TWCHHerbMedicationNHI |
| **Copyright/Legal**: 衛生福利部中央健康保險署 | |

 
臺灣健保署中藥用藥品項，參照自[中藥用藥品項表](https://www.nhi.gov.tw/ch/cp-14300-03585-2467-1.html)中的「單方(113.06.01更新)」及「複方(113.04.01更新)」。 代碼出版日期：2024-05-31；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWCHHerbMedicationNHI](ValueSet-nhi-medication-ch-herb-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "nhi-medication-ch-herb-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/nhi-medication-ch-herb-tw",
  "version" : "2024-05-31",
  "name" : "TWCHHerbMedicationNHI",
  "title" : "臺灣健保署中藥用藥品項",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-05-31",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署中藥用藥品項，參照自[中藥用藥品項表](https://www.nhi.gov.tw/ch/cp-14300-03585-2467-1.html)中的「單方(113.06.01更新)」及「複方(113.04.01更新)」。\n代碼出版日期：2024-05-31；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*  \n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱",
  "copyright" : "衛生福利部中央健康保險署",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 16,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "A061308",
      "display" : "順天堂紅耆濃縮顆粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A061204",
      "display" : "莊松榮炒決明子濃縮細粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A061208",
      "display" : "莊松榮夏枯草濃縮細粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A061211",
      "display" : "莊松榮五味子濃縮細粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A061219",
      "display" : "莊松榮三稜濃縮細粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A061224",
      "display" : "莊松榮益智濃縮細粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A061225",
      "display" : "莊松榮竹茹濃縮細粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A061242",
      "display" : "莊松榮狗脊濃縮細粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A061245",
      "display" : "莊松榮桑葉濃縮細粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A002529",
      "display" : "順天堂白鮮皮濃縮顆粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A045141",
      "display" : "德山杏仁濃縮細粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A046772",
      "display" : "順天堂蒼朮濃縮散",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A046821",
      "display" : "順天堂補骨脂濃縮顆粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A046824",
      "display" : "順天堂決明子濃縮顆粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A046840",
      "display" : "順天堂枳殼濃縮顆粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    },
    {
      "code" : "A046965",
      "display" : "順天堂天門冬濃縮顆粒",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-31"
        }
      ]
    }
  ]
}

```
