# 臺灣食藥署醫療器材許可證 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣食藥署醫療器材許可證 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-device-fda-tw | *Version*:2024-06-06 |
| Active as of 2024-06-06 | *Computable Name*:TWMedicationDeviceFDA |
| **Copyright/Legal**: 衛生福利部食品藥物管理署 | |

 
臺灣食藥署醫療器材許可證，參照自[https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=68](https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=68)
代碼出版日期：2022-08-08-08；資料所屬單位：衛生福利部食品藥物管理署。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－臺灣食藥署醫療器材許可證](https://fhir.mohw.gov.tw/ts/codesystemRead.jsp?id=medication-device-fda-tw&status=active&version=2022-08-08-08&metaId=1&codeStatus=use&show=Y)查閱 
* 2024/7/8異動說明：2024-06-06版的臺灣食藥署醫療器材許可證代碼中新增、刪除、修改代碼量較大會使載入頁面時間較長，完整異動代碼說明請至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱。
 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWMedicationFDA](ValueSet-medication-fda-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medication-device-fda-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-device-fda-tw",
  "version" : "2024-06-06",
  "name" : "TWMedicationDeviceFDA",
  "title" : "臺灣食藥署醫療器材許可證",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-06-06",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣食藥署醫療器材許可證，參照自[https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=68](https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=68)  \n代碼出版日期：2022-08-08-08；資料所屬單位：衛生福利部食品藥物管理署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－臺灣食藥署醫療器材許可證](https://fhir.mohw.gov.tw/ts/codesystemRead.jsp?id=medication-device-fda-tw&status=active&version=2022-08-08-08&metaId=1&codeStatus=use&show=Y)查閱\n\n\n* 2024/7/8異動說明：2024-06-06版的臺灣食藥署醫療器材許可證代碼中新增、刪除、修改代碼量較大會使載入頁面時間較長，完整異動代碼說明請至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱。\n",
  "copyright" : "衛生福利部食品藥物管理署",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 12,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "許可證字號",
      "display" : "中文品名",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-06"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部罕醫器輸字第000001號",
      "display" : "\"沛佳\"法斯樂-杜瓦伸縮式髓內釘系統",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部醫器陸輸字第000506號",
      "display" : "\"康德萊\"胰島素筆配套用針",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部醫器陸輸字第000507號",
      "display" : "優盛電子體溫計",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部醫器陸輸字第000508號",
      "display" : "\"勤達\"一次性使用無菌注射器帶針/不帶針",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部醫器陸輸字第000509號",
      "display" : "\"帝寶\"紅外線耳溫槍",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部醫器陸輸字第000510號",
      "display" : "\"華爾怡\"一次性使用全自動回縮型注射器(帶針)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部醫器陸輸字第000521號",
      "display" : "醫佳一次性使用真空採血管(無添加)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部醫器陸輸字第000522號",
      "display" : "嘉鎂一次性使用人體靜脈血樣採集容器(普通管)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部醫器陸輸字第000523號",
      "display" : "亞培輔理善越捷型血糖監測系統",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部醫器陸輸字第000524號",
      "display" : "亞培輔理善越佳型血糖血酮監測系統",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部醫器陸輸字第000525號",
      "display" : "醫凡一次性使用真空採血管(無添加)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-08"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
