# 臺灣戶政司婚姻狀態 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣戶政司婚姻狀態 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/marital-status-tw | *Version*:2019-05-22 |
| Active as of 2019-05-22 | *Computable Name*:TWMaritalStatus |
| **Copyright/Legal**: 內政部戶政司 | |

 
臺灣戶政司婚姻狀態，參照至[戶役政資訊系統資料代碼內容清單](https://www.ris.gov.tw/documents/html/5/1/168.html)中的「婚姻狀況代碼」。 
代碼出版日期：2019-05-22；資料所屬單位：內政部戶政司。 
代碼文字標示之施行法，係指司法院釋字第748號解釋施行法。 
**因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWMaritalStatus](ValueSet-marital-status-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "marital-status-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/marital-status-tw",
  "version" : "2019-05-22",
  "name" : "TWMaritalStatus",
  "title" : "臺灣戶政司婚姻狀態",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-05-22",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣戶政司婚姻狀態，參照至[戶役政資訊系統資料代碼內容清單](https://www.ris.gov.tw/documents/html/5/1/168.html)中的「婚姻狀況代碼」。 \n\n代碼出版日期：2019-05-22；資料所屬單位：內政部戶政司。\n\n代碼文字標示之施行法，係指司法院釋字第748號解釋施行法。 \n \n*因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。*",
  "copyright" : "內政部戶政司",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 9,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "1",
      "display" : "未婚",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2019-05-22"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "2",
      "display" : "有偶",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2019-05-22"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "3",
      "display" : "離婚",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2019-05-22"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "4",
      "display" : "喪偶",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2019-05-22"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "5",
      "display" : "婚姻關係消滅",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2019-05-22"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "6",
      "display" : "有偶（施行法）",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2019-05-22"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "7",
      "display" : "終止結婚（施行法）",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2019-05-22"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "8",
      "display" : "喪偶（施行法）",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2019-05-22"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "9",
      "display" : "婚姻關係消滅（施行法）",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2019-05-22"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
