# 行政院主計總處行業分類 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 行政院主計總處行業分類 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/industry-dgbas-tw | *Version*:2021-01-01 |
| Active as of 2021-01-01 | *Computable Name*:TWIndustry |
| **Copyright/Legal**: 行政院主計總處 | |

 
行政院主計總處行業分類，參照至行政院主計總處的[行業統計分類(第11次修正)](https://ws.dgbas.gov.tw/001/Upload/463/attachment/11195/90015/012221854690wg0x9i.pdf)代碼出版日期：2021-01-01；資料所屬單位：行政院主計總處。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWIndustry](ValueSet-industry-dgbas-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "industry-dgbas-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/industry-dgbas-tw",
  "version" : "2021-01-01",
  "name" : "TWIndustry",
  "title" : "行政院主計總處行業分類",
  "status" : "active",
  "experimental" : false,
  "date" : "2021-01-01",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "行政院主計總處行業分類，參照至行政院主計總處的[行業統計分類(第11次修正)](https://ws.dgbas.gov.tw/001/Upload/463/attachment/11195/90015/012221854690wg0x9i.pdf)\n代碼出版日期：2021-01-01；資料所屬單位：行政院主計總處。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*",
  "copyright" : "行政院主計總處",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "count" : 737,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "農、林、漁、牧業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "01",
          "display" : "農、牧業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "011",
              "display" : "農作物栽培業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "0111",
                  "display" : "稻作栽培業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0112",
                  "display" : "雜糧栽培業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0113",
                  "display" : "特用作物栽培業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0114",
                  "display" : "蔬菜栽培業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0115",
                  "display" : "果樹栽培業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0116",
                  "display" : "食用菇蕈栽培業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0117",
                  "display" : "花卉栽培業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0119",
                  "display" : "其他農作物栽培業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "012",
              "display" : "畜牧業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "0121",
                  "display" : "牛飼育業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0122",
                  "display" : "豬飼育業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0123",
                  "display" : "雞飼育業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0124",
                  "display" : "鴨飼育業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0129",
                  "display" : "其他畜牧業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "013",
              "display" : "農事及畜牧服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "02",
          "display" : "林業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "03",
          "display" : "漁業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "031",
              "display" : "漁撈業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "032",
              "display" : "水產養殖業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "0321",
                  "display" : "海面養殖業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0322",
                  "display" : "內陸養殖業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "B",
      "display" : "礦業及土石採取業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "05",
          "display" : "石油及天然氣礦業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "06",
          "display" : "砂、石採取及其他礦業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        }
      ]
    },
    {
      "code" : "C",
      "display" : "製造業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "08",
          "display" : "食品及飼品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "081",
              "display" : "肉類加工及保藏業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "0811",
                  "display" : "屠宰業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0812",
                  "display" : "肉類其他加工及保藏業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "082",
              "display" : "水產加工及保藏業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "083",
              "display" : "蔬果加工及保藏業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "084",
              "display" : "動植物油脂製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "085",
              "display" : "乳品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "086",
              "display" : "碾榖、磨粉及澱粉製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "0861",
                  "display" : "碾榖業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0862",
                  "display" : "磨粉製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0863",
                  "display" : "澱粉及其製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "087",
              "display" : "動物飼品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "089",
              "display" : "其他食品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "0891",
                  "display" : "烘焙炊蒸食品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0892",
                  "display" : "麵條及粉條類食品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0893",
                  "display" : "製糖業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0894",
                  "display" : "巧克力及糖果製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0895",
                  "display" : "製茶業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0896",
                  "display" : "調味品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0897",
                  "display" : "膳食及菜餚製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0898",
                  "display" : "保健營養食品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0899",
                  "display" : "未分類其他食品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "09",
          "display" : "飲料製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "091",
              "display" : "酒精飲料製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "0911",
                  "display" : "啤酒製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "0919",
                  "display" : "其他酒精飲料製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "092",
              "display" : "非酒精飲料製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "10",
          "display" : "菸草製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "11",
          "display" : "紡織業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "111",
              "display" : "紡紗業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1111",
                  "display" : "棉毛紡紗業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1112",
                  "display" : "人造纖維紡紗業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1113",
                  "display" : "人造纖維加工絲業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1119",
                  "display" : "其他紡紗業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "112",
              "display" : "織布業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1121",
                  "display" : "棉毛梭織布業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1122",
                  "display" : "人造纖維梭織布業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1123",
                  "display" : "玻璃纖維梭織布業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1124",
                  "display" : "針織布業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1129",
                  "display" : "其他織布業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "113",
              "display" : "不織布業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "114",
              "display" : "染整業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "115",
              "display" : "紡織品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1151",
                  "display" : "紡織製成品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1152",
                  "display" : "繩、纜及網製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1159",
                  "display" : "其他紡織品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "12",
          "display" : "成衣及服飾品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "121",
              "display" : "成衣製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "123",
              "display" : "服飾品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "13",
          "display" : "皮革、毛皮及其製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "130",
              "display" : "皮革、毛皮及其製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1301",
                  "display" : "皮革及毛皮整製業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1302",
                  "display" : "鞋類製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1303",
                  "display" : "行李箱及手提袋製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1309",
                  "display" : "其他皮革及毛皮製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "14",
          "display" : "木竹製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "140",
              "display" : "木竹製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1401",
                  "display" : "製材業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1402",
                  "display" : "合板及組合木材製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1403",
                  "display" : "建築用木製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1404",
                  "display" : "木質容器製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1409",
                  "display" : "其他木竹製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "15",
          "display" : "紙漿、紙及紙製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "151",
              "display" : "紙漿、紙及紙板製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1511",
                  "display" : "紙漿製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1512",
                  "display" : "紙張製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1513",
                  "display" : "紙板製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "152",
              "display" : "瓦楞紙板及紙容器製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "159",
              "display" : "其他紙製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1591",
                  "display" : "家庭及衛生用紙製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1599",
                  "display" : "未分類其他紙製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "16",
          "display" : "印刷及資料儲存媒體複製業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "160",
              "display" : "印刷及資料儲存媒體複製業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1601",
                  "display" : "印刷業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1602",
                  "display" : "印刷輔助業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1603",
                  "display" : "資料儲存媒體複製業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "17",
          "display" : "石油及煤製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "18",
          "display" : "化學材料及肥料製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "181",
              "display" : "化學原材料製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "183",
              "display" : "肥料及氮化合物製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "184",
              "display" : "塑膠及合成橡膠原料製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1841",
                  "display" : "塑膠原料製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1842",
                  "display" : "合成橡膠原料製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "185",
              "display" : "人造纖維製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "19",
          "display" : "其他化學製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "191",
              "display" : "農藥及環境用藥製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "192",
              "display" : "塗料、染料及顏料製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "193",
              "display" : "清潔用品及化粧品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "1931",
                  "display" : "清潔用品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "1932",
                  "display" : "化粧品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "199",
              "display" : "未分類其他化學製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "20",
          "display" : "藥品及醫用化學製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "200",
              "display" : "藥品及醫用化學製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2001",
                  "display" : "原料藥製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2002",
                  "display" : "西藥製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2003",
                  "display" : "醫用生物製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2004",
                  "display" : "中藥製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2005",
                  "display" : "醫用化學製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "21",
          "display" : "橡膠製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "210",
              "display" : "橡膠製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2101",
                  "display" : "輪胎製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2102",
                  "display" : "工業用橡膠製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2109",
                  "display" : "其他橡膠製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "22",
          "display" : "塑膠製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "220",
              "display" : "塑膠製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2201",
                  "display" : "塑膠皮、板及管材製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2202",
                  "display" : "塑膠膜袋製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2203",
                  "display" : "塑膠外殼及配件製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2209",
                  "display" : "其他塑膠製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "23",
          "display" : "非金屬礦物製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "231",
              "display" : "玻璃及其製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2311",
                  "display" : "平板玻璃及其製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2312",
                  "display" : "玻璃容器製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2313",
                  "display" : "玻璃纖維製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2319",
                  "display" : "其他玻璃及其製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "232",
              "display" : "耐火、黏土建材及其他陶瓷製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2321",
                  "display" : "耐火材料製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2322",
                  "display" : "黏土建築材料製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2329",
                  "display" : "其他陶瓷製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "233",
              "display" : "水泥及其製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2331",
                  "display" : "水泥製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2332",
                  "display" : "預拌混凝土製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2333",
                  "display" : "水泥及混凝土製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "234",
              "display" : "石材製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "239",
              "display" : "其他非金屬礦物製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2391",
                  "display" : "研磨材料製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2399",
                  "display" : "未分類其他非金屬礦物製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "24",
          "display" : "基本金屬製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "241",
              "display" : "鋼鐵製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2411",
                  "display" : "鋼鐵冶鍊業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2412",
                  "display" : "鋼鐵鑄造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2413",
                  "display" : "鋼鐵軋延及擠型業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2414",
                  "display" : "鋼鐵伸線業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "242",
              "display" : "鋁製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2421",
                  "display" : "鍊鋁業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2422",
                  "display" : "鋁鑄造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2423",
                  "display" : "鋁材軋延、擠型及伸線業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "243",
              "display" : "銅製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2431",
                  "display" : "鍊銅業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2432",
                  "display" : "銅鑄造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2433",
                  "display" : "銅材軋延、擠型及伸線業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "249",
              "display" : "其他基本金屬製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2491",
                  "display" : "其他基本金屬鑄造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2499",
                  "display" : "未分類其他基本金屬製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "25",
          "display" : "金屬製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "251",
              "display" : "金屬刀具、手工具及模具製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2511",
                  "display" : "金屬刀具及手工具製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2512",
                  "display" : "金屬模具製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "252",
              "display" : "金屬結構及建築組件製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2521",
                  "display" : "金屬結構製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2522",
                  "display" : "金屬建築組件製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "253",
              "display" : "金屬容器製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2531",
                  "display" : "鍋爐、金屬貯槽及壓力容器製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2539",
                  "display" : "其他金屬容器製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "254",
              "display" : "金屬加工處理業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2541",
                  "display" : "金屬鍛造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2542",
                  "display" : "粉末冶金業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2543",
                  "display" : "金屬熱處理業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2544",
                  "display" : "金屬表面處理業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2549",
                  "display" : "其他金屬加工處理業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "259",
              "display" : "其他金屬製品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2591",
                  "display" : "螺絲、螺帽及鉚釘製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2592",
                  "display" : "金屬彈簧及線製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2599",
                  "display" : "未分類其他金屬製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "26",
          "display" : "電子零組件製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "261",
              "display" : "半導體製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2611",
                  "display" : "積體電路製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2612",
                  "display" : "分離式元件製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2613",
                  "display" : "半導體封裝及測試業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "262",
              "display" : "被動電子元件製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "263",
              "display" : "印刷電路板製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "264",
              "display" : "光電材料及元件製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2641",
                  "display" : "面板及其組件製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2642",
                  "display" : "發光二極體製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2643",
                  "display" : "太陽能電池製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2649",
                  "display" : "其他光電材料及元件製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "269",
              "display" : "其他電子零組件製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2691",
                  "display" : "印刷電路板組件製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2699",
                  "display" : "未分類其他電子零組件製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "27",
          "display" : "電腦、電子產品及光學製品製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "271",
              "display" : "電腦及其週邊設備製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2711",
                  "display" : "電腦製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2712",
                  "display" : "顯示器及終端機製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2719",
                  "display" : "其他電腦週邊設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "272",
              "display" : "通訊傳播設備製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2721",
                  "display" : "電話及手機製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2729",
                  "display" : "其他通訊傳播設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "273",
              "display" : "視聽電子產品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "274",
              "display" : "資料儲存媒體製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "275",
              "display" : "量測、導航、控制設備及鐘錶製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2751",
                  "display" : "量測、導航及控制設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2752",
                  "display" : "鐘錶製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "276",
              "display" : "輻射及電子醫學設備製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "277",
              "display" : "光學儀器及設備製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2771",
                  "display" : "照相機製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2779",
                  "display" : "其他光學儀器及設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "28",
          "display" : "電力設備及配備製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "281",
              "display" : "發電、輸電及配電機械製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "282",
              "display" : "電池製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "283",
              "display" : "電線及配線器材製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2831",
                  "display" : "電線及電纜製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2832",
                  "display" : "配線器材製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "284",
              "display" : "照明設備及配備製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2841",
                  "display" : "電燈泡及燈管製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2842",
                  "display" : "照明器具製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "285",
              "display" : "家用電器製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2851",
                  "display" : "家用空調器具製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2859",
                  "display" : "其他家用電器製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "289",
              "display" : "其他電力設備及配備製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "29",
          "display" : "機械設備製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "291",
              "display" : "金屬加工用機械設備製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2911",
                  "display" : "冶金機械製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2912",
                  "display" : "金屬切削工具機製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2919",
                  "display" : "其他金屬加工用機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "292",
              "display" : "其他專用機械設備製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2921",
                  "display" : "農用及林用機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2922",
                  "display" : "採礦及營造用機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2923",
                  "display" : "食品、飲料及菸草製作用機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2924",
                  "display" : "紡織、成衣及皮革生產用機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2925",
                  "display" : "木工機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2926",
                  "display" : "化工機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2927",
                  "display" : "橡膠及塑膠加工用機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2928",
                  "display" : "電子及半導體生產用機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2929",
                  "display" : "未分類其他專用機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "293",
              "display" : "通用機械設備製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "2931",
                  "display" : "原動機製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2932",
                  "display" : "流體傳動設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2933",
                  "display" : "泵、壓縮機、活栓及活閥製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2934",
                  "display" : "機械傳動設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2935",
                  "display" : "輸送機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2936",
                  "display" : "事務機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2937",
                  "display" : "污染防治設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2938",
                  "display" : "動力手工具製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "2939",
                  "display" : "其他通用機械設備製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "30",
          "display" : "汽車及其零件製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "301",
              "display" : "汽車製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "302",
              "display" : "車體製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "303",
              "display" : "汽車零件製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "31",
          "display" : "其他運輸工具及其零件製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "311",
              "display" : "船舶及浮動設施製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "312",
              "display" : "機車及其零件製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3121",
                  "display" : "機車製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3122",
                  "display" : "機車零件製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "313",
              "display" : "自行車及其零件製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3131",
                  "display" : "自行車製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3132",
                  "display" : "自行車零件製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "319",
              "display" : "未分類其他運輸工具及其零件製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "32",
          "display" : "家具製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "321",
              "display" : "非金屬家具製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3211",
                  "display" : "木製家具製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3219",
                  "display" : "其他非金屬家具製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "322",
              "display" : "金屬家具製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "33",
          "display" : "其他製造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "331",
              "display" : "育樂用品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3311",
                  "display" : "體育用品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3312",
                  "display" : "玩具及遊戲機製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3313",
                  "display" : "樂器製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3314",
                  "display" : "文具製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "332",
              "display" : "醫療器材及用品製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3321",
                  "display" : "眼鏡製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3329",
                  "display" : "其他醫療器材及用品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "339",
              "display" : "未分類其他製造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3391",
                  "display" : "珠寶及金工製品製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3392",
                  "display" : "拉鍊及鈕扣製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3399",
                  "display" : "其他未分類製造業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "34",
          "display" : "產業用機械設備維修及安裝業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        }
      ]
    },
    {
      "code" : "D",
      "display" : "電力及燃氣供應業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "35",
          "display" : "電力及燃氣供應業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "351",
              "display" : "電力供應業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "352",
              "display" : "氣體燃料供應業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "353",
              "display" : "蒸汽供應業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "E",
      "display" : "用水供應及污染整治業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "36",
          "display" : "用水供應業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "37",
          "display" : "廢水及污水處理業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "38",
          "display" : "廢棄物清除、處理及資源物回收處理業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "381",
              "display" : "廢棄物清除業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3811",
                  "display" : "非有害廢棄物清除業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3812",
                  "display" : "有害廢棄物清除業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "382",
              "display" : "廢棄物處理業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "3821",
                  "display" : "非有害廢棄物處理業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "3822",
                  "display" : "有害廢棄物處理業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "383",
              "display" : "資源物回收處理業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "39",
          "display" : "污染整治業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        }
      ]
    },
    {
      "code" : "F",
      "display" : "營建工程業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "41",
          "display" : "建築工程業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "42",
          "display" : "土木工程業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "421",
              "display" : "道路工程業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "422",
              "display" : "公用事業設施工程業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "429",
              "display" : "其他土木工程業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "43",
          "display" : "專門營造業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "431",
              "display" : "整地、基礎及結構工程業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "432",
              "display" : "庭園景觀工程業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "433",
              "display" : "機電、管道及其他建築設備安裝業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4331",
                  "display" : "機電、電信及電路設備安裝業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4332",
                  "display" : "冷凍、空調及管道工程業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4339",
                  "display" : "其他建築設備安裝業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "434",
              "display" : "建物完工裝修工程業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "439",
              "display" : "其他專門營造業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "G",
      "display" : "批發及零售業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "45-46",
          "display" : "批發業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "451",
              "display" : "商品批發經紀業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "452",
              "display" : "綜合商品批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "453",
              "display" : "農產原料及活動物批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4531",
                  "display" : "穀類及豆類批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4532",
                  "display" : "花卉批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4533",
                  "display" : "活動物批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4539",
                  "display" : "其他農產原料批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "454",
              "display" : "食品、飲料及菸草製品批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4541",
                  "display" : "蔬果批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4542",
                  "display" : "肉品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4543",
                  "display" : "水產品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4544",
                  "display" : "冷凍調理食品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4545",
                  "display" : "乳製品、蛋及食用油脂批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4546",
                  "display" : "菸酒批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4547",
                  "display" : "非酒精飲料批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4548",
                  "display" : "咖啡、茶葉及辛香料批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4549",
                  "display" : "其他食品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "455",
              "display" : "布疋及服飾品批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4551",
                  "display" : "布疋批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4552",
                  "display" : "服裝及其配件批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4553",
                  "display" : "鞋類批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4559",
                  "display" : "其他服飾品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "456",
              "display" : "家用器具及用品批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4561",
                  "display" : "家用電器批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4562",
                  "display" : "家具批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4563",
                  "display" : "家飾品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4564",
                  "display" : "家用攝影器材及光學產品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4565",
                  "display" : "鐘錶及眼鏡批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4566",
                  "display" : "珠寶及貴金屬製品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4567",
                  "display" : "清潔用品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4569",
                  "display" : "其他家用器具及用品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "457",
              "display" : "藥品、醫療用品及化粧品批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4571",
                  "display" : "藥品及醫療用品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4572",
                  "display" : "化粧品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "458",
              "display" : "文教育樂用品批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4581",
                  "display" : "書籍及文具批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4582",
                  "display" : "運動用品及器材批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4583",
                  "display" : "玩具及娛樂用品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "461",
              "display" : "建材批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4611",
                  "display" : "木製建材批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4612",
                  "display" : "磚瓦、砂石、水泥及其製品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4613",
                  "display" : "瓷磚、貼面石材及衛浴設備批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4614",
                  "display" : "漆料及塗料批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4615",
                  "display" : "金屬建材批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4619",
                  "display" : "其他建材批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "462",
              "display" : "化學原材料及其製品批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4620",
                  "display" : "化學原材料及其製品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "463",
              "display" : "燃料及相關產品批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4631",
                  "display" : "液體、氣體燃料及相關產品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4639",
                  "display" : "其他燃料批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "464",
              "display" : "機械器具批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4641",
                  "display" : "電腦及其週邊設備、軟體批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4642",
                  "display" : "電子、通訊設備及其零組件批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4643",
                  "display" : "農用及工業用機械設備批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4644",
                  "display" : "辦公用機械器具批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4649",
                  "display" : "其他機械器具批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "465",
              "display" : "汽機車及其零配件、用品批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4651",
                  "display" : "汽車批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4652",
                  "display" : "機車批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4653",
                  "display" : "汽機車零配件及用品批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "469",
              "display" : "其他專賣批發業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4691",
                  "display" : "回收物料批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4699",
                  "display" : "未分類其他專賣批發業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "47-48",
          "display" : "零售業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "471",
              "display" : "綜合商品零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4711",
                  "display" : "連鎖便利商店",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4712",
                  "display" : "百貨公司",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4719",
                  "display" : "其他綜合商品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "472",
              "display" : "食品、飲料及菸草製品零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4721",
                  "display" : "蔬果零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4722",
                  "display" : "肉品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4723",
                  "display" : "水產品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4729",
                  "display" : "其他食品、飲料及菸草製品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "473",
              "display" : "布疋及服飾品零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4731",
                  "display" : "布疋零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4732",
                  "display" : "服裝及其配件零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4733",
                  "display" : "鞋類零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4739",
                  "display" : "其他服飾品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "474",
              "display" : "家用器具及用品零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4741",
                  "display" : "家用電器零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4742",
                  "display" : "家具零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4743",
                  "display" : "家飾品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4744",
                  "display" : "鐘錶及眼鏡零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4745",
                  "display" : "珠寶及貴金屬製品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4749",
                  "display" : "其他家用器具及用品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "475",
              "display" : "藥品、醫療用品及化粧品零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4751",
                  "display" : "藥品及醫療用品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4752",
                  "display" : "化粧品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "476",
              "display" : "文教育樂用品零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4761",
                  "display" : "書籍及文具零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4762",
                  "display" : "運動用品及器材零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4763",
                  "display" : "玩具及娛樂用品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4764",
                  "display" : "影音光碟零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "481",
              "display" : "建材零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "482",
              "display" : "燃料及相關產品零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4821",
                  "display" : "加油及加氣站",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4829",
                  "display" : "其他燃料及相關產品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "483",
              "display" : "資訊及通訊設備零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4831",
                  "display" : "電腦及其週邊設備、軟體零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4832",
                  "display" : "通訊設備零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4833",
                  "display" : "視聽設備零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "484",
              "display" : "汽機車及其零配件、用品零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4841",
                  "display" : "汽車零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4842",
                  "display" : "機車零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4843",
                  "display" : "汽機車零配件及用品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "485",
              "display" : "其他專賣零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4851",
                  "display" : "花卉零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4852",
                  "display" : "其他全新商品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4853",
                  "display" : "中古商品零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "486",
              "display" : "零售攤販",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4861",
                  "display" : "食品、飲料及菸草製品之零售攤販",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4862",
                  "display" : "紡織品、服裝及鞋類之零售攤販",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4869",
                  "display" : "其他零售攤販",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "487",
              "display" : "其他非店面零售業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4871",
                  "display" : "電子購物及郵購業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4872",
                  "display" : "直銷業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4879",
                  "display" : "未分類其他非店面零售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "H",
      "display" : "運輸及倉儲業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "49",
          "display" : "陸上運輸業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "491",
              "display" : "鐵路運輸業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "492",
              "display" : "捷運運輸業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "493",
              "display" : "汽車客運業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "4931",
                  "display" : "公共汽車客運業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4932",
                  "display" : "計程車客運業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "4939",
                  "display" : "其他汽車客運業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "494",
              "display" : "汽車貨運業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "499",
              "display" : "其他陸上運輸業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "50",
          "display" : "水上運輸業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "501",
              "display" : "海洋水運業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "502",
              "display" : "內河及湖泊水運業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "51",
          "display" : "航空運輸業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "52",
          "display" : "運輸輔助業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "521",
              "display" : "報關業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "522",
              "display" : "船務代理業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "523",
              "display" : "貨運承攬業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5231",
                  "display" : "陸上貨運承攬業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5232",
                  "display" : "海洋貨運承攬業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5233",
                  "display" : "航空貨運承攬業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "524",
              "display" : "陸上運輸輔助業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5241",
                  "display" : "停車場",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5249",
                  "display" : "其他陸上運輸輔助業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "525",
              "display" : "水上運輸輔助業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5251",
                  "display" : "港埠業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5259",
                  "display" : "其他水上運輸輔助業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "526",
              "display" : "航空運輸輔助業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "529",
              "display" : "其他運輸輔助業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "53",
          "display" : "倉儲業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "530",
              "display" : "倉儲業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5301",
                  "display" : "普通倉儲業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5302",
                  "display" : "冷凍冷藏倉儲業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "54",
          "display" : "郵政及遞送服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "541",
              "display" : "郵政業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "542",
              "display" : "遞送服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "I",
      "display" : "住宿及餐飲業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "55",
          "display" : "住宿業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "551",
              "display" : "短期住宿業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "559",
              "display" : "其他住宿業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "56",
          "display" : "餐飲業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "561",
              "display" : "餐食業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5611",
                  "display" : "餐館",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5612",
                  "display" : "餐食攤販",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "562",
              "display" : "外燴及團膳承包業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "563",
              "display" : "飲料業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5631",
                  "display" : "飲料店",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5632",
                  "display" : "飲料攤販",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "J",
      "display" : "出版影音及資通訊業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "58",
          "display" : "出版業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "581",
              "display" : "新聞、雜誌、期刊、書籍及其他出版業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5811",
                  "display" : "新聞出版業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5812",
                  "display" : "雜誌及期刊出版業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5813",
                  "display" : "書籍出版業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5819",
                  "display" : "其他出版業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "582",
              "display" : "軟體出版業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "59",
          "display" : "影片及電視節目業；聲音錄製及音樂發行業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "591",
              "display" : "影片及電視節目業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "5911",
                  "display" : "影片及電視節目製作業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5912",
                  "display" : "影片及電視節目後製業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5913",
                  "display" : "影片及電視節目發行業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "5914",
                  "display" : "影片放映業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "592",
              "display" : "聲音錄製及音樂發行業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "60",
          "display" : "廣播、電視節目編排及傳播業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "601",
              "display" : "廣播業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "602",
              "display" : "電視節目編排及傳播業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "61",
          "display" : "電信業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "610",
              "display" : "電信業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6101",
                  "display" : "有線電信業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6102",
                  "display" : "無線電信業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6109",
                  "display" : "其他電信業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "62",
          "display" : "電腦程式設計、諮詢及相關服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "620",
              "display" : "電腦程式設計、諮詢及相關服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6201",
                  "display" : "電腦程式設計業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6202",
                  "display" : "電腦諮詢及設備管理業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6209",
                  "display" : "其他電腦相關服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "63",
          "display" : "資訊服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "631",
              "display" : "入口網站經營、資料處理、主機及網站代管服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6311",
                  "display" : "入口網站經營業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6312",
                  "display" : "資料處理、主機及網站代管服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "639",
              "display" : "其他資訊服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "K",
      "display" : "金融及保險業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "64",
          "display" : "金融服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "641",
              "display" : "貨幣中介業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6411",
                  "display" : "中央銀行",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6412",
                  "display" : "銀行業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6413",
                  "display" : "信用合作社",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6414",
                  "display" : "農會及漁會信用部",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6415",
                  "display" : "郵政儲金匯兌業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6419",
                  "display" : "其他貨幣中介業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "642",
              "display" : "控股業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6421",
                  "display" : "金融控股業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6429",
                  "display" : "其他控股業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "643",
              "display" : "信託、基金及類似金融實體",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "649",
              "display" : "其他金融服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6491",
                  "display" : "金融租賃業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6492",
                  "display" : "票券金融業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6496",
                  "display" : "民間融資業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6499",
                  "display" : "未分類其他金融服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "65",
          "display" : "保險業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "651",
              "display" : "人身保險業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "652",
              "display" : "財產保險業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "653",
              "display" : "再保險業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "654",
              "display" : "退休基金",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "655",
              "display" : "保險輔助業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6551",
                  "display" : "保險代理及經紀業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6559",
                  "display" : "其他保險輔助業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "66",
          "display" : "證券期貨及金融輔助業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "661",
              "display" : "證券業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6611",
                  "display" : "證券商",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6612",
                  "display" : "證券輔助業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "662",
              "display" : "期貨業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6621",
                  "display" : "期貨商",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6622",
                  "display" : "期貨輔助業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "664",
              "display" : "基金管理業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "669",
              "display" : "其他金融輔助業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6691",
                  "display" : "投資顧問業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6699",
                  "display" : "未分類其他金融輔助業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "L",
      "display" : "不動產業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "67",
          "display" : "不動產開發業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "68",
          "display" : "不動產經營及相關服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "681",
              "display" : "不動產經營業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6811",
                  "display" : "不動產租售業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6812",
                  "display" : "不動產經紀業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "689",
              "display" : "其他不動產業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6891",
                  "display" : "不動產代管業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6892",
                  "display" : "不動產估價業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6899",
                  "display" : "未分類其他不動產業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "M",
      "display" : "專業、科學及技術服務業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "69",
          "display" : "法律及會計服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "691",
              "display" : "法律服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "6911",
                  "display" : "律師事務服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6912",
                  "display" : "地政士事務服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "6919",
                  "display" : "其他法律服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "692",
              "display" : "會計服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "70",
          "display" : "企業總管理機構及管理顧問業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "701",
              "display" : "企業總管理機構",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "702",
              "display" : "管理顧問業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "71",
          "display" : "建築、工程服務及技術檢測、分析服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "711",
              "display" : "建築、工程服務及相關技術顧問業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7111",
                  "display" : "建築服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7112",
                  "display" : "工程服務及相關技術顧問業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "712",
              "display" : "技術檢測及分析服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7121",
                  "display" : "環境檢測服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7129",
                  "display" : "其他技術檢測及分析服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "72",
          "display" : "研究發展服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "721",
              "display" : "自然及工程科學研究發展服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "722",
              "display" : "社會及人文科學研究發展服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "723",
              "display" : "綜合研究發展服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "73",
          "display" : "廣告業及市場研究業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "731",
              "display" : "廣告業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "732",
              "display" : "市場研究及民意調查業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "74",
          "display" : "專門設計業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "740",
              "display" : "專門設計業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7401",
                  "display" : "室內設計業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7402",
                  "display" : "工業設計業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7409",
                  "display" : "其他專門設計業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "75",
          "display" : "獸醫業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "76",
          "display" : "其他專業、科學及技術服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "760",
              "display" : "其他專業、科學及技術服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7601",
                  "display" : "攝影業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7602",
                  "display" : "翻譯業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7603",
                  "display" : "藝人及模特兒等經紀業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7609",
                  "display" : "未分類其他專業、科學及技術服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "N",
      "display" : "支援服務業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "77",
          "display" : "租賃業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "771",
              "display" : "機械設備租賃業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7711",
                  "display" : "營造用機械設備租賃業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7712",
                  "display" : "農業及其他工業用機械設備租賃業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7713",
                  "display" : "辦公用機械設備租賃業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7719",
                  "display" : "其他機械設備租賃業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "772",
              "display" : "運輸工具租賃業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "7721",
                  "display" : "汽車租賃業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "7729",
                  "display" : "其他運輸工具租賃業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "773",
              "display" : "個人及家庭用品租賃業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "774",
              "display" : "智慧財產租賃業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "78",
          "display" : "人力仲介及供應業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "781",
              "display" : "人力仲介業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "782",
              "display" : "人力供應業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "79",
          "display" : "旅行及其他相關服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "80",
          "display" : "保全及偵探業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "81",
          "display" : "建築物及綠化服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "811",
              "display" : "複合支援服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "812",
              "display" : "清潔服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8121",
                  "display" : "建築物一般清潔服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8129",
                  "display" : "其他清潔服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "813",
              "display" : "綠化服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "82",
          "display" : "行政支援服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "820",
              "display" : "行政支援服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8201",
                  "display" : "代收帳款及信用評等業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8202",
                  "display" : "會議及工商展覽服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8203",
                  "display" : "影印業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8209",
                  "display" : "其他行政支援服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "O",
      "display" : "公共行政及國防；強制性社會安全",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "83",
          "display" : "公共行政及國防；強制性社會安全",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "831",
              "display" : "公共行政",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8311",
                  "display" : "政府機關",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8312",
                  "display" : "民意機關",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "832",
              "display" : "國防事務",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "833",
              "display" : "強制性社會安全事務",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "84",
          "display" : "國際組織及外國機構",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        }
      ]
    },
    {
      "code" : "P",
      "display" : "教育業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "85",
          "display" : "教育業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "851",
              "display" : "學前教育",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "852",
              "display" : "小學教育",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "853",
              "display" : "國民中學教育",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "854",
              "display" : "高級中等教育",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "855",
              "display" : "大專校院",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "856",
              "display" : "特殊教育學校",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "858",
              "display" : "教育輔助業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "859",
              "display" : "其他教育業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8591",
                  "display" : "語言教育業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8592",
                  "display" : "藝術教育業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8593",
                  "display" : "運動及休閒教育業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8594",
                  "display" : "商業、資訊及專業管理教育業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8595",
                  "display" : "課業、升學及就業補習教育業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8599",
                  "display" : "未分類其他教育業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "Q",
      "display" : "醫療保健及社會工作服務業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "86",
          "display" : "醫療保健業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "861",
              "display" : "醫院",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "862",
              "display" : "診所",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "869",
              "display" : "其他醫療保健業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8691",
                  "display" : "醫學檢驗業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8699",
                  "display" : "未分類其他醫療保健業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "87",
          "display" : "居住型照顧服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "871",
              "display" : "居住型護理照顧服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8711",
                  "display" : "居住型長期照顧服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8719",
                  "display" : "其他居住型護理照顧服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "879",
              "display" : "其他居住型照顧服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8791",
                  "display" : "居住型身心障礙者照顧服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8792",
                  "display" : "居住型老人照顧服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8799",
                  "display" : "未分類其他居住型照顧服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "88",
          "display" : "其他社會工作服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "881",
              "display" : "居家式及社區式長期照顧服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8811",
                  "display" : "居家式長期照顧服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8812",
                  "display" : "社區式長期照顧服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "889",
              "display" : "未分類其他社會工作服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "8891",
                  "display" : "兒童及少年之社會工作服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "8899",
                  "display" : "其他未分類社會工作服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "R",
      "display" : "藝術、娛樂及休閒服務業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "90",
          "display" : "創作及藝術表演業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "901",
              "display" : "創作業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "902",
              "display" : "藝術表演業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "903",
              "display" : "創作及藝術表演輔助業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        },
        {
          "code" : "91",
          "display" : "圖書館、檔案保存、博物館及類似機構",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "910",
              "display" : "圖書館、檔案保存、博物館及類似機構",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9101",
                  "display" : "圖書館及檔案保存業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9102",
                  "display" : "植物園、動物園及自然生態保護機構",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9103",
                  "display" : "博物館、歷史遺址及其他類似機構",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "92",
          "display" : "博弈業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ]
        },
        {
          "code" : "93",
          "display" : "運動、娛樂及休閒服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "931",
              "display" : "運動服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9311",
                  "display" : "職業運動業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9312",
                  "display" : "運動場館",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9319",
                  "display" : "其他運動服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "932",
              "display" : "娛樂及休閒服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9321",
                  "display" : "遊樂園及主題樂園",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9322",
                  "display" : "視聽及視唱業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9323",
                  "display" : "特殊娛樂業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9324",
                  "display" : "遊戲場",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9329",
                  "display" : "其他娛樂及休閒服務業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "S",
      "display" : "其他服務業",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2021-01-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ],
      "concept" : [
        {
          "code" : "94",
          "display" : "宗教、職業及類似組織",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "941",
              "display" : "宗教組織",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "942",
              "display" : "職業團體",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9421",
                  "display" : "工商業團體",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9422",
                  "display" : "專門職業團體",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9423",
                  "display" : "勞工團體",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9424",
                  "display" : "農民團體",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "949",
              "display" : "其他組織",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9491",
                  "display" : "政黨",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9499",
                  "display" : "未分類其他組織",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "95",
          "display" : "個人及家庭用品維修業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "951",
              "display" : "汽車維修及美容業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9511",
                  "display" : "汽車維修業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9512",
                  "display" : "汽車美容業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "952",
              "display" : "電腦、通訊傳播設備及電子產品維修業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9521",
                  "display" : "電腦及其週邊設備維修業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9522",
                  "display" : "通訊傳播設備維修業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9523",
                  "display" : "視聽電子產品及家用電器維修業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "959",
              "display" : "其他個人及家庭用品維修業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9591",
                  "display" : "機車維修業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9599",
                  "display" : "未分類其他個人及家庭用品維修業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "96",
          "display" : "未分類其他服務業",
          "property" : [
            {
              "code" : "effectiveDate",
              "valueDateTime" : "2021-01-01"
            },
            {
              "code" : "status",
              "valueCode" : "active"
            }
          ],
          "concept" : [
            {
              "code" : "961",
              "display" : "洗衣業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "962",
              "display" : "美髮及美容美體業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ],
              "concept" : [
                {
                  "code" : "9621",
                  "display" : "美髮業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                },
                {
                  "code" : "9622",
                  "display" : "美容美體業",
                  "property" : [
                    {
                      "code" : "effectiveDate",
                      "valueDateTime" : "2021-01-01"
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "963",
              "display" : "殯葬及寵物生命紀念相關服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "964",
              "display" : "家事服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            },
            {
              "code" : "969",
              "display" : "其他個人服務業",
              "property" : [
                {
                  "code" : "effectiveDate",
                  "valueDateTime" : "2021-01-01"
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
