# 臺灣健保署2001年中文版ICD-9-CM - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣健保署2001年中文版ICD-9-CM 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-9-cm-2001-tw | *Version*:2023-05-09 |
| Active as of 2023-05-09 | *Computable Name*:TW2001ICD9CM |

 
臺灣健保署2001年中文版ICD-9-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。
代碼出版日期：2023-05-09；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TW2001ICD9CM](ValueSet-icd-9-cm-2001-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "icd-9-cm-2001-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-9-cm-2001-tw",
  "version" : "2023-05-09",
  "name" : "TW2001ICD9CM",
  "title" : "臺灣健保署2001年中文版ICD-9-CM",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-05-09",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署2001年中文版ICD-9-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。  \n代碼出版日期：2023-05-09；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱\n\n",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 18,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "001.0",
      "display" : "霍亂弧菌所致的霍亂",
      "definition" : "Cholera due to Vibrio cholerae",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "001.1",
      "display" : "異性霍亂弧菌所致霍亂",
      "definition" : "Cholera due to Vibrio cholerae el tor",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "001.9",
      "display" : "霍亂",
      "definition" : "Cholera, unspecified",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "002.0",
      "display" : "傷寒",
      "definition" : "Typhoid fever",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "002.1",
      "display" : "A型副傷寒",
      "definition" : "Paratyphoid fever A",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "002.2",
      "display" : "B型副傷寒",
      "definition" : "Paratyphoid fever B",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "002.3",
      "display" : "C型副傷寒",
      "definition" : "Paratyphoid fever C",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "002.9",
      "display" : "副傷寒",
      "definition" : "Paratyphoid fever, unspecified",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "003.0",
      "display" : "沙門桿菌胃腸炎",
      "definition" : "Salmonella gastroenteritis",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "003.1",
      "display" : "沙門桿菌敗血症",
      "definition" : "Salmonella septicemia",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "003.20",
      "display" : "局部沙門桿菌感染",
      "definition" : "Localized salmonella infection, unspecified",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "003.21",
      "display" : "沙門桿菌腦膜炎",
      "definition" : "Salmonella meningitis",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "003.22",
      "display" : "沙門桿菌肺炎",
      "definition" : "Salmonella pneumonia",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "003.23",
      "display" : "沙門桿菌關節炎",
      "definition" : "Salmonella arthritis",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "003.24",
      "display" : "沙門桿菌骨髓炎",
      "definition" : "Salmonella osteomyelitis",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "003.29",
      "display" : "其他局部沙門桿菌感染",
      "definition" : "Other localized salmonella infections",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "003.8",
      "display" : "其他特定的沙門桿菌感染",
      "definition" : "Other specified salmonella infections",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "003.9",
      "display" : "沙門桿菌感染",
      "definition" : "Salmonella infection , unspecified",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2023-05-09"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
