# 臺灣健保署2021年中文版ICD-10-PCS - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣健保署2021年中文版ICD-10-PCS 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2021-tw | *Version*:2022-07-29 |
| Active as of 2022-07-29 | *Computable Name*:TW2021ICD10PCS |
| **Copyright/Legal**: World Health Organization (WHO) | |

 
臺灣健保署2021年中文版ICD-10-PCS，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。
代碼出版日期：2022-07-29；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TW2021ICD10PCS](ValueSet-icd-10-pcs-2021-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "icd-10-pcs-2021-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2021-tw",
  "version" : "2022-07-29",
  "name" : "TW2021ICD10PCS",
  "title" : "臺灣健保署2021年中文版ICD-10-PCS",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-07-29",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署2021年中文版ICD-10-PCS，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。       \n代碼出版日期：2022-07-29；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱\n\n",
  "copyright" : "World Health Organization (WHO)",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 8,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "0016070",
      "display" : "開放性腦室至鼻咽繞道術，使用自體組織替代物",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-29"
        }
      ]
    },
    {
      "code" : "0016071",
      "display" : "開放性腦室至乳突竇繞道術，使用自體組織替代物",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-29"
        }
      ]
    },
    {
      "code" : "0016072",
      "display" : "開放性腦室至心房繞道術，使用自體組織替代物",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-29"
        }
      ]
    },
    {
      "code" : "0016073",
      "display" : "開放性腦室至血管繞道術，使用自體組織替代物",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-29"
        }
      ]
    },
    {
      "code" : "BH32ZZZ",
      "display" : "雙側乳房磁振造影",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "BR27ZZZ",
      "display" : "胸椎電腦斷層掃描",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "BU46ZZZ",
      "display" : "子宮超音波",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "BW40ZZZ",
      "display" : "腹部超音波",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
