# 臺灣衛福部資訊處類型代碼 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣衛福部資訊處類型代碼 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/category-code-tw | *Version*:2024-08-31 |
| Active as of 2024-08-31 | *Computable Name*:TWCategoryCode |
| **Copyright/Legal**: 衛生福利部資訊處 | |

 
臺灣衛福部資訊處類型代碼， 代碼出版日期：2024-08-31；資料所屬單位：衛生福利部資訊處。 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWCategoryCode](ValueSet-category-code-tw.md)
* [TWObservationScreeningAssessmentCategory](ValueSet-observation-screening-assessment-category.md)
* [TWServiceRequestCategory](ValueSet-serviceRequest-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "category-code-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/category-code-tw",
  "version" : "2024-08-31",
  "name" : "TWCategoryCode",
  "title" : "臺灣衛福部資訊處類型代碼",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-08-31",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣衛福部資訊處類型代碼， \n代碼出版日期：2024-08-31；資料所屬單位：衛生福利部資訊處。  \n",
  "copyright" : "衛生福利部資訊處",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 6,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "sdoh",
      "display" : "SDOH",
      "definition" : "Social Determinants of Health category",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-31"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "functional-status",
      "display" : "Functional Status",
      "definition" : "Functional Status category",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-31"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "disability-status",
      "display" : "Disability Status",
      "definition" : "Disability Status category",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-31"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "cognitive-status",
      "display" : "Cognitive Status",
      "definition" : "Cognitive Status category",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-31"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "treatment-intervention-preference",
      "display" : "Treatment Intervention Preference",
      "definition" : "A personal preference for a type of medical intervention (treatment) request under certain conditions.",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-31"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "care-experience-preference",
      "display" : "Care Experience Preference",
      "definition" : "Personal thoughts about something a person feels is relevant to their care experience and may be pertinent when planning their care.",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-31"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
