# 照護團隊 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example CareTeam: 照護團隊

Profile: [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md)

**status**: Active

**subject**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)

> **participant****role**:Neuropsychiatrist**member**:[Practitioner 王依昇(official)](Practitioner-pra-dr-example.md)

> **participant****role**:Registered nurse**member**:[Practitioner 陳莉(official)](Practitioner-pra-nurse-example.md)

> **participant****role**:Pharmacist**member**:[Practitioner 陳耀詩(official)](Practitioner-pra-phc-example.md)

> **participant****role**:Medical radiographer**member**:[Practitioner 王曉明(official)](Practitioner-pra-radio-example.md)



## Resource Content

```json
{
  "resourceType" : "CareTeam",
  "id" : "careteam-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
    ]
  },
  "status" : "active",
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "participant" : [
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "21450003",
              "display" : "Neuropsychiatrist"
            }
          ]
        }
      ],
      "member" : {
        "reference" : "Practitioner/pra-dr-example"
      }
    },
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "224535009",
              "display" : "Registered nurse"
            }
          ]
        }
      ],
      "member" : {
        "reference" : "Practitioner/pra-nurse-example"
      }
    },
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "46255001",
              "display" : "Pharmacist"
            }
          ]
        }
      ],
      "member" : {
        "reference" : "Practitioner/pra-phc-example"
      }
    },
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "159016003",
              "display" : "Medical radiographer"
            }
          ]
        }
      ],
      "member" : {
        "reference" : "Practitioner/pra-radio-example"
      }
    }
  ]
}

```
