# 海鮮過敏或不耐症 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example AllergyIntolerance: 海鮮過敏或不耐症

### 海鮮過敏

**臨床狀態**：Active ([AllergyIntoleranceClinicalStatusCodes](http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical)#active)

**驗證狀態**：Confirmed ([AllergyIntoleranceVerificationStatusCodes](http://terminology.hl7.org/CodeSystem/allergyintolerance-verification)#confirmed)

**根本原因或運作機制**：Allergy ([AllergyIntoleranceType](http://hl7.org/fhir/allergy-intolerance-type)#allergy)

**確定的物質的類別**：Food ([AllergyIntoleranceCategory](http://hl7.org/fhir/allergy-intolerance-category)#food)

**嚴重程度**：High Risk ([AllergyIntoleranceCriticality](http://hl7.org/fhir/allergy-intolerance-criticality)#high)

**過敏或不耐症的識別**：海鮮過敏(Seafood allergy) ([SNOMED CT](http://snomed.info/sct)#91937001)

**過敏或不耐症被識別的時間**：2023-02-10T18:45:00

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**紀錄者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**被記錄的日期**：2023-02-11T10:00:00

**關於過敏的資訊來源**：[Practitioner/pra-nurse-example](Practitioner-pra-nurse-example.md) "陳莉"

**最後一次已知反應發生的日期與時間**：2023-09-03T14:30:00

**暴露於此過敏或不耐症物質的不良反應**：

> **過敏產生的特定物質或醫藥產品**：海鮮(Seafood)([SNOMED CT](http://snomed.info/sct)#44027008)**與此事件相關的臨床症狀/體徵**：Upper respiratory tract hypersensitivity reaction([SNOMED CT](http://snomed.info/sct)#490008)**對整個過敏事件的描述**：皮膚發癢、呼吸急促**嚴重程度**：Severe([AllergyIntoleranceSeverity](http://hl7.org/fhir/reaction-event-severity)#severe)**如何接觸到該物質**：口服(Oral use)([SNOMED CT](http://snomed.info/sct)#26643006)**備註**：患者食用海鮮後出現皮膚發癢和呼吸急促，症狀於2023年2月11日上午10:00發作



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "all-seafood-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/AllergyIntolerance-twcore"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ],
    "text" : "Active"
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ],
    "text" : "Confirmed"
  },
  "type" : "allergy",
  "category" : ["food"],
  "criticality" : "high",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "91937001",
        "display" : "Seafood allergy"
      }
    ],
    "text" : "海鮮過敏"
  },
  "patient" : {
    "reference" : "Patient/pat-example",
    "display" : "陳加玲"
  },
  "onsetDateTime" : "2023-02-10T18:45:00Z",
  "recordedDate" : "2023-02-11T10:00:00Z",
  "recorder" : {
    "reference" : "Practitioner/pra-dr-example",
    "display" : "王依昇"
  },
  "asserter" : {
    "reference" : "Practitioner/pra-nurse-example",
    "display" : "陳莉"
  },
  "lastOccurrence" : "2024-02-11T10:00:00Z",
  "note" : [
    {
      "text" : "患者對海鮮過敏，可能導致皮膚發癢、呼吸急促"
    }
  ],
  "reaction" : [
    {
      "substance" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "44027008",
            "display" : "Seafood"
          }
        ],
        "text" : "海鮮"
      },
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "490008",
              "display" : "Upper respiratory tract hypersensitivity reaction"
            }
          ]
        }
      ],
      "description" : "皮膚發癢、呼吸急促",
      "severity" : "severe",
      "exposureRoute" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006",
            "display" : "Oral use"
          }
        ],
        "text" : "口服"
      },
      "note" : [
        {
          "text" : "患者食用海鮮後出現皮膚發癢和呼吸急促，症狀於2023年2月11日上午10:00發作"
        }
      ]
    }
  ]
}

```
