# 藥物過敏或不耐症 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example AllergyIntolerance: 藥物過敏或不耐症

### 藥物過敏

**臨床狀態**：Active ([AllergyIntoleranceClinicalStatusCodes](http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical)#active)

**驗證狀態**：Confirmed ([AllergyIntoleranceVerificationStatusCodes](http://terminology.hl7.org/CodeSystem/allergyintolerance-verification)#confirmed)

**根本原因或運作機制**：Allergy ([AllergyIntoleranceType](http://hl7.org/fhir/allergy-intolerance-type)#allergy)

**確定的物質的類別**：Medication ([AllergyIntoleranceCategory](http://hl7.org/fhir/allergy-intolerance-category)#medication)

**嚴重程度**：High Risk ([AllergyIntoleranceCriticality](http://hl7.org/fhir/allergy-intolerance-criticality)#high)

**過敏或不耐症的識別**：青黴素過敏(Penicillin allergy) ([SNOMED CT](http://snomed.info/sct)#91936005)

**過敏或不耐症被識別的時間**：2023-10-15T08:45:00

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**紀錄者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**被記錄的日期**：2023-10-15T12:00:00

**關於過敏的資訊來源**：[Practitioner/pra-nurse-example](Practitioner-pra-nurse-example.md) "陳莉"

**最後一次已知反應發生的日期與時間**：2023-12-05T15:30:00

**過敏或不耐受物質的不良反應紀錄**：

> **過敏產生的特定物質或醫藥產品**：青黴素(Medicinal product containing penicillin and acting as antibacterial agent (product))([SNOMED CT](http://snomed.info/sct)#6369005)**與此事件相關的臨床症狀/體徵)**：Upper respiratory tract hypersensitivity reaction([SNOMED CT](http://snomed.info/sct)#490008)**對整個過敏事件的描述**：呼吸急促、皮膚發紅**嚴重程度**：Severe([AllergyIntoleranceSeverity](http://hl7.org/fhir/reaction-event-severity)#severe)**如何接觸到該物質**：口服(Oral use)([SNOMED CT](http://snomed.info/sct)#26643006)**備註**：患者在服用青黴素後出現呼吸急促和皮膚發紅，症狀於2023年10月15日中午12:00發作



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "all-medication-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/AllergyIntolerance-twcore"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ],
    "text" : "Active"
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ],
    "text" : "Confirmed"
  },
  "type" : "allergy",
  "category" : ["medication"],
  "criticality" : "high",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "91936005",
        "display" : "Penicillin allergy"
      }
    ],
    "text" : "青黴素過敏"
  },
  "patient" : {
    "reference" : "Patient/pat-example",
    "display" : "陳加玲"
  },
  "onsetDateTime" : "2023-10-15T08:45:00Z",
  "recordedDate" : "2023-10-15T12:00:00Z",
  "recorder" : {
    "reference" : "Practitioner/pra-dr-example",
    "display" : "王依昇"
  },
  "asserter" : {
    "reference" : "Practitioner/pra-nurse-example",
    "display" : "陳莉"
  },
  "lastOccurrence" : "2023-10-15T12:00:00Z",
  "note" : [
    {
      "text" : "患者對青黴素過敏，可能導致呼吸急促、皮膚發紅"
    }
  ],
  "reaction" : [
    {
      "substance" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "6369005",
            "display" : "Medicinal product containing penicillin and acting as antibacterial agent (product)"
          }
        ],
        "text" : "青黴素"
      },
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "490008",
              "display" : "Upper respiratory tract hypersensitivity reaction"
            }
          ]
        }
      ],
      "description" : "呼吸急促、皮膚發紅",
      "severity" : "severe",
      "exposureRoute" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006",
            "display" : "Oral use"
          }
        ],
        "text" : "口服"
      },
      "note" : [
        {
          "text" : "患者在服用青黴素後出現呼吸急促和皮膚發紅，症狀於2023年10月15日中午12:00發作"
        }
      ]
    }
  ]
}

```
