The following key terms are used throughout this specification and are part of the IHE Glossary:


* **Medication Order** - any type of order for medicinal products - can be a proposal, a draft, a plan, a prescription or an instance order / Administration Request.  

* **Prescription** - an order given by a clinician (usually physicians and in some
particular cases pharmacists, nurses, etc.), for a medication to be dispensed to the patient and given to or taken by the patient.  

* **Dispense** - the act of assigning a medication to a patient, normally as indicated in the authorizing prescription.
  > Note: in many cases, the "dispense process" entails more activities, such as preparation, packaging, transport, etc. These vary according to the scenario - community or hospital, unit dose or traditional dispensing,... while the single differentiation activity that defines a Dispense is the assignment of a product that was available, to a specific patient.

* **dosage form** Form of the finished pharmaceutical product such as capsule, tablet, granulate, drops, suppository, etc.;

* **dosage regimen** Number of prescribed doses (e.g. in capsules of a specified strength, mg or ampoules, ml) within a given time period.

* **dosage unit** Typical dose taken by a patient; see also formulation dose Amount of a substance administered; see also formulation.

* **dose** Amount of a substance administered; see also formulation.

* **formulation** Form and composition under which a drug is presented as medicinal product; the f. is influenced by a number of factors such as the route of administration, chemical and biopharmaceutical properties of the substance (API), particle size (micronisation most often improves absorption); liquid f.s (especially aqueous solutions) can be administered by all routes but are bulky, more sensible to contamination and degradation and also more difficult to transport; if the drug is poorly soluble, suspensions (solid phase, i.e. particles distributed in liquid phase) or emulsions (two liquid phases, e.g. oil and water) may be produced; solid f.s appear most frequently as tablets (or orally disintegrating tablets) which frequently contain a number of excipients (e.g. lactose, cellulose), followed by capsules, usually made by hard or soft gelatine; capsules enclose the drug as powder or non-aqueous liquid within their two halves; other formulations can be prepared as liposomes, nanoparticles, or by microencapsulation, in particular if the API is poorly water soluble; semi-solid f.s are e.g. creams (oil/water emulsions) or ointments (water/oil emulsions) used in topical preparations for treatment of skin or mucous membranes; transdermal patches are applied like conventional sticking plasters and allow sustained drug release; coating is also a factor that influences the properties of a tablet;

* **excipient** Substances used in powder formulations in order to improve physical properties of the active ingredient such as stability, bioavailability or to enhance
any other attribute; excipients are carriers or diluents (providing plug-forming properties, e.g. lactose, mannitol, sucrose, glucose, icing sugar), lubricants
(reducing powder/metal adhesion, e.g. stearats, dimethicone, hydrogenated vegetable oils, liquid paraffin, polyethylene glycol, sodium stearyl fumarate),
glidants (improving powder flow e.g. for capsule-filling machines, e.g. colloidal silicon dioxide, Ca silicate), wetting agents (improving water penetration,
e.g. sodium lauryl sulfate, lecithin, polysorbate, polyoxyethylene stearate, sorbitan mono-oleate, polyethylene glycol 6000), disintegrants (producing disrup-
tion of powder mass, e.g. sodium starch glycolate, alginic acid, croscarmellose, crospovidone, carmellose calcium, sodium carboxyaminopectin) and stabiliz-
ers (improving product stability, e.g. ascorbic acid, ascorbyl palmitate, malic acid, propyl gallate, sodium metabisulphite); 

* **strength of medication** ; syn. potency; amount of active pharmaceutical ingredient per unit (e.g., “50 mg tablet”) or concentration; 

* **solvent** see excipients, residual solvents.

* **virtual medicinal product (VMP)** A conceptual definition of a medicine, opposed to a real-world marketed product. The focus is what the medicine is intended to be and not what is actually sold or dispensed. An example can be seen below:

|Term | Description|
|Virtual Medicinal Product | Paracetamol 500 mg tablet — *any tablet with 500mg of paracetamol*|
|Actual Medicinal Product | Paracetamol Cinfa 500 mg tablet — *a specific branded version*|
|Real Medicinal Product | The actual box or blister of Paracetamol Cinfa on the shelf|
{:.table-bordered .table-striped .thead-light}

Some defintions are or adpated from [Dictionary of Pharmaceutical Medicine](https://link.springer.com/book/10.1007/978-3-7091-1523-7)