# ihe.iti.pixm#3.1.0: Patient Identifier Cross-referencing for mobile (PIXm)

## Pages

* [1:41 PIXm Home](index.md)
* [Test Plan](5_testplan.md)
* [2:3.83 Mobile Patient Identifier Cross-reference Query [ITI-83]](ITI-83.md)
* [2:3:104 Patient Identity Feed FHIR [ITI-104]](ITI-104.md)
* [Significant Changes & Issues](a_issues.md)
* [Volume 1:41](volume-1.md)
* [Other](other.md)
* [Artifacts Summary](artifacts.md)
* [Download and Analysis](download.md)

## Resources

### Resource Profiles

* [Audit Event for Patient Identity Feed FHIR by the Manager that Creates a Patient](StructureDefinition-IHE.PIXm.Feed.Create.Audit.Manager.md)
* [Audit Event for Patient Identity Feed by the Manager that Deletes a Patient](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Manager.md)
* [Audit Event for Patient Identity Feed by the Source that Deletes a Patient](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Source.md)
* [Audit Event for Patient Identity Feed FHIR by the Manager that Updates a Patient](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Manager.md)
* [Audit Event for Patient Identity Feed by the Source that Creates or Updates a Patient](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Source.md)
* [PIXm Patient Profile example for additional Manager constraints](StructureDefinition-IHE.PIXm.Patient.BirthDateRequired.md)
* [PIXm Patient constraints for Feed](StructureDefinition-IHE.PIXm.Patient.md)
* [Audit Event for PIXm Query by the Consumer](StructureDefinition-IHE.PIXm.Query.Audit.Consumer.md)
* [Audit Event for PIXm Query by the Manager](StructureDefinition-IHE.PIXm.Query.Audit.Manager.md)
* [IHE PIXm Query Parameters In](StructureDefinition-IHE.PIXm.Query.Parameters.In.md)
* [IHE PIXm Query Parameters Out](StructureDefinition-IHE.PIXm.Query.Parameters.Out.md)

### CapabilityStatements

* [IHE ITI Patient Identifier Cross-referencing for mobile (PIXm) - Consumer (client)](CapabilityStatement-IHE.PIXm.Consumer.md)
* [IHE ITI Patient Identifier Cross-referencing for mobile (PIXm) - Manager (server)](CapabilityStatement-IHE.PIXm.Manager.md)
* [IHE ITI Patient Identifier Cross-referencing for mobile (PIXm) - Source (client)](CapabilityStatement-IHE.PIXm.Source.md)

### ImplementationGuides

* [Patient Identifier Cross-referencing for mobile (PIXm)](index.md)

### OperationDefinitions

* [Get Corresponding Identifiers Operation](OperationDefinition-IHE.PIXm.pix.md)

### Examples

* [ex-auditPixmFeed-create-manager (AuditEvent)](AuditEvent-ex-auditPixmFeed-create-manager.md)
* [ex-auditPixmFeed-delete-manager (AuditEvent)](AuditEvent-ex-auditPixmFeed-delete-manager.md)
* [ex-auditPixmFeed-delete-source (AuditEvent)](AuditEvent-ex-auditPixmFeed-delete-source.md)
* [ex-auditPixmFeed-update-manager (AuditEvent)](AuditEvent-ex-auditPixmFeed-update-manager.md)
* [ex-auditPixmFeed-update-source (AuditEvent)](AuditEvent-ex-auditPixmFeed-update-source.md)
* [ex-auditPixmFeedDelete-manager (AuditEvent)](AuditEvent-ex-auditPixmFeedDelete-manager.md)
* [ex-auditPixmFeedDelete-source (AuditEvent)](AuditEvent-ex-auditPixmFeedDelete-source.md)
* [ex-auditPixmQuery-consumer (AuditEvent)](AuditEvent-ex-auditPixmQuery-consumer.md)
* [ex-auditPixmQuery-manager (AuditEvent)](AuditEvent-ex-auditPixmQuery-manager.md)
* [ex-device (Device)](Device-ex-device.md)
* [pixm-response-error-not-found (OperationOutcome)](OperationOutcome-pixm-response-error-not-found.md)
* [pixm-request-mohralice-red-all (Parameters)](Parameters-pixm-request-mohralice-red-all.md)
* [pixm-request-mohralice-red-to-blue (Parameters)](Parameters-pixm-request-mohralice-red-to-blue.md)
* [pixm-response-mohralice-red-all (Parameters)](Parameters-pixm-response-mohralice-red-all.md)
* [pixm-response-mohralice-red-to-blue (Parameters)](Parameters-pixm-response-mohralice-red-to-blue.md)
* [Patient-MaidenAlice-Red (Patient)](Patient-Patient-MaidenAlice-Red.md)
* [Patient-MohrAlice-Blue (Patient)](Patient-Patient-MohrAlice-Blue.md)
* [Patient-MohrAlice-Green (Patient)](Patient-Patient-MohrAlice-Green.md)
* [Patient-MohrAlice-Red (Patient)](Patient-Patient-MohrAlice-Red.md)
* [Patient-MohrAlice (Patient)](Patient-Patient-MohrAlice.md)
* [Patient-MohrAlissa-Red (Patient)](Patient-Patient-MohrAlissa-Red.md)
* [Patient-MohrMaidenResolvedByMohrMalice-Red (Patient)](Patient-Patient-MohrMaidenResolvedByMohrMalice-Red.md)
* [ex-patient (Patient)](Patient-ex-patient.md)
