# PIXm Query with source identifier and target system - Patient Identifier Cross-referencing for mobile (PIXm) v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PIXm Query with source identifier and target system**

## Example Parameters: PIXm Query with source identifier and target system

Query with source patient identifier of Mohr Alice in Red Domain and requesting identifier in target domain Blue

```
GET [base]/Patient/$ihe-pix?sourceIdentifier=urn:oid:1.3.6.1.4.1.21367.13.20.1000|IHERED-994&targetSystem=urn:oid:1.3.6.1.4.1.21367.13.20.3000

```



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "pixm-request-mohralice-red-to-blue",
  "meta" : {
    "profile" : [
      "https://profiles.ihe.net/ITI/PIXm/StructureDefinition/IHE.PIXm.Query.Parameters.In"
    ]
  },
  "parameter" : [
    {
      "name" : "sourceIdentifier",
      "valueString" : "urn:oid:1.3.6.1.4.1.21367.13.20.1000|IHERED-994"
    },
    {
      "name" : "targetSystem",
      "valueString" : "urn:oid:1.3.6.1.4.1.21367.13.20.3000"
    },
    {
      "name" : "targetSystem",
      "valueString" : "urn:oid:1.3.6.1.4.1.21367.13.20.2000"
    },
    {
      "name" : "_format",
      "valueString" : "application/fhir+xml"
    }
  ]
}

```
